/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.teamload;

import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.ide.core.util.ITeamFutureListener;
import com.ibm.team.apt.internal.ide.core.util.Resolver;
import com.ibm.team.apt.internal.ide.core.util.TeamFuture;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureAdapter;
import com.ibm.team.apt.internal.ide.core.util.TeamFutureEvent;
import com.ibm.team.apt.internal.ide.ui.teamload.Messages;
import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadConfiguration;
import com.ibm.team.apt.internal.ide.ui.util.ContributorImageResolver;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.util.UITeamFutureAdapter;
import com.ibm.team.apt.internal.ide.ui.util.UserLabelProvider;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.LoadBarPainter;
import com.ibm.team.collaboration.core.CollaborationCore;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.FormColors;

public class TeamLoadLabelProvider
extends OwnerDrawLabelProvider {
    private static final boolean IS_CARBON = "carbon".equals(SWT.getPlatform());
    private static final Point IMAGE_SIZE = new Point(32, 32);
    private ItemMap<IContributorHandle, TeamFuture<Image>> fContributorImageCache = new ItemHashMap();
    private LocalResourceManager fResourceManager;
    private final TableViewer fViewer;
    private final TeamLoadConfiguration fConfiguration;
    private UserLabelProvider fUserLabelProvider;
    private LoadBarPainter fBarPainter;
    private Image fDefaultContributorImage;
    private TextLayout fTextLayout;
    private Font fContributorFont;
    private Font fStatusFont;
    private int fContributorFontHeight;
    private int fStatusFontHeight;
    private int fMinimalStatusTextWidth;
    private BarResources fBarResources;
    private int fBarHeight;

    public TeamLoadLabelProvider(TeamLoadConfiguration configuration, TableViewer viewer) {
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), viewer.getControl());
        this.fConfiguration = configuration;
        this.fViewer = viewer;
        this.createResources();
        OwnerDrawLabelProvider.setUpOwnerDraw((ColumnViewer)this.fViewer);
    }

    private void createResources() {
        Display display = this.fViewer.getControl().getDisplay();
        Font defaultFont = JFaceResources.getDefaultFont();
        this.fStatusFont = this.fResourceManager.createFont(TeamLoadLabelProvider.modifyFont(defaultFont, -(IS_CARBON ? 2 : 1), 0));
        this.fContributorFont = this.fResourceManager.createFont(TeamLoadLabelProvider.modifyFont(defaultFont, 0, 0));
        this.fTextLayout = new TextLayout((Device)display);
        this.fTextLayout.setText("FOO");
        this.fTextLayout.setFont(this.fContributorFont);
        this.fContributorFontHeight = this.fTextLayout.getBounds().height;
        this.fTextLayout.setFont(this.fStatusFont);
        this.fStatusFontHeight = this.fTextLayout.getBounds().height;
        this.fTextLayout.setText(Messages.TeamLoadLabelProvider_UTIL_MEASUREMENT_STRING);
        this.fMinimalStatusTextWidth = this.fTextLayout.getBounds().width;
        this.fBarResources = new BarResources((ResourceManager)this.fResourceManager, this.fStatusFont);
        this.fBarPainter = new LoadBarPainter(this.fBarResources);
        this.fDefaultContributorImage = this.fResourceManager.createImage(ImagePool.TEAM_UNKNOWN);
        this.fUserLabelProvider = new UserLabelProvider();
    }

    protected void measure(Event event, Object element) {
        Assert.isTrue((boolean)(element instanceof LoadItem));
        Assert.isTrue((boolean)(event.item instanceof TableItem));
        this.fBarHeight = this.fBarPainter.computeTrimHeight(this.fStatusFontHeight);
        int height1 = Math.max(TeamLoadLabelProvider.IMAGE_SIZE.y, this.fBarHeight + this.fStatusFontHeight);
        int height2 = this.fContributorFontHeight + this.fBarHeight + this.fStatusFontHeight + this.fStatusFontHeight / 4;
        event.height = Math.max(height1, height2);
        event.width = this.fMinimalStatusTextWidth + (this.fConfiguration.isShowImages() ? TeamLoadLabelProvider.IMAGE_SIZE.x : 0);
    }

    protected void erase(Event event, Object element) {
        GCState state;
        event.gc.setForeground(this.fBarResources.getOutline());
        event.gc.drawLine(event.x, event.y + event.height - 1, event.x + event.width - 1, event.y + event.height - 1);
        event.detail &= 0xFFFFFFEF;
        if ((event.detail & 2) != 0) {
            state = GCState.save(event.gc, 10);
            int alpha = FormColors.testTwoPrimaryColors((RGB)event.gc.getDevice().getSystemColor(26).getRGB(), (int)0, (int)120) ? 40 : 50;
            event.gc.setAlpha(alpha);
            event.gc.setBackground(event.gc.getDevice().getSystemColor(26));
            event.gc.fillRectangle(event.x, event.y, event.width, event.height - 1);
            event.detail &= 0xFFFFFFFD;
            state.restore();
        }
        if ((event.detail & 4) != 0) {
            state = GCState.save(event.gc, 2304);
            LineAttributes line = new LineAttributes(1.0f);
            line.style = 6;
            line.dash = new float[]{1.0f, 1.0f};
            event.gc.setLineAttributes(line);
            event.gc.setForeground(event.gc.getDevice().getSystemColor(24));
            event.gc.drawRectangle(event.x, event.y, event.width - 1, event.height - 1);
            state.restore();
            event.detail &= 0xFFFFFFFB;
        }
    }

    protected void paint(Event event, Object element) {
        Assert.isTrue((boolean)(element instanceof LoadItem));
        LoadItem item = (LoadItem)element;
        boolean showEstimate = item.getLoadInformation().getMode() == LoadInformation.Mode.TIME;
        boolean isOverbooked = LoadItems.isOverbooked((AbstractLoadItem)item);
        int x = event.x;
        int y = event.y;
        int padding = UI.height(this.fBarResources.getMessageFont());
        int width = -padding + Math.max(this.fMinimalStatusTextWidth + (this.fConfiguration.isShowImages() ? TeamLoadLabelProvider.IMAGE_SIZE.x : 0), ((TableItem)event.item).getParent().getClientArea().width);
        int height = event.height;
        if (this.fConfiguration.isShowImages()) {
            CollaborationPresenceStatus presence = CollaborationCore.getCollaborationService().getPresenceStatus((IContributorHandle)item.getContributor());
            Image overlay = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)CollaborationUI.getOverlayDescriptor((CollaborationPresenceStatus)presence));
            Rectangle overlayData = overlay.getBounds();
            int offset = Math.max(0, (height - TeamLoadLabelProvider.IMAGE_SIZE.y) / 2);
            Rectangle photoFrame = new Rectangle(x, y + offset, TeamLoadLabelProvider.IMAGE_SIZE.x, TeamLoadLabelProvider.IMAGE_SIZE.y);
            Image photo = this.resolveContributorImage(item);
            Rectangle photoData = photo.getBounds();
            event.gc.setBackground(this.fBarResources.getWhite());
            event.gc.fillRoundRectangle(photoFrame.x, photoFrame.y, photoFrame.width, photoFrame.height, 4, 4);
            event.gc.setForeground(this.fBarResources.getOutline());
            event.gc.drawRoundRectangle(photoFrame.x, photoFrame.y, photoFrame.width, photoFrame.height, 4, 4);
            event.gc.drawImage(photo, 0, 0, photoData.width, photoData.height, x + 2, y + offset + 2, TeamLoadLabelProvider.IMAGE_SIZE.x - 3, TeamLoadLabelProvider.IMAGE_SIZE.y - 3);
            event.gc.drawImage(overlay, x + TeamLoadLabelProvider.IMAGE_SIZE.x - overlayData.width + 1, y + TeamLoadLabelProvider.IMAGE_SIZE.y - overlayData.height + offset + 1);
            ImageDescriptor descriptor = CollaborationUI.getOverlayDescriptor((IContributorHandle)item.getContributor());
            if (descriptor != null) {
                overlay = JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor);
                event.gc.drawImage(overlay, x + TeamLoadLabelProvider.IMAGE_SIZE.x - 2 * overlayData.width + 1, y + TeamLoadLabelProvider.IMAGE_SIZE.y - overlayData.height + offset + 1);
            }
            event.item.setData("ITEM_BOUNDS", (Object)new Rectangle(x, y + offset, TeamLoadLabelProvider.IMAGE_SIZE.x, TeamLoadLabelProvider.IMAGE_SIZE.y));
            x += TeamLoadLabelProvider.IMAGE_SIZE.x + padding;
            width -= padding;
        } else {
            Image overlay = this.fUserLabelProvider.getImage(item.getContributor());
            Rectangle overlayData = overlay.getBounds();
            Color userColor = this.fUserLabelProvider.getForeground(item.getContributor());
            event.gc.setForeground(userColor != null ? userColor : this.fBarResources.getOutline());
            event.gc.setFont(this.fContributorFont);
            Point nameSize = event.gc.stringExtent(item.getContributor().getName());
            int tx = x;
            int offset = nameSize.y / 2 - overlayData.height / 2;
            event.gc.drawImage(overlay, tx, 1 + y + Math.max(0, offset));
            event.gc.drawString(item.getContributor().getName(), tx + 2 + overlayData.width, y + Math.max(0, -offset), true);
            event.item.setData("ITEM_BOUNDS", (Object)new Rectangle(tx, y, nameSize.x + 2 + overlayData.width, nameSize.y));
            y += Math.max(nameSize.y, overlayData.height) - event.gc.getFontMetrics().getDescent();
        }
        Rectangle barBounds = new Rectangle(x, y, width, this.fBarHeight);
        if (this.fConfiguration.isShowImages()) {
            int offset = Math.max(0, (event.height - (this.fBarHeight + this.fStatusFontHeight)) / 2);
            y += offset;
            barBounds.y += offset;
            barBounds.width -= TeamLoadLabelProvider.IMAGE_SIZE.x;
        }
        this.fBarPainter.paint(event.gc, barBounds, (AbstractLoadItem)item);
        event.item.setData("BAR_BOUNDS", (Object)barBounds);
        event.gc.setForeground(this.fBarResources.getBlack());
        event.gc.setFont(this.fStatusFont);
        String estInfo = LoadItems.getTextEstimate((AbstractLoadItem)item);
        Point sizeStr = event.gc.stringExtent(estInfo);
        event.gc.drawString(estInfo, x + barBounds.width - sizeStr.x, y += this.fBarHeight, true);
        this.fTextLayout.setFont(this.fStatusFont);
        if (showEstimate) {
            String text = LoadItems.getTextHours((AbstractLoadItem)item);
            this.fTextLayout.setText(text);
            Color color = isOverbooked ? this.fBarResources.getRed() : this.fBarResources.getGreen();
            int index1 = text.lastIndexOf(124);
            if (index1 != -1) {
                int index2 = text.lastIndexOf(104);
                if (index2 == -1) {
                    index2 = text.length();
                }
                this.fTextLayout.setStyle(new TextStyle(null, color, null), index1 + 1, Math.max(index1 + 1, index2 - 1));
            }
        } else {
            String text = LoadItems.getTextOpenClose((LoadItem)item);
            this.fTextLayout.setText(text);
        }
        this.fTextLayout.draw(event.gc, x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image resolveContributorImage(final LoadItem item) {
        TeamFuture future;
        ItemMap<IContributorHandle, TeamFuture<Image>> itemMap = this.fContributorImageCache;
        synchronized (itemMap) {
            future = (TeamFuture)this.fContributorImageCache.get((IItemHandle)item.getContributor());
            if (future != null) {
                if (future.isResolved()) {
                    return (Image)future.getResult();
                }
                return this.fDefaultContributorImage;
            }
        }
        Display display = this.fViewer.getControl().getDisplay();
        future = new TeamFuture((Resolver)new ContributorImageResolver(display, this.fResourceManager, (IContributorHandle)item.getContributor()));
        ItemMap<IContributorHandle, TeamFuture<Image>> itemMap2 = this.fContributorImageCache;
        synchronized (itemMap2) {
            this.fContributorImageCache.put((IItemHandle)item.getContributor(), (Object)future);
        }
        future.addListener(UITeamFutureAdapter.create(display, new TeamFutureAdapter<Image>(){

            public void resolvingDone(TeamFutureEvent<Image> event) {
                if (TeamLoadLabelProvider.this.fConfiguration.isShowImages()) {
                    TeamLoadLabelProvider.this.fViewer.update((Object)item, null);
                }
                future.removeListener((ITeamFutureListener)this);
            }
        }));
        return this.fDefaultContributorImage;
    }

    public void dispose() {
        this.fTextLayout.dispose();
        this.fUserLabelProvider.dispose();
        super.dispose();
    }

    private static FontDescriptor modifyFont(Font font, int size, int style) {
        FontData[] fontDef;
        FontData[] fontDataArray = fontDef = font.getFontData();
        int n = fontDef.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(data.getHeight() + size);
            data.setStyle(data.getStyle() | style);
            ++n2;
        }
        return FontDescriptor.createFrom((FontData[])fontDef);
    }
}

