/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.teamload;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.teamload.Messages;
import com.ibm.team.apt.internal.ide.ui.util.MemberAreaConfigurationPart;
import com.ibm.team.apt.internal.ide.ui.util.StatusDialogTeamExecutionContext;
import com.ibm.team.apt.internal.ide.ui.util.TeamStatusDialog;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TeamLoadDialog
extends TeamStatusDialog
implements IRunnableContext {
    private IProcessArea fProcessArea;
    private IProjectAreaHandle fProjectAreaHandle;
    private IDevelopmentLine fDevelopmentLine;
    private IIteration fIteration;
    private Composite fContents;
    private MemberAreaConfigurationPart fCurrentPart;
    private ControlEnableState fEnableState;
    private AtomicInteger fBusyCount = new AtomicInteger(0);

    public TeamLoadDialog(Shell parent, IProjectAreaHandle projectAreaHandle, IProcessArea processArea, IDevelopmentLine devLine, IIteration iteration) {
        super(parent);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.setTitle(Messages.TeamLoadDialog_CONFIGURE_TEAM_LOAD);
        this.setStatusLineAboveButtons(true);
        this.fProjectAreaHandle = projectAreaHandle;
        Assert.isNotNull((Object)this.fProjectAreaHandle);
        this.fProcessArea = processArea;
        this.fDevelopmentLine = devLine;
        this.fIteration = iteration;
    }

    public IProcessArea getProcessArea() {
        if (this.fCurrentPart != null) {
            return this.fCurrentPart.getProcessArea();
        }
        return this.fProcessArea;
    }

    public IIteration getIteration() {
        if (this.fCurrentPart != null) {
            return this.fCurrentPart.getIteration();
        }
        return this.fIteration;
    }

    public IDevelopmentLine getDevelopmentLine() {
        return this.fCurrentPart.getDevelopmentLine();
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.fContents = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)this.fContents);
        this.fContents.setLayout((Layout)new FillLayout());
        this.fCurrentPart = new MemberAreaConfigurationPart(this.fContents, 0, this.fProjectAreaHandle, this.fProcessArea, this.fDevelopmentLine, this.fIteration, this, new StatusDialogTeamExecutionContext(this, Messages.TeamLoadDialog_ERROR_DIALOG_TITLE, Messages.TeamLoadDialog_JOB_LABEL), this);
        Dialog.applyDialogFont((Control)this.fContents);
        UI.hookHelpListener((Control)this.fContents, "com.ibm.team.apt.ide.ui.dialog_teamLoad_config");
        return this.fContents;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        try {
            this.setBusy(true);
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)new NullProgressMonitor(), (Display)this.getShell().getDisplay());
        }
        finally {
            this.setBusy(false);
        }
    }

    private void setBusy(boolean b) {
        if (b) {
            this.fBusyCount.incrementAndGet();
        } else {
            this.fBusyCount.decrementAndGet();
        }
        this.reflectBusy();
    }

    private void reflectBusy() {
        if (this.getShell().isDisposed()) {
            return;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                switch (TeamLoadDialog.this.fBusyCount.get()) {
                    case 0: {
                        TeamLoadDialog.this.fEnableState.restore();
                        TeamLoadDialog.this.fEnableState = null;
                        if (TeamLoadDialog.this.fCurrentPart != null) {
                            TeamLoadDialog.this.fCurrentPart.updateMessage();
                            break;
                        }
                        TeamLoadDialog.this.updateStatus(Status.OK_STATUS);
                        break;
                    }
                    case 1: {
                        if (TeamLoadDialog.this.fEnableState != null) break;
                        TeamLoadDialog.this.updateStatus((IStatus)new Status(1, PlanningUIPlugin.getPluginId(), Messages.TeamLoadDialog_MSG_LOADING_DATA));
                        TeamLoadDialog.this.fEnableState = ControlEnableState.disable((Control)TeamLoadDialog.this.getContents(), Arrays.asList(TeamLoadDialog.this.getButton(1)));
                    }
                }
            }
        });
    }

    @Override
    public void updateStatus(IStatus status) {
        if (this.fCurrentPart != null && this.fCurrentPart.isInitialized() || status.getSeverity() != 4) {
            super.updateStatus(status);
        } else {
            Button ok = this.getButton(0);
            if (ok != null) {
                super.updateStatus((IStatus)new Status(1, status.getPlugin(), status.getMessage()));
                ok.setEnabled(false);
            } else {
                super.updateStatus((IStatus)new Status(4, status.getPlugin(), ""));
            }
        }
    }
}

