/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.teamload;

import com.ibm.team.apt.internal.ide.ui.teamload.TeamLoadSection;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IMemento;

public class TeamLoadConfiguration {
    private static final String REFRESH_INTERVAL = "REFRESH_INTERVAL";
    private static final String SHOW_IMAGES = "SHOW_IMAGES";
    private static final String REPO_URL = "REPO_URL";
    private static final String TEAM_AREA_UUID = "TEAM_AREA_UUID";
    private static final String PROCESS_AREA_ITEM_TYPE = "PROCESS_AREA_ITEM_TYPE";
    private static final String PROCESS_AREA_UUID = "PROCESS_AREA_UUID";
    private static final String DEV_LINE_UUID = "DEV_LINE_UUID";
    private static final String ITERATION_UUID = "ITERATION_UUID";
    private static final String PROJECT_AREA = String.valueOf(IProjectArea.ITEM_TYPE.getNamespaceURI()) + "/" + IProjectArea.ITEM_TYPE.getName();
    private static final String TEAM_AREA = String.valueOf(ITeamArea.ITEM_TYPE.getNamespaceURI()) + "/" + ITeamArea.ITEM_TYPE.getName();
    public static final String CURRENT = "CURRENT";
    private TeamLoadSection.Intervals fRefreshInterval;
    private boolean fShowImages;
    private String fRepositoryUrl;
    private String fProcessAreaType;
    private String fProcessAreaId;
    private String fDevLineId;
    private String fIterationId;

    public TeamLoadConfiguration() {
        this.initDefaults();
    }

    public void initDefaults() {
        this.fShowImages = true;
        this.fIterationId = CURRENT;
        this.fRefreshInterval = TeamLoadSection.Intervals.MIN_5;
    }

    public void loadState(IMemento memento) {
        String str;
        if (memento == null) {
            return;
        }
        Integer value = memento.getInteger(SHOW_IMAGES);
        if (value != null) {
            boolean bl = this.fShowImages = value == 1;
        }
        if ((value = memento.getInteger(REFRESH_INTERVAL)) != null && value >= 0 && value < TeamLoadSection.Intervals.values().length) {
            this.fRefreshInterval = TeamLoadSection.Intervals.values()[value];
        }
        if ((str = memento.getString(REPO_URL)) != null) {
            this.fRepositoryUrl = str;
        }
        if ((str = memento.getString(PROCESS_AREA_UUID)) != null) {
            this.fProcessAreaId = str;
            this.fProcessAreaType = memento.getString(PROCESS_AREA_ITEM_TYPE);
        } else {
            str = memento.getString(TEAM_AREA_UUID);
            if (str != null) {
                this.fProcessAreaId = str;
                this.fProcessAreaType = TEAM_AREA;
            }
        }
        str = memento.getString(DEV_LINE_UUID);
        if (str != null) {
            this.fDevLineId = str;
        }
        if ((str = memento.getString(ITERATION_UUID)) != null) {
            this.fIterationId = str;
        }
    }

    public void saveState(IMemento memento) {
        Assert.isNotNull((Object)memento);
        memento.putInteger(SHOW_IMAGES, this.fShowImages ? 1 : 0);
        memento.putInteger(REFRESH_INTERVAL, this.fRefreshInterval.ordinal());
        memento.putString(REPO_URL, this.fRepositoryUrl);
        memento.putString(PROCESS_AREA_ITEM_TYPE, this.fProcessAreaType);
        memento.putString(PROCESS_AREA_UUID, this.fProcessAreaId);
        if (this.fDevLineId != null) {
            memento.putString(DEV_LINE_UUID, this.fDevLineId);
        }
        memento.putString(ITERATION_UUID, this.fIterationId);
    }

    public boolean isConfigured() {
        return this.fRepositoryUrl != null && TEAM_AREA.equals(this.fProcessAreaType) ? this.fProcessAreaId != null && this.fIterationId != null : (this.fProcessAreaId != null && this.fIterationId != null && CURRENT.equals(this.fIterationId) ? this.fDevLineId != null : false);
    }

    public String getRepositoryUrl() {
        return this.fRepositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.fRepositoryUrl = repositoryUrl;
    }

    public IProcessAreaHandle getProcessAreaHandle() {
        if (this.fProcessAreaId == null || this.fProcessAreaType == null) {
            return null;
        }
        if (PROJECT_AREA.equals(this.fProcessAreaType)) {
            return (IProcessAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fProcessAreaId), null);
        }
        if (TEAM_AREA.equals(this.fProcessAreaType)) {
            return (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fProcessAreaId), null);
        }
        return null;
    }

    public void setProcessArea(IProcessAreaHandle handle) {
        this.fProcessAreaId = handle.getItemId().getUuidValue();
        if (handle instanceof IProjectAreaHandle) {
            this.fProcessAreaType = PROJECT_AREA;
        } else if (handle instanceof ITeamAreaHandle) {
            this.fProcessAreaType = TEAM_AREA;
        } else {
            Assert.isTrue((this.fProcessAreaType != null ? 1 : 0) != 0, (String)"Process area must be a project or team area");
        }
    }

    public IDevelopmentLineHandle getDevLineHandle() {
        if (this.fDevLineId == null || TEAM_AREA.equals(this.fProcessAreaType)) {
            return null;
        }
        return (IDevelopmentLineHandle)IDevelopmentLine.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.fDevLineId), null);
    }

    public void setDevLineHandle(IDevelopmentLineHandle handle) {
        this.fDevLineId = handle.getItemId().getUuidValue();
    }

    public boolean useCurrentIteration() {
        return this.fIterationId.equals(CURRENT);
    }

    public String getIterationId() {
        return this.fIterationId;
    }

    public void setIterationId(String iterationId) {
        this.fIterationId = iterationId;
    }

    public TeamLoadSection.Intervals getRefreshInterval() {
        return this.fRefreshInterval;
    }

    public void setRefreshInterval(TeamLoadSection.Intervals refreshInterval) {
        this.fRefreshInterval = refreshInterval;
    }

    public boolean isShowImages() {
        return this.fShowImages;
    }

    public void setShowImages(boolean showImages) {
        this.fShowImages = showImages;
    }
}

