/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.scripting.facades;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.rtc.common.scriptengine.AbstractScriptType;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptRunnable;
import com.ibm.team.rtc.common.scriptengine.annotation.Function;
import com.ibm.team.rtc.common.scriptengine.internal.util.IScriptingHelper;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Token;

@Stub(value="com.ibm.team.apt.ui.model.OptionsStore")
public class StoreScriptType
extends AbstractScriptType {
    private static final ErrorReporter PARSE_ERROR_HANDLER = new ErrorReporter(){

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            throw new UnsupportedOperationException();
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            throw new StoreParseException("Error parsing plan store: %s (%d:%d) [%s]", message, line, lineOffset, lineSource);
        }
    };
    private Scriptable fStoreObject;
    private Map<String, StoreScriptType> fSubStores;
    private final ResolvedIterationPlan fPlan;

    public StoreScriptType(Context cx, Scriptable scope, IMemento storeMemento, ResolvedIterationPlan plan) {
        super(cx, scope);
        this.fPlan = plan;
        String storeSource = storeMemento.getTextData();
        if (storeSource != null) {
            try {
                CompilerEnvirons options = new CompilerEnvirons();
                options.setErrorReporter(PARSE_ERROR_HANDLER);
                ScriptOrFnNode parsed = new Parser(options, PARSE_ERROR_HANDLER).parse(storeSource, "Plan Option Store (JSON)", 0);
                this.fStoreObject = (Scriptable)this.convert(cx, scope, (Node)parsed);
            }
            catch (StoreParseException e) {
                PlanningUIPlugin.log("failed to load plan option store", e);
            }
        }
        if (this.fStoreObject == null) {
            this.fStoreObject = cx.newObject(scope);
        }
    }

    private StoreScriptType(Context cx, Scriptable scope, Scriptable subStore, ResolvedIterationPlan plan) {
        super(cx, scope);
        this.fStoreObject = subStore;
        this.fPlan = plan;
    }

    public void serialize(IMemento serializeTo) {
        serializeTo.putTextData((String)ScriptableObject.callMethod((Scriptable)this.getUpdatedStoreObject(), (String)"toSource", (Object[])new Object[0]));
    }

    @Function
    public Scriptable load() {
        return this.fStoreObject;
    }

    @Function
    public void store(Scriptable store) {
        this.fStoreObject = store;
    }

    @Function
    public StoreScriptType subStore(IScriptEnvironment scriptEnvironment, String subStoreName) {
        StoreScriptType result;
        StoreScriptType storeScriptType = result = this.fSubStores != null ? this.fSubStores.get(subStoreName) : null;
        if (result == null) {
            Object storeContent = ScriptableObject.getProperty((Scriptable)this.fStoreObject, (String)subStoreName);
            if (!(storeContent instanceof Scriptable)) {
                storeContent = ((IScriptingHelper)scriptEnvironment.adapt(IScriptingHelper.class)).createSimpleObject();
            }
            final Scriptable finalStoreContent = (Scriptable)storeContent;
            result = (StoreScriptType)((Object)scriptEnvironment.execute((IScriptRunnable)new IScriptRunnable<StoreScriptType, RuntimeException>(){

                public StoreScriptType run(Context cx, Scriptable scope) throws RuntimeException {
                    return new StoreScriptType(cx, scope, finalStoreContent, StoreScriptType.this.fPlan, null);
                }
            }));
            if (this.fSubStores == null) {
                this.fSubStores = new HashMap<String, StoreScriptType>();
            }
            this.fSubStores.put(subStoreName, result);
        }
        return result;
    }

    @Function
    public void markDirty() {
        this.fPlan.setAuxiliaryDataChanged();
    }

    private Scriptable getUpdatedStoreObject() {
        if (this.fSubStores != null) {
            for (Map.Entry<String, StoreScriptType> storeEntry : this.fSubStores.entrySet()) {
                ScriptableObject.putProperty((Scriptable)this.fStoreObject, (String)storeEntry.getKey(), (Object)storeEntry.getValue().getUpdatedStoreObject());
            }
        }
        return this.fStoreObject;
    }

    private Object convert(Context cx, Scriptable scope, Node source) throws StoreParseException {
        switch (source.getType()) {
            case 133: 
            case 135: {
                return this.convert(cx, scope, source.getFirstChild());
            }
            case 66: {
                Object[] properties;
                Scriptable result = cx.newObject(scope);
                Node child = source.getFirstChild();
                Object[] objectArray = properties = (Object[])source.getProp(12);
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    Object property = objectArray[n2];
                    Object value = this.convert(cx, scope, child);
                    ScriptableObject.putProperty((Scriptable)result, (String)String.valueOf(property), (Object)value);
                    child = child.getNext();
                    ++n2;
                }
                return result;
            }
            case 65: {
                Scriptable result = cx.newArray(scope, 0);
                Node child = source.getFirstChild();
                int index = 0;
                while (child != null) {
                    Object value = this.convert(cx, scope, child);
                    ScriptableObject.putProperty((Scriptable)result, (int)index++, (Object)value);
                    child = child.getNext();
                }
                return result;
            }
            case 40: {
                return source.getDouble();
            }
            case 41: {
                return source.getString();
            }
            case 45: {
                return true;
            }
            case 44: {
                return false;
            }
            case 42: {
                return null;
            }
        }
        throw new StoreParseException("Unexpected node of type %s", Token.name((int)source.getType()));
    }

    /* synthetic */ StoreScriptType(Context context, Scriptable scriptable, Scriptable scriptable2, ResolvedIterationPlan resolvedIterationPlan, StoreScriptType storeScriptType) {
        this(context, scriptable, scriptable2, resolvedIterationPlan);
    }

    private static class StoreParseException
    extends RuntimeException {
        public StoreParseException(String messageFormat, Object ... args) {
            super(String.format(messageFormat, args));
        }
    }
}

