/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.scripting.facades;

import com.ibm.jdojo.lang.annotations.Stub;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.ColumnElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.RowElement;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.Messages;
import com.ibm.team.apt.internal.ide.ui.scripting.facades.GroupElementScriptType;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.rtc.common.scriptengine.annotation.Constructor;
import com.ibm.team.rtc.common.scriptengine.annotation.WrapType;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

@Stub(value="com.ibm.team.apt.ui.structure.ColumnElement")
@WrapType(value=ColumnElement.class)
public class ColumnElementScriptType
extends GroupElementScriptType {
    private static final String PARENT_COLUMN_ID = "column.parent";
    private static final String OTHER_WORKFLOWS_COLUMN = "other.workflows.column";

    public ColumnElementScriptType(Context cx, Scriptable scope, ColumnElement element) {
        super(cx, scope, element);
    }

    @Constructor
    public ColumnElementScriptType(Context cx, Scriptable scope, RowElement parent, int index, String workflowId, String stateId) {
        this(cx, scope, new ColumnElement(ColumnElementScriptType.getColumn(index, workflowId, stateId, parent.getParent().getPlan().getProjectArea()), stateId, parent));
    }

    private static ColumnDescription getColumn(int index, String workflowId, String stateId, IProjectArea projectArea) {
        if (PARENT_COLUMN_ID.equals(stateId)) {
            return new ColumnDescription(null, index);
        }
        if (OTHER_WORKFLOWS_COLUMN.equals(stateId)) {
            return new ColumnDescription(null, index);
        }
        if (workflowId == null) {
            switch (index) {
                case 1: {
                    return new StateGroupColumnDescription(Messages.TaskboardGroupByOwnerDescription_TODO_COLUMN_NAME, 1, 1, ImagePool.STATE_GROUP_TODO);
                }
                case 2: {
                    return new StateGroupColumnDescription(Messages.TaskboardGroupByOwnerDescription_INPROGRESS_COLUMN_NAME, 2, 4, ImagePool.STATE_GROUP_INPROGRESS);
                }
                case 3: {
                    return new StateGroupColumnDescription(Messages.TaskboardGroupByOwnerDescription_DONE_COLUMN_NAME, 3, 2, ImagePool.STATE_GROUP_DONE);
                }
            }
            PlanningUIPlugin.log(new IllegalArgumentException("Unknown state group: " + stateId + " at index " + index));
            return new ColumnDescription(null, index);
        }
        IWorkItemClient workItemClient = (IWorkItemClient)ClientUtils.getClientLibrary((IItemHandle)projectArea, IWorkItemClient.class);
        IWorkflowInfo workflow = ((WorkflowManager)workItemClient.getWorkflowManager()).getWorkflowInfo((IProjectAreaHandle)projectArea, workflowId, true, (IProgressMonitor)new NullProgressMonitor());
        if (workflow == null) {
            PlanningUIPlugin.log(new IllegalArgumentException("Unknown workflow: " + workflowId));
            return new ColumnDescription(null, index);
        }
        Identifier state = Identifier.create(IState.class, (String)stateId);
        String stateName = workflow.getStateName(state);
        if (stateName == null) {
            PlanningUIPlugin.log(new IllegalArgumentException("Unknown state: " + stateId));
            return new ColumnDescription(null, index);
        }
        ImageDescriptor icon = null;
        URL iconUrl = workflow.getStateIconName(state);
        if (iconUrl != null) {
            icon = ImageDescriptor.createFromURL((URL)iconUrl);
        }
        return new StateColumnDescription(stateName, icon, index, stateId);
    }

    private static class StateColumnDescription
    extends ColumnDescription {
        private final ImageDescriptor fImage;
        private final String fStateId;

        public StateColumnDescription(String label, ImageDescriptor image, int index, String id) {
            super(label, index);
            this.fImage = image;
            this.fStateId = id;
        }

        @Override
        public ImageDescriptor getImage() {
            return this.fImage;
        }

        @Override
        public boolean canAdopt(PlanItem item) {
            Identifier state = item.getState();
            if (state == null) {
                return false;
            }
            if (this.fStateId.equals(state.getStringIdentifier())) {
                return true;
            }
            return this.getAction(item) != null;
        }

        @Override
        public boolean adopt(PlanItem item) {
            Identifier state = item.getState();
            if (state == null) {
                return false;
            }
            if (this.fStateId.equals(state.getStringIdentifier())) {
                item.setWorkflowAction(null);
                return true;
            }
            Identifier<IWorkflowAction> action = this.getAction(item);
            if (action == null) {
                return false;
            }
            item.setWorkflowAction(action);
            return true;
        }

        private Identifier<IWorkflowAction> getAction(PlanItem item) {
            Identifier[] actionIds;
            IWorkflowInfo workflowInfo = item.getWorkflowInfo();
            Identifier[] identifierArray = actionIds = workflowInfo.getActionIds(item.getState());
            int n = actionIds.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier action = identifierArray[n2];
                Identifier actionResultState = workflowInfo.getActionResultState(action);
                if (this.fStateId.equals(Utils.stripOffPrefix((String)actionResultState.getStringIdentifier(), (char)'s'))) {
                    return action;
                }
                ++n2;
            }
            return null;
        }
    }

    private static class StateGroupColumnDescription
    extends ColumnDescription {
        private final int fWorkflowStateGroupId;
        private ImageDescriptor fImage;

        public StateGroupColumnDescription(String label, int index, int workflowStateGroupId, ImageDescriptor image) {
            super(label, index);
            this.fWorkflowStateGroupId = workflowStateGroupId;
            this.fImage = image;
        }

        @Override
        public boolean canAdopt(PlanItem item) {
            IWorkflowInfo workflowInfo = item.getWorkflowInfo();
            if (this.getWorkflowStateGroupId() == workflowInfo.getStateGroup(item.getState())) {
                return true;
            }
            return this.getAction(workflowInfo, (Identifier<IState>)item.getState(), this.getWorkflowStateGroupId()) != null;
        }

        @Override
        public boolean adopt(PlanItem item) {
            IWorkflowInfo workflowInfo = item.getWorkflowInfo();
            if (this.getWorkflowStateGroupId() == workflowInfo.getStateGroup(item.getState())) {
                item.setWorkflowAction(null);
                return true;
            }
            Identifier<IWorkflowAction> action = this.getAction(workflowInfo, (Identifier<IState>)item.getState(), this.getWorkflowStateGroupId());
            if (action == null) {
                return false;
            }
            item.setWorkflowAction(action);
            return true;
        }

        public int getWorkflowStateGroupId() {
            return this.fWorkflowStateGroupId;
        }

        @Override
        public ImageDescriptor getImage() {
            return this.fImage;
        }

        private Identifier<IWorkflowAction> getAction(IWorkflowInfo workflowInfo, Identifier<IState> sourceState, int targetGroup) {
            Identifier[] actionIds = workflowInfo.getActionIds(sourceState);
            if (actionIds.length == 0) {
                return null;
            }
            Identifier[] identifierArray = actionIds;
            int n = actionIds.length;
            int n2 = 0;
            while (n2 < n) {
                Identifier action = identifierArray[n2];
                Identifier actionResultState = workflowInfo.getActionResultState(action);
                if (workflowInfo.getStateGroup(actionResultState) == targetGroup) {
                    return action;
                }
                ++n2;
            }
            return null;
        }

        public boolean match(Identifier<IState> state, Identifier<IWorkflowAction> workflowAction, IWorkflowInfo workflowInfo) {
            if (workflowAction == null) {
                return workflowInfo.getStateGroup(state) == this.getWorkflowStateGroupId();
            }
            Identifier resultState = workflowInfo.getActionResultState(workflowAction);
            return workflowInfo.getStateGroup(resultState) == this.getWorkflowStateGroupId();
        }
    }
}

