/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.widgets;

import com.ibm.team.apt.internal.ide.ui.resource.widgets.Messages;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.PlatformUI;

public final class WorkResourceDetailsDialog
extends StatusDialog {
    private static final boolean SHOW_DYNAMIC = false;
    private final boolean fAllowDynamic;
    private int fAssignment;
    private int fPreviousDynamic = Integer.MIN_VALUE;
    private int fPreviousFixed = Integer.MIN_VALUE;

    public WorkResourceDetailsDialog(Shell parent, String title, int assignment, boolean allowDynamic) {
        super(parent);
        this.setTitle(title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fAssignment = assignment;
        this.fAllowDynamic = allowDynamic;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.team.apt.ide.ui.dialog_resource_details");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        composite.setLayout((Layout)layout);
        this.createPercentageControls(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createPercentageControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        final Button noneButton = new Button(composite, 16);
        noneButton.setText(Messages.WorkResourceDetailsDialog_DO_NOT_ASSIGN);
        noneButton.setSelection(this.fAssignment == 0);
        noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (noneButton.getSelection()) {
                    WorkResourceDetailsDialog.this.fAssignment = 0;
                }
            }
        });
        GridData data = new GridData();
        data.verticalIndent = 8;
        data.horizontalSpan = 2;
        noneButton.setLayoutData((Object)data);
        final Button fixedButton = new Button(composite, 16);
        fixedButton.setText(Messages.WorkResourceDetailsDialog_FIXED_ASSIGNMENT);
        fixedButton.setSelection(this.fAssignment > 0);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(48);
        fixedButton.setLayoutData((Object)data);
        final Spinner spinner = new Spinner(composite, 2112);
        spinner.setValues(this.fAssignment, 0, 100, 0, 1, 10);
        spinner.setEnabled(this.fAssignment > 0);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WorkResourceDetailsDialog.this.fAssignment = spinner.getSelection();
            }
        });
        spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkResourceDetailsDialog.this.fAssignment = spinner.getSelection();
            }
        });
        data = new GridData();
        data.horizontalIndent = 8;
        data.verticalIndent = 8;
        spinner.setLayoutData((Object)data);
        final Label label = new Label(composite, 64);
        label.setEnabled(this.fAssignment > 0);
        label.setText(Messages.WorkResourceDetailsDialog_PERCENT_LABEL);
        data = new GridData();
        data.verticalIndent = 8;
        label.setLayoutData((Object)data);
        fixedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selection = fixedButton.getSelection();
                spinner.setEnabled(selection);
                label.setEnabled(selection);
                if (!selection) {
                    WorkResourceDetailsDialog.this.fPreviousFixed = WorkResourceDetailsDialog.this.fAssignment;
                    spinner.setSelection(0);
                } else if (WorkResourceDetailsDialog.this.fAssignment < 1) {
                    if (WorkResourceDetailsDialog.this.fPreviousFixed != Integer.MIN_VALUE) {
                        WorkResourceDetailsDialog.this.fAssignment = WorkResourceDetailsDialog.this.fPreviousFixed;
                    } else {
                        WorkResourceDetailsDialog.this.fAssignment = 1;
                    }
                    spinner.setSelection(WorkResourceDetailsDialog.this.fAssignment);
                } else {
                    spinner.setSelection(WorkResourceDetailsDialog.this.fAssignment);
                }
            }
        });
    }

    public int getAssignment() {
        return this.fAssignment;
    }
}

