/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.widgets;

import com.ibm.icu.util.Calendar;
import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.common.util.Dates;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.DatePickerWidget;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.Messages;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.apt.internal.ide.ui.util.SWTUtil;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class ContributorAbsenceDialog
extends StatusDialog {
    private DateFormat fDateFormat = DateFormat.getDateInstance(2);
    private Date fEndDate;
    private Text fEndField;
    private final ItemCollection<IContributorAbsence> fExistingAbsences;
    private final String fMessage;
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Date fStartDate;
    private Text fStartField;
    private String fSummary = "";
    private Text fSummaryField;

    public ContributorAbsenceDialog(Shell parent, String title, String message, IContributorAbsence absence, ItemCollection<IContributorAbsence> existing) {
        super(parent);
        this.setTitle(title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMessage = message;
        this.fExistingAbsences = existing;
        if (absence != null) {
            this.fSummary = absence.getSummary();
            this.fStartDate = absence.getStartDate();
            this.fEndDate = absence.getEndDate();
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            Dates.setGMTHighNoon((Calendar)calendar);
            this.fStartDate = this.fEndDate = calendar.getTime();
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.ibm.team.apt.ide.ui.dialog_absence");
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(!"".equals(this.fSummary) && this.fStartDate != null && this.fEndDate != null);
    }

    private void createDateControls(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fStartField = this.createDatePicker(container, Messages.ContributorAbsenceDialog_FIRST_DAY);
        this.fStartField.setText(this.fDateFormat.format(this.fStartDate));
        this.fStartField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    ContributorAbsenceDialog.this.fStartDate = ContributorAbsenceDialog.this.fDateFormat.parse(ContributorAbsenceDialog.this.fStartField.getText());
                }
                catch (ParseException exception) {
                    ContributorAbsenceDialog.this.fStartDate = null;
                }
                if (ContributorAbsenceDialog.this.fStartDate != null && ContributorAbsenceDialog.this.fEndDate != null && ContributorAbsenceDialog.this.fStartDate.after(ContributorAbsenceDialog.this.fEndDate)) {
                    ContributorAbsenceDialog.this.fEndDate = ContributorAbsenceDialog.this.fStartDate;
                    ContributorAbsenceDialog.this.fEndField.setText(ContributorAbsenceDialog.this.fDateFormat.format(ContributorAbsenceDialog.this.fEndDate));
                }
                ContributorAbsenceDialog.this.handleSettingsChanged();
            }
        });
        this.fEndField = this.createDatePicker(container, Messages.ContributorAbsenceDialog_LAST_DAY);
        this.fEndField.setText(this.fDateFormat.format(this.fEndDate));
        this.fEndField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    ContributorAbsenceDialog.this.fEndDate = ContributorAbsenceDialog.this.fDateFormat.parse(ContributorAbsenceDialog.this.fEndField.getText());
                }
                catch (ParseException exception) {
                    ContributorAbsenceDialog.this.fEndDate = null;
                }
                ContributorAbsenceDialog.this.handleSettingsChanged();
            }
        });
    }

    private Text createDatePicker(Composite parent, final String description) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)description);
        Label label = new Label(parent, 0);
        label.setText(description);
        Text datePickerText = new DatePickerWidget(parent, this.fDateFormat, this.fResourceManager, null).getText();
        datePickerText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SWTUtil.filterMnemonics(description);
            }
        });
        return datePickerText;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        composite.setLayout((Layout)layout);
        this.createSummaryControls(composite);
        Label dummy = new Label(composite, 0);
        GridData data = new GridData();
        data.heightHint = new PixelConverter((Control)composite).convertHeightInCharsToPixels(1) / 2;
        dummy.setLayoutData((Object)data);
        this.createDateControls(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ContributorAbsenceDialog.this.fResourceManager.dispose();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createSummaryControls(Composite composite) {
        Label label = new Label(composite, 16448);
        label.setText(this.fMessage);
        this.fSummaryField = new Text(composite, 2052);
        this.fSummaryField.setText(this.fSummary);
        if (!"".equals(this.fSummary)) {
            this.fSummaryField.selectAll();
        }
        this.fSummaryField.setFocus();
        this.fSummaryField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ContributorAbsenceDialog.this.fSummary = ContributorAbsenceDialog.this.fSummaryField.getText();
                ContributorAbsenceDialog.this.handleSettingsChanged();
            }
        });
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.fSummaryField.setLayoutData((Object)data);
    }

    private IContributorAbsence getCoveredAbsence(Date startDate, Date endDate) {
        if (this.fExistingAbsences == null || this.fExistingAbsences.isEmpty()) {
            return null;
        }
        for (IContributorAbsence existing : this.fExistingAbsences) {
            Date existingStart = existing.getStartDate();
            Date existingEnd = existing.getEndDate();
            if (existingStart.after(endDate) || existingEnd.before(startDate)) continue;
            return existing;
        }
        return null;
    }

    public Date getEndDate() {
        if (this.fEndDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.fEndDate);
            Dates.setGMTHighNoon((Calendar)calendar);
            this.fEndDate = calendar.getTime();
        }
        return this.fEndDate;
    }

    public Date getStartDate() {
        if (this.fStartDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.fStartDate);
            Dates.setGMTHighNoon((Calendar)calendar);
            this.fStartDate = calendar.getTime();
        }
        return this.fStartDate;
    }

    public String getSummary() {
        return this.fSummary;
    }

    void handleSettingsChanged() {
        String summary = this.fSummaryField.getText();
        if ("".equals(summary)) {
            this.updateStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 0, Messages.ContributorAbsenceDialog_ENTER_SUMMARY, null));
            return;
        }
        if (this.fStartDate == null) {
            this.updateStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 0, Messages.ContributorAbsenceDialog_ENTER_VALID_START_DATE, null));
            return;
        }
        if (this.fEndDate == null) {
            this.updateStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 0, Messages.ContributorAbsenceDialog_ENTER_VALID_END_DATE, null));
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.fStartDate);
        Dates.setGMTHighNoon((Calendar)calendar);
        Date startDate = calendar.getTime();
        calendar.setTime(this.fEndDate);
        Dates.setGMTHighNoon((Calendar)calendar);
        Date endDate = calendar.getTime();
        if (startDate.after(endDate)) {
            this.updateStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), 0, Messages.ContributorAbsenceDialog_END_DATE_AFTER_START_DATE, null));
            return;
        }
        IContributorAbsence absence = this.getCoveredAbsence(this.fStartDate, this.fEndDate);
        if (absence != null) {
            this.updateStatus((IStatus)new Status(2, PlanningUIPlugin.getPluginId(), 0, MessageFormat.format(Messages.ContributorAbsenceDialog_ABSENCE_OVERLAPS, absence.getSummary()), null));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

