/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.common.resource.IWorkResourceDetails;
import com.ibm.team.apt.internal.ide.ui.actions.OpenWorkDetailsAction;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.apt.internal.ide.ui.resource.parts.AbstractContributorResourceFormPart;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public final class WorkResourceDetailsPart
extends AbstractContributorResourceFormPart {
    private static final AbstractResourceDetailsNode[] NO_CHILDREN = new AbstractResourceDetailsNode[0];
    public static final String PART_ID = "com.ibm.team.apt.resource.work.resource.details.part.name";
    private Link fOpenWebUI;
    private IProgressMonitor fMonitor = null;
    private final StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

    public WorkResourceDetailsPart(AbstractContributorResourceFormPage page) {
        super(page);
        this.setId(PART_ID);
    }

    public void createContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (WorkResourceDetailsPart.this.fMonitor != null && !WorkResourceDetailsPart.this.fMonitor.isCanceled()) {
                        WorkResourceDetailsPart.this.fMonitor.setCanceled(true);
                    }
                }
            }
        });
        this.createLink(parent);
    }

    private void createLink(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fOpenWebUI = new Link(parent, 0);
        this.fOpenWebUI.setText(Messages.WorkResourceDetailsPart_WORK_DETAILS_DISABLED);
        this.fOpenWebUI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractContributorResourceInput input = WorkResourceDetailsPart.this.getInput();
                OpenWorkDetailsAction action = new OpenWorkDetailsAction(input);
                action.run(null);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fStandardLabelProvider.dispose();
    }

    boolean hasDefaultWorkDetails(AbstractResourceDetailsNode[] nodes) {
        AbstractResourceDetailsNode[] abstractResourceDetailsNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkResourceDetails details;
            AbstractResourceDetailsNode node = abstractResourceDetailsNodeArray[n2];
            if (this.hasDefaultWorkDetails(node.getChildren())) {
                return true;
            }
            IAuditable auditable = node.getAuditable();
            if (auditable instanceof IWorkResourceDetails && !(details = (IWorkResourceDetails)auditable).isCustomized()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean hasObsolete(AbstractResourceDetailsNode[] nodes) {
        boolean result = false;
        int i = 0;
        while (!result && i < nodes.length) {
            AbstractResourceDetailsNode node = nodes[i];
            result |= this.hasObsolete(node.getChildren());
            result |= node.isObsolete();
            ++i;
        }
        return result;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    private static abstract class AbstractResourceDetailsNode {
        private AbstractResourceDetailsNode() {
        }

        public boolean equals(Object object) {
            if (object instanceof AbstractResourceDetailsNode) {
                AbstractResourceDetailsNode node = (AbstractResourceDetailsNode)object;
                return node.getAuditable().sameItemId((IItemHandle)this.getAuditable());
            }
            return false;
        }

        public abstract int getAssignment();

        public abstract IAuditable getAuditable();

        public AbstractResourceDetailsNode[] getChildren() {
            return NO_CHILDREN;
        }

        public abstract String getName();

        public int hashCode() {
            return this.getAuditable().getItemId().hashCode();
        }

        public abstract boolean isArchived();

        public abstract boolean isCustomized();

        public boolean isObsolete() {
            return this.isArchived() && this.getAssignment() > 0;
        }
    }
}

