/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.TimeZone;
import com.ibm.team.apt.common.resource.IContributorResourceDetails;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.client.resource.OperationStatus;
import com.ibm.team.apt.internal.common.resource.TimeZoneInfo;
import com.ibm.team.apt.internal.common.resource.model.WorkLocationDefinition;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.apt.internal.ide.ui.resource.parts.AbstractContributorResourceFormPart;
import com.ibm.team.apt.internal.ide.ui.resource.parts.IWorkLocationListener;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.internal.ide.ui.editors.contributor.ContributorEditor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class WorkLocationDefinitionPart
extends AbstractContributorResourceFormPart {
    private static final ISchedulingRule EXCLUSIVE_SCHEDULING_RULE = new ExclusiveSchedulingRule();
    public static final String PART_ID = "com.ibm.team.apt.resource.work.location.definition.part.name";
    private static final long TIME_ZONE_OFFSET_SEED_MILLIS = 0L;
    private static final Locale USER_INTERFACE_LOCALE = new Locale(Messages.WorkLocationDefinitionPart_LANGUAGE, Messages.WorkLocationDefinitionPart_COUNTRY, Messages.WorkLocationDefinitionPart_VARIANT);
    private Locale fCurrentLocale;
    private TimeZone fCurrentTimeZone;
    private Combo fLocaleCombo;
    private final Map<String, Locale> fLocaleMap = Collections.synchronizedMap(new HashMap(128));
    private IProgressMonitor fMonitor = null;
    private Combo fTimeZoneCombo;
    private final Map<String, TimeZone> fTimeZoneMap = Collections.synchronizedMap(new HashMap(TimeZoneInfo.getCount()));
    private ListenerList fWorkLocationListeners = new ListenerList(1);
    private final Map<String, Integer> fZoneOffsetMap = Collections.synchronizedMap(new HashMap(TimeZoneInfo.getCount()));

    public WorkLocationDefinitionPart(AbstractContributorResourceFormPage page) {
        super(page);
        this.setId(PART_ID);
    }

    public void addWorkLocationListener(IWorkLocationListener listener) {
        Assert.isNotNull((Object)listener);
        this.fWorkLocationListeners.add((Object)listener);
    }

    public void createContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (WorkLocationDefinitionPart.this.fMonitor != null && !WorkLocationDefinitionPart.this.fMonitor.isCanceled()) {
                        WorkLocationDefinitionPart.this.fMonitor.setCanceled(true);
                    }
                }
            }
        });
        Composite composite = toolkit.createComposite(parent);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Text sectionLabel = toolkit.createText(composite, Messages.WorkLocationDefinitionPart_WORK_DAY_USE_HINT, 72);
        sectionLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        Label dummy = toolkit.createLabel(composite, "");
        GridData data = new GridData();
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(1) / 3;
        dummy.setLayoutData((Object)data);
        Label label = toolkit.createLabel(composite, Messages.WorkLocationDefinitionPart_TIME_ZONE_LABEL, 64);
        label.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fTimeZoneCombo = this.createTimeZoneCombo(composite);
        dummy = toolkit.createLabel(composite, "");
        data = new GridData();
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(1) / 4;
        dummy.setLayoutData((Object)data);
        label = toolkit.createLabel(composite, Messages.WorkLocationDefinitionPart_REGIONAL_SETTINGS_LABEL, 64);
        label.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fLocaleCombo = this.createLocaleCombo(composite);
    }

    private Combo createLocaleCombo(Composite composite) {
        Assert.isNotNull((Object)composite);
        FormToolkit toolkit = this.getToolkit();
        final Combo combo = new Combo(composite, 2056);
        toolkit.adapt((Control)combo, true, true);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                int index = combo.getSelectionIndex();
                if (index >= 0) {
                    String item = combo.getItem(index);
                    Locale locale = (Locale)WorkLocationDefinitionPart.this.fLocaleMap.get(item);
                    if (locale != null && !locale.equals(WorkLocationDefinitionPart.this.fCurrentLocale)) {
                        WorkLocationDefinitionPart.this.fCurrentLocale = locale;
                        WorkLocationDefinitionPart.this.fireLocaleChanged(locale);
                        WorkLocationDefinitionPart.this.getFormPage().setDirty(true);
                    }
                }
            }
        });
        GridData data = new GridData(1, 1, false, false);
        data.widthHint = new PixelConverter((Control)composite).convertWidthInCharsToPixels(56);
        combo.setLayoutData((Object)data);
        combo.add(Messages.WorkLocationDefinitionPart_PENDING_LABEL, 0);
        combo.select(0);
        combo.setEnabled(false);
        return combo;
    }

    private Combo createTimeZoneCombo(Composite composite) {
        Assert.isNotNull((Object)composite);
        FormToolkit toolkit = this.getToolkit();
        final Combo combo = new Combo(composite, 2056);
        toolkit.adapt((Control)combo, true, true);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Assert.isNotNull((Object)event);
                int index = combo.getSelectionIndex();
                if (index >= 0) {
                    String item = combo.getItem(index);
                    TimeZone zone = (TimeZone)WorkLocationDefinitionPart.this.fTimeZoneMap.get(item);
                    if (zone != null && !zone.equals((Object)WorkLocationDefinitionPart.this.fCurrentTimeZone)) {
                        WorkLocationDefinitionPart.this.fCurrentTimeZone = zone;
                        WorkLocationDefinitionPart.this.fireTimeZoneChanged(zone);
                        WorkLocationDefinitionPart.this.getFormPage().setDirty(true);
                    }
                }
            }
        });
        GridData data = new GridData(1, 1, false, false);
        data.widthHint = new PixelConverter((Control)composite).convertWidthInCharsToPixels(56);
        combo.setLayoutData((Object)data);
        combo.add(Messages.WorkLocationDefinitionPart_PENDING_LABEL, 0);
        combo.select(0);
        combo.setEnabled(false);
        return combo;
    }

    private void fireLocaleChanged(final Locale locale) {
        Object[] listeners;
        Assert.isNotNull((Object)locale);
        Object[] objectArray = listeners = this.fWorkLocationListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            final IWorkLocationListener listener = (IWorkLocationListener)object;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    PlanningUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.localeChanged(locale);
                }
            });
            ++n2;
        }
    }

    private void fireTimeZoneChanged(final TimeZone zone) {
        Object[] listeners;
        Assert.isNotNull((Object)zone);
        Object[] objectArray = listeners = this.fWorkLocationListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            final IWorkLocationListener listener = (IWorkLocationListener)object;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    PlanningUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.timeZoneChanged(zone);
                }
            });
            ++n2;
        }
    }

    public void removeWorkLocationListener(IWorkLocationListener listener) {
        Assert.isNotNull((Object)listener);
        this.fWorkLocationListeners.remove((Object)listener);
    }

    @Override
    public synchronized boolean save(IProgressMonitor monitor) {
        block6: {
            FormEditor editor;
            AbstractContributorResourceInput input = this.getInput();
            if (input != null && (editor = this.getFormPage().getEditor()) instanceof ContributorEditor) {
                ContributorEditor extended = (ContributorEditor)editor;
                Combo control = this.fTimeZoneCombo;
                Display display = control.getDisplay();
                try {
                    WorkLocationDefinition workingCopy = (WorkLocationDefinition)input.getWorkLocationWorkingCopy(monitor);
                    if (this.fCurrentLocale != null) {
                        String language = this.fCurrentLocale.getLanguage();
                        workingCopy.setLanguage("".equals(language) ? null : language);
                        String country = this.fCurrentLocale.getCountry();
                        workingCopy.setCountry("".equals(country) ? null : country);
                        String variant = this.fCurrentLocale.getVariant();
                        workingCopy.setVariant("".equals(variant) ? null : variant);
                    }
                    if (this.fCurrentTimeZone != null) {
                        workingCopy.setTimeZone(this.fCurrentTimeZone.getID());
                        workingCopy.setZoneOffset(this.fCurrentTimeZone.getOffset(0L));
                    }
                    OperationStatus<IContributorResourceDetails> status = input.saveContributorDetails(monitor);
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable((Control)control, status, extended){
                            private final /* synthetic */ Control val$control;
                            private final /* synthetic */ OperationStatus val$status;
                            private final /* synthetic */ ContributorEditor val$extended;
                            {
                                this.val$control = control;
                                this.val$status = operationStatus;
                                this.val$extended = contributorEditor;
                            }

                            @Override
                            public void run() {
                                if (!this.val$control.isDisposed()) {
                                    if (this.val$status != null && !this.val$status.isOK()) {
                                        this.val$extended.setStatus(Messages.WorkLocationDefinitionPart_SAVE_PROBLEM, (IStatus)this.val$status);
                                    } else {
                                        this.val$extended.setStatus(null, null);
                                    }
                                }
                            }
                        });
                    }
                    return status == null || !status.matches(4);
                }
                catch (TeamRepositoryException exception) {
                    if (display.isDisposed()) break block6;
                    display.asyncExec(new Runnable((Control)control, extended, exception){
                        private final /* synthetic */ Control val$control;
                        private final /* synthetic */ ContributorEditor val$extended;
                        private final /* synthetic */ TeamRepositoryException val$exception;
                        {
                            this.val$control = control;
                            this.val$extended = contributorEditor;
                            this.val$exception = teamRepositoryException;
                        }

                        @Override
                        public void run() {
                            if (!this.val$control.isDisposed()) {
                                this.val$extended.setStatus(Messages.WorkLocationDefinitionPart_SAVE_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), Messages.WorkLocationDefinitionPart_EXCEPTION_SAVING_WORK_LOCATION, (Throwable)this.val$exception));
                            }
                        }
                    });
                }
            }
        }
        return false;
    }

    @Override
    public synchronized void setInput(Object object) {
        AbstractContributorResourceInput predecessor = this.getInput();
        if (predecessor == object) {
            return;
        }
        super.setInput(object);
        final AbstractContributorResourceInput input = this.getInput();
        Combo control = this.fTimeZoneCombo;
        final Display display = control.getDisplay();
        FoundationJob job = new FoundationJob(Messages.WorkLocationDefinitionPart_FETCHING_WORK_JOB_NAME, (Control)control){
            private final /* synthetic */ Control val$control;
            {
                this.val$control = control;
                super($anonymous0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(IProgressMonitor monitor) {
                block14: {
                    Assert.isNotNull((Object)monitor);
                    8 var2_2 = this;
                    synchronized (var2_2) {
                        WorkLocationDefinitionPart.this.fMonitor = monitor;
                    }
                    try {
                        boolean permissions;
                        IWorkLocationDefinition workingCopy;
                        OperationStatus<IWorkLocationDefinition> status;
                        monitor.beginTask(Messages.WorkLocationDefinitionPart_FETCHING_WORK_TASK_NAME, 300);
                        8 var5_6 = this;
                        synchronized (var5_6) {
                            if (input != null) {
                                status = input.getWorkLocation((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                workingCopy = input.getWorkLocationWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                permissions = input.checkWritePermissions((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            } else {
                                status = null;
                                workingCopy = null;
                                permissions = true;
                            }
                        }
                        final String[] localeNames = WorkLocationDefinitionPart.this.createLocalNames();
                        final String[] timeZoneNames = WorkLocationDefinitionPart.this.createTimeZoneNames();
                        if (!display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!val$control.isDisposed()) {
                                        WorkLocationDefinitionPart.this.fTimeZoneCombo.setEnabled(false);
                                        WorkLocationDefinitionPart.this.fLocaleCombo.setEnabled(false);
                                        WorkLocationDefinitionPart.this.fCurrentTimeZone = null;
                                        WorkLocationDefinitionPart.this.fCurrentLocale = null;
                                        AbstractContributorResourceFormPage page = WorkLocationDefinitionPart.this.getFormPage();
                                        if (status != null) {
                                            if (!permissions) {
                                                page.setPermanentMessage(Messages.WorkLocationDefinitionPart_NO_PERMISSIONS_HINT, 1);
                                            }
                                            Locale locale = ResourcePlanningUtils.getLocale((IWorkLocationDefinition)workingCopy);
                                            String display = locale.getDisplayName(USER_INTERFACE_LOCALE);
                                            WorkLocationDefinitionPart.this.fLocaleCombo.setItems(localeNames);
                                            int index = 0;
                                            while (index < localeNames.length) {
                                                if (localeNames[index].equals(display)) {
                                                    WorkLocationDefinitionPart.this.fCurrentLocale = locale;
                                                    WorkLocationDefinitionPart.this.fLocaleCombo.select(index);
                                                    break;
                                                }
                                                ++index;
                                            }
                                            WorkLocationDefinitionPart.this.fLocaleCombo.setEnabled(true);
                                            display = WorkLocationDefinitionPart.this.getTimeZoneName(workingCopy.getTimeZone());
                                            if (display == null) {
                                                String[] ids;
                                                String[] stringArray = ids = TimeZone.getAvailableIDs((String)workingCopy.getCountry());
                                                int n = ids.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    String id = stringArray[n2];
                                                    display = WorkLocationDefinitionPart.this.getTimeZoneName(id);
                                                    if (display != null) break;
                                                    ++n2;
                                                }
                                            }
                                            WorkLocationDefinitionPart.this.fTimeZoneCombo.setItems(timeZoneNames);
                                            index = 0;
                                            while (index < timeZoneNames.length) {
                                                if (timeZoneNames[index].equals(display)) {
                                                    WorkLocationDefinitionPart.this.fCurrentTimeZone = (TimeZone)WorkLocationDefinitionPart.this.fTimeZoneMap.get(display);
                                                    WorkLocationDefinitionPart.this.fTimeZoneCombo.select(index);
                                                    break;
                                                }
                                                ++index;
                                            }
                                            WorkLocationDefinitionPart.this.fTimeZoneCombo.setEnabled(true);
                                        }
                                        page.getManagedForm().getForm().layout(true, true);
                                    }
                                }
                            });
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        if (display.isDisposed()) break block14;
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FormEditor editor;
                                AbstractContributorResourceFormPage page;
                                if (!val$control.isDisposed() && (page = WorkLocationDefinitionPart.this.getFormPage()) != null && (editor = page.getEditor()) instanceof ContributorEditor) {
                                    ContributorEditor extended = (ContributorEditor)editor;
                                    extended.setStatus(Messages.WorkLocationDefinitionPart_LOAD_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                                }
                            }
                        });
                    }
                }
                8 var2_5 = this;
                synchronized (var2_5) {
                    WorkLocationDefinitionPart.this.fMonitor = null;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(EXCLUSIVE_SCHEDULING_RULE);
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    private String[] createLocalNames() {
        Locale[] locales = Locale.getAvailableLocales();
        ArrayList<String> names = new ArrayList<String>(locales.length);
        Locale[] localeArray = locales;
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            if (Locale.ENGLISH.equals(locale) || !"".equals(locale.getCountry()) && "".equals(locale.getVariant())) {
                String name = locale.getDisplayName(USER_INTERFACE_LOCALE);
                names.add(name);
                this.fLocaleMap.put(name, locale);
            }
            ++n2;
        }
        final Collator collator = CollatorCache.getInstance();
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return collator.compare(o1, o2);
            }
        });
        String[] items = names.toArray(new String[names.size()]);
        return items;
    }

    private String[] createTimeZoneNames() {
        String[] ids = TimeZone.getAvailableIDs();
        ArrayList<String> names = new ArrayList<String>(ids.length);
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            TimeZone zone;
            String id = stringArray[n2];
            String display = this.getTimeZoneName(id);
            if (display != null && (zone = TimeZone.getTimeZone((String)id)) != null) {
                names.add(display);
                this.fTimeZoneMap.put(display, zone);
                this.fZoneOffsetMap.put(display, zone.getOffset(0L));
            }
            ++n2;
        }
        final Collator collator = CollatorCache.getInstance();
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return collator.compare(o1, o2);
            }
        });
        String[] items = names.toArray(new String[names.size()]);
        return items;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return false;
    }

    private String getTimeZoneName(String id) {
        String messageKey = TimeZoneInfo.getMessageKey((String)id);
        if (messageKey == null) {
            return null;
        }
        return Messages.getString(messageKey);
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private ExclusiveSchedulingRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ExclusiveSchedulingRule;
        }
    }
}

