/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.WikiClient;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.PreviewWikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.RichWikiDocument;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiActionGroup;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiDropAdapter;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.tooltip.BrowserTooltipSupport;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.wiki.transformer.Transformer;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.IProjectAreaContextProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class WorkItemWikiPart
extends AttributePart {
    private final IPresentationUpdater fPresentationUpdater = new PresentationUpdater();
    private PreviewWikiViewer fViewer;
    private RequiredPropertyLabel fAttributeName;
    private final Transformer fTransformer = new Transformer();
    private final List<IHandlerActivation> fActivations = new ArrayList<IHandlerActivation>();
    private WikiActionGroup fActions;
    private Composite fContent;
    private ToolBarManager fToolbarManager;

    public void createContent(ITeamFormLayout formLayout) {
        Composite parent = formLayout.getContainer();
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
            ToolBar toolBar = new ToolBar(parent, 0x4800000);
            formLayout.add((Control)toolBar, "button", ITeamFormData.BUTTON);
            toolkit.adapt((Composite)toolBar, this.getBackgroundStyle());
            this.fToolbarManager = new ToolBarManager(toolBar);
            this.fToolbarManager.add((IAction)new ToggleModeAction());
            this.fToolbarManager.getControl().setBackground(null);
            this.fToolbarManager.update(true);
        } else {
            Util.addToolbarAction((Composite)parent, (FormToolkit)toolkit, (IAction)new ToggleModeAction());
        }
        this.fContent = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        TeamFormLayouts.setLayoutData((Control)this.fContent, (ITeamFormData)ITeamFormData.MULTI_LINE_GROW);
        this.fContent.setLayout((Layout)new GridLayout());
        formLayout.add((Control)this.fContent, "wideContent");
        this.fViewer = new PreviewWikiViewer(this.fContent, null, 2880, (ContentAssistContextProvider)new ContextProvider());
        GridDataFactory.fillDefaults().grab(true, true).hint(240, this.fViewer.getTextWidget().getLineHeight() * 3).applyTo(this.fViewer.getControl());
        try {
            this.fViewer.getTextEditor().init(this.getSite().getWorkbenchPage().getActiveEditor().getEditorSite(), null);
        }
        catch (PartInitException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkItemWikiPart.this.fActions.updateActions();
            }
        });
        this.fViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    ((WorkItemWorkingCopyImpl)WorkItemWikiPart.this.fWorkingCopy).setDirty(true);
                }
                WorkItemWikiPart.this.fActions.updateActions();
            }
        });
        this.fViewer.getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                IDocument document = WorkItemWikiPart.this.fViewer.getDocument();
                if (document == null) {
                    return;
                }
                String value = document.get();
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)WorkItemWikiPart.this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                Object currentValue = workItem.getValue(WorkItemWikiPart.this.getAttribute());
                if (value == null && currentValue != null || value != null && !value.equals(currentValue)) {
                    WorkItemWikiPart.this.fWorkingCopy.getWorkItem().setValue(WorkItemWikiPart.this.getAttribute(), (Object)value);
                }
            }
        });
        new BrowserTooltipSupport(this.fViewer.getBrowserWidget(), true, false);
        DropTarget target = new DropTarget((Control)this.fViewer.getTextWidget(), 21);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new WikiDropAdapter(this.fViewer));
        this.fViewer.getBrowserWidget().addLocationListener((LocationListener)new LocationAdapter(){
            private static final String ABOUT_BLANK = "about:blank";

            public void changing(LocationEvent event) {
                if (ABOUT_BLANK.equals(event.location)) {
                    return;
                }
                try {
                    URI uri = new URI(event.location);
                    event.doit = false;
                    Hyperlinks.open((URI)uri, null);
                }
                catch (URISyntaxException e) {
                    return;
                }
            }
        });
        this.fActions = new WikiActionGroup(this.fViewer);
        this.fActions.setContext(WikiActionGroup.EDIT);
        this.fActions.initActions();
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkItemWikiPart.this.fActions.updateActions();
                WorkItemWikiPart.this.fActions.fillContextMenu(manager);
            }
        });
        StyledText text = this.fViewer.getTextWidget();
        Menu menu = mgr.createContextMenu((Control)text);
        text.setMenu(menu);
        this.fViewer.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                WorkItemWikiPart.this.activateActions();
            }

            public void focusLost(FocusEvent e) {
                WorkItemWikiPart.this.deactivateActions();
            }
        });
        this.doUpdateReadOnly(this.isReadOnly());
    }

    protected void doUpdateReadOnly(boolean readOnly) {
        if (this.fToolbarManager != null && !this.fToolbarManager.getControl().isDisposed()) {
            this.fToolbarManager.getControl().setEnabled(!readOnly);
        }
    }

    private void activateActions() {
        this.setGlobalActionHandler(true, ActionFactory.PASTE.getId(), ActionFactory.COPY.getId(), ActionFactory.CUT.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId());
        IHandlerService handlerService = (IHandlerService)this.getSite().getWorkbenchPage().getWorkbenchWindow().getService(IHandlerService.class);
        for (Map.Entry<String, Action> entry : this.fActions.getActions().entrySet()) {
            IHandlerActivation activation = handlerService.activateHandler(entry.getKey(), (IHandler)new ActionHandler((IAction)entry.getValue()));
            this.fActivations.add(activation);
        }
    }

    private void deactivateActions() {
        this.setGlobalActionHandler(false, ActionFactory.PASTE.getId(), ActionFactory.COPY.getId(), ActionFactory.CUT.getId(), ActionFactory.UNDO.getId(), ActionFactory.REDO.getId());
        IHandlerService handlerService = (IHandlerService)this.getSite().getWorkbenchPage().getWorkbenchWindow().getService(IHandlerService.class);
        handlerService.deactivateHandlers(this.fActivations);
    }

    private void setGlobalActionHandler(boolean active, String ... identifiers) {
        IEditorPart editor = this.getSite().getWorkbenchPage().getActiveEditor();
        if (editor == null) {
            return;
        }
        IActionBars actionBars = editor.getEditorSite().getActionBars();
        if (actionBars == null) {
            return;
        }
        String[] stringArray = identifiers;
        int n = identifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            actionBars.setGlobalActionHandler(identifier, active ? this.fActions.getAction(identifier) : null);
            ++n2;
        }
    }

    public void dispose() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
        if (this.fToolbarManager != null) {
            this.fToolbarManager.removeAll();
            this.fToolbarManager.dispose();
        }
        this.deactivateActions();
        super.dispose();
    }

    public void setInput(final Object input) {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getPresentation());
        }
        if (input instanceof WorkItemEditorInput) {
            new FoundationJob(""){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    WorkItemWikiPart.this.fWorkingCopy = ((WorkItemEditorInput)input).getWorkingCopy();
                    IWorkItem workItem = WorkItemWikiPart.this.fWorkingCopy.getWorkItem();
                    WorkItemWikiPart.this.setInput(WorkItemWikiPart.this.getRichWikiDocument(workItem, monitor));
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else if (input instanceof IWorkItem) {
            new FoundationJob(""){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    WorkItemWikiPart.this.setInput(WorkItemWikiPart.this.getRichWikiDocument((IWorkItem)input, monitor));
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private RichWikiDocument getRichWikiDocument(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        EnumSet options = WikiClient.getWikiManager((IItem)workItem).allowsEmbeddedXhtml(monitor) ? Transformer.ALL_OPTIONS : Transformer.SAFE_OPTIONS;
        Object value = workItem.getValue(this.getAttribute());
        return new RichWikiDocument(value == null ? "" : String.valueOf(value), this.fTransformer, options);
    }

    protected void setInput(final RichWikiDocument document) {
        UI.syncExec(this.fViewer.getControl(), new Runnable(){

            @Override
            public void run() {
                document.setScript(RichWikiDocument.defaultScripts());
                document.setStyle(RichWikiDocument.defaultStyles(WorkItemWikiPart.this.fViewer.getControl()));
                document.setWorkItem(WorkItemWikiPart.this.fWorkingCopy);
                WorkItemWikiPart.this.fViewer.setDocument((IDocument)document);
                WorkItemWikiPart.this.fViewer.setEditable(WorkItemWikiPart.this.isReadOnly() ? false : WorkItemWikiPart.this.fViewer.getEditable());
                if (WorkItemWikiPart.this.fAttributeName != null && !WorkItemWikiPart.this.fAttributeName.isDisposed()) {
                    WorkItemWikiPart.this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)WorkItemWikiPart.this.getLabel(), (Object[])new Object[0]));
                    WorkItemWikiPart.this.fAttributeName.setTooltip(WorkItemWikiPart.this.getDescription());
                    WorkItemWikiPart.this.fAttributeName.layout();
                }
            }
        });
    }

    private class ContextProvider
    extends TeamContextProvider
    implements IProjectAreaContextProvider {
        private ContextProvider() {
        }

        public ITeamRepository getTeamRepository() {
            IAttribute attribute = WorkItemWikiPart.this.getAttribute();
            if (attribute == null) {
                return null;
            }
            return PlanningClientPlugin.getTeamRepository((IItemHandle)attribute);
        }

        public IProjectAreaHandle getProjectArea() {
            IAttribute attribute = WorkItemWikiPart.this.getAttribute();
            return attribute != null ? attribute.getProjectArea() : null;
        }
    }

    private class PresentationUpdater
    extends AbstractPresentationUpdater {
        private PresentationUpdater() {
        }

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (WorkItemWikiPart.this.fAttributeName != null && !WorkItemWikiPart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible((Control)WorkItemWikiPart.this.fAttributeName.getLayoutControl(), (boolean)visible);
                changedControls.add(WorkItemWikiPart.this.fAttributeName.getLayoutControl());
            }
            if (WorkItemWikiPart.this.fContent != null && !WorkItemWikiPart.this.fContent.isDisposed()) {
                TeamFormUtil.setVisible((Control)WorkItemWikiPart.this.fContent, (boolean)visible);
                changedControls.add(WorkItemWikiPart.this.fContent);
            }
            Util.updateFormLayout((Control[])changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (WorkItemWikiPart.this.fAttributeName != null && !WorkItemWikiPart.this.fAttributeName.isDisposed()) {
                WorkItemWikiPart.this.fAttributeName.setRequired(required);
            }
        }

        public void setReadOnly(boolean readOnly) {
            WorkItemWikiPart.this.updateReadOnly(readOnly);
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            WorkItemWikiPart.this.setInput(event.getWorkItem());
        }
    }

    private class ToggleModeAction
    extends Action {
        public ToggleModeAction() {
            super(Messages.WorkItemWikiPart_ACTION_TOGGLE_EDIT, 2);
            this.setImageDescriptor(ImagePool.EDIT_OVERVIEW_ENABLED);
        }

        public void run() {
            boolean editable = !WorkItemWikiPart.this.fViewer.getEditable();
            WorkItemWikiPart.this.fViewer.setEditable(editable);
            WorkItemWikiPart.this.fActions.setContext(editable ? WikiActionGroup.EDIT : WikiActionGroup.VIEW);
            WorkItemWikiPart.this.fActions.updateActions();
            this.setText(editable ? Messages.WorkItemWikiPart_ACTION_TOGGLE_PREVIEW : Messages.WorkItemWikiPart_ACTION_TOGGLE_EDIT);
        }
    }
}

