/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.AbstractConditionControl;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.IValidator;
import com.ibm.team.workitem.ide.ui.internal.queryeditor.control.TextControl;
import java.text.ParseException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class WorkItemQueryDurationControl
extends AbstractConditionControl {
    private static final Status INFO_STATUS = new Status(1, PlanningUIPlugin.getPluginId(), Messages.WorkItemQueryDurationControl_TIME_DURATION_HINT);
    private DurationFormat fDurationFormat = null;
    private TextControl fDurationTextField;

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fDurationTextField = new TextControl(parent, 0x804 | ("carbon".equals(SWT.getPlatform()) ? 16384 : 131072));
        this.fDurationTextField.useMultiSelection(false);
        this.fDurationTextField.getTextControl().setMessage(INFO_STATUS.getMessage());
        this.fDurationTextField.setValidator(new IValidator(){

            public IStatus validate(Object object) {
                String string = (String)object;
                try {
                    WorkItemQueryDurationControl.this.getDurationFormat().parse(string);
                }
                catch (ParseException exception) {
                    return new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage());
                }
                return Status.OK_STATUS;
            }
        }, TextControl.Options.VERIFY_WARN);
        this.fDurationTextField.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkItemQueryDurationControl.this.handleSelectionChanged(event.getSelection());
            }
        });
    }

    protected void inputChanged(Object input) {
    }

    public void setFocus() {
        this.fDurationTextField.setFocus();
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection structured;
        if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).getFirstElement() instanceof Number) {
            Number number = (Number)structured.getFirstElement();
            this.setDuration(new Duration(number.longValue()));
        }
    }

    private void setDuration(Duration duration) {
        Assert.isNotNull((Object)duration);
        this.fDurationTextField.setSelection((ISelection)new StructuredSelection((Object)this.getDurationFormat().format(duration)));
    }

    private void handleSelectionChanged(ISelection selection) {
        if (!selection.isEmpty()) {
            try {
                Duration duration = this.getDuration(selection);
                if (duration != null) {
                    this.notifySelectionChanged((ISelection)new StructuredSelection((Object)duration.longValue()));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return;
        }
        this.notifySelectionChanged(selection);
    }

    private Duration getDuration(ISelection sel) throws ParseException {
        IStructuredSelection selection = (IStructuredSelection)sel;
        String element = (String)selection.getFirstElement();
        if (element != null) {
            return this.getDurationFormat().parse(element);
        }
        return null;
    }

    private synchronized DurationFormat getDurationFormat() {
        if (this.fDurationFormat == null) {
            this.fDurationFormat = new DurationFormat(0);
        }
        return this.fDurationFormat;
    }
}

