/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.progress.ProgressScriptEnvironment;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.ide.ui.preview.ProgressInformationDomainAdapter;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressBarDrawingStrategy;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.ScriptUtilities;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class WorkItemProgressPresentationPart
extends PresentationPart {
    private final WorkItemWorkingCopyListener fListener = new WorkItemWorkingCopyListener();
    private WorkItemWorkingCopy fWorkingCopy;
    private IProgressLabelProvider fLabelProvider;
    private IProgressInformation fProgressInformation;
    private Label fLabel;
    private Composite fComposite;
    private Label fLblProgress;
    private Label fLblQuality;
    private Canvas fCvsProgress;
    private ProgressBarDrawingStrategy fDrawingStrategy;
    private final IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (WorkItemProgressPresentationPart.this.fLabel != null && !WorkItemProgressPresentationPart.this.fLabel.isDisposed()) {
                TeamFormUtil.setVisible((Control)WorkItemProgressPresentationPart.this.fLabel, (boolean)visible);
                changedControls.add(WorkItemProgressPresentationPart.this.fLabel);
            }
            if (WorkItemProgressPresentationPart.this.fComposite != null && !WorkItemProgressPresentationPart.this.fComposite.isDisposed()) {
                TeamFormUtil.setVisible((Control)WorkItemProgressPresentationPart.this.fComposite, (boolean)visible);
                changedControls.add(WorkItemProgressPresentationPart.this.fComposite);
            }
            Util.updateFormLayout((Control[])changedControls.toArray(new Control[changedControls.size()]));
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            ReferencesChangeDetails details = (ReferencesChangeDetails)event.getAttributeChangeDetails("references", ReferencesChangeDetails.class);
            if (details != null) {
                boolean refresh = false;
                HashSet references = new HashSet(16);
                references.addAll(details.getAdded());
                references.addAll(details.getRemoved());
                for (IReference reference : references) {
                    IEndPointDescriptor descriptor = WorkItemLinkTypes.getEndPointDescriptor((IReference)reference);
                    if (!WorkItemEndPoints.PARENT_WORK_ITEM.equals(descriptor) && !WorkItemEndPoints.CHILD_WORK_ITEMS.equals(descriptor)) continue;
                    refresh = true;
                    break;
                }
                if (refresh) {
                    WorkItemProgressPresentationPart.this.refreshProgress();
                }
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        Assert.isNotNull((Object)formLayout);
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            String label = this.getLabel();
            label = label == null ? Messages.WorkItemProgressPresentationPart_DISPLAY_NAME : NLS.bind((String)ATTRNAME_COLON, (Object)label, (Object[])new Object[0]);
            this.fLabel = toolkit.createLabel(parent, label, 0, this.getBackgroundStyle());
            this.fLabel.setToolTipText(this.getDescription());
            formLayout.add((Control)this.fLabel, "label");
        }
        this.fComposite = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        TeamFormLayouts.setLayoutData((Control)this.fComposite, (ITeamFormData)ITeamFormData.SINGLE_LINE_FIXED.addOffset(4, 0));
        formLayout.add((Control)this.fComposite, "content");
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(this.fComposite);
        this.fLabelProvider = (IProgressLabelProvider)ScriptUtilities.newInstance((IScriptEnvironment)ProgressScriptEnvironment.createScriptEnvironment(), IProgressLabelProvider.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressLabelProvider2", (Object[])new Object[0]);
        this.fCvsProgress = new Canvas(this.fComposite, 262144);
        toolkit.adapt((Composite)this.fCvsProgress);
        BarResources resources = new BarResources((Control)this.fCvsProgress);
        this.fDrawingStrategy = new ProgressBarDrawingStrategy(resources);
        this.fDrawingStrategy.setLabelProvider(this.fLabelProvider);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).hint(-1, this.fDrawingStrategy.computeMinimalHeight()).applyTo((Control)this.fCvsProgress);
        new DoubleBufferPainter(this.fCvsProgress){

            public void doPaint(PaintEvent event) {
                WorkItemProgressPresentationPart.this.fDrawingStrategy.paint(event.gc, WorkItemProgressPresentationPart.this.fCvsProgress.getClientArea());
            }
        };
        this.fLblProgress = toolkit.createLabel(this.fComposite, this.fLabelProvider.getProgressText(null));
        this.fLblProgress.setFont(resources.getMessageFont());
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fLblProgress);
        this.fLblQuality = toolkit.createLabel(this.fComposite, this.fLabelProvider.getQualityText(null));
        this.fLblQuality.setFont(resources.getMessageFont());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.fLblQuality);
        new ProgressTooltipSupport((Control)this.fCvsProgress, true, false);
        new ProgressTooltipSupport((Control)this.fLblProgress, true, false);
        new ProgressTooltipSupport((Control)this.fLblQuality, true, false);
    }

    protected void doUpdateReadOnly(boolean readOnly) {
    }

    protected boolean isDirty() {
        return false;
    }

    private void refreshProgress() {
        final IWorkItem workItem = this.fWorkingCopy.getWorkItem();
        new FoundationJob(Messages.WorkItemProgressPresentationPart_JOB_COMPUTE_PROGRESS){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                if (workItem.isNewItem()) {
                    WorkItemProgressPresentationPart.this.fProgressInformation = (IProgressInformation)ScriptUtilities.newInstance((IScriptEnvironment)ProgressScriptEnvironment.createScriptEnvironment(), IProgressInformation.class, (String)"com.ibm.team.apt.shared.client.internal.progress.ProgressInformation", (Object[])new Object[]{true, null});
                } else {
                    IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)workItem);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    WorkItemProgressPresentationPart.this.fProgressInformation = client.fetchWorkItemProgress((IWorkItemHandle)workItem, (IProgressMonitor)progress.newChild(1));
                    IComplexityAttribute complexityAttribute = client.findComplexityAttribute((IProcessAreaHandle)workItem.getProjectArea(), (IProgressMonitor)progress.newChild(1));
                    WorkItemProgressPresentationPart.this.fLabelProvider = ProgressIDE.newLabelProvider(ProgressScriptEnvironment.createScriptEnvironment(), complexityAttribute);
                    WorkItemProgressPresentationPart.this.fDrawingStrategy.setLabelProvider(WorkItemProgressPresentationPart.this.fLabelProvider);
                }
                UI.syncExec((Control)WorkItemProgressPresentationPart.this.fComposite, new Runnable(){

                    @Override
                    public void run() {
                        WorkItemProgressPresentationPart.this.update();
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected void update() {
        if (this.fCvsProgress == null | this.fLblProgress == null || this.fLblQuality == null) {
            return;
        }
        if (this.fCvsProgress.isDisposed() | this.fLblProgress.isDisposed() || this.fLblQuality.isDisposed()) {
            return;
        }
        this.fDrawingStrategy.setInput(this.fProgressInformation);
        this.fCvsProgress.redraw();
        this.fCvsProgress.update();
        this.fLblProgress.setText(this.fLabelProvider.getProgressText(this.fProgressInformation));
        this.fLblQuality.setText(this.fLabelProvider.getQualityText(this.fProgressInformation));
        Util.updateFormLayout((Control[])new Control[]{this.fCvsProgress, this.fLblProgress, this.fLblQuality});
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void addListeners() {
        if (this.fWorkingCopy != null) {
            IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.fWorkingCopy.getTeamRepository());
            IWorkItemWorkingCopyManager manager = client.getWorkItemWorkingCopyManager();
            manager.addWorkingCopyListener((IWorkingCopyListener)this.fListener);
            PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
            if (mgr != null) {
                PresentationDescriptor desc = Util.cloneDescriptor((PresentationDescriptor)this.getPresentation());
                desc.setAttributeId(WorkItemAttributes.getPropertyIdentifier((String)"references"));
                mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
            }
        }
    }

    private void removeListeners() {
        if (this.fWorkingCopy != null) {
            IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((ITeamRepository)this.fWorkingCopy.getTeamRepository());
            IWorkItemWorkingCopyManager manager = client.getWorkItemWorkingCopyManager();
            manager.removeWorkingCopyListener((IWorkingCopyListener)this.fListener);
            PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
            if (mgr != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.addListeners();
            this.refreshProgress();
        } else {
            this.fWorkingCopy = null;
        }
        this.update();
    }

    private class ProgressTooltipSupport
    extends TooltipSupport {
        public ProgressTooltipSupport(Control control, boolean isFocusable, boolean isOpenable) {
            super(control, isFocusable, isOpenable);
        }

        public Object getElement(Control control, int x, int y) {
            return WorkItemProgressPresentationPart.this.fProgressInformation;
        }

        protected String getMarkupInBackground(IDomainAdapter adapter, Object element, IDomainAdapter.Info info, IProgressMonitor monitor) {
            ProgressInformationDomainAdapter progressAdapter = (ProgressInformationDomainAdapter)adapter;
            IProgressInformation progressInformation = (IProgressInformation)element;
            HashMap<String, String> definitions = new HashMap<String, String>();
            definitions.put("meta charset", "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n");
            StringBuffer body = new StringBuffer();
            progressAdapter.generateContentWithLabelProvider(definitions, body, progressInformation, WorkItemProgressPresentationPart.this.fLabelProvider);
            StringBuffer html = new StringBuffer();
            html.append("<html><head>\n");
            HTMLGenerator.getHeadDefinitions((StringBuffer)html, definitions);
            html.append("\n</head><body>\n");
            html.append(body);
            html.append("\n</body></html>\n");
            return html.toString();
        }
    }

    private final class WorkItemWorkingCopyListener
    implements IWorkingCopyListener {
        private WorkItemWorkingCopyListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            Assert.isNotNull((Object)event);
            if (WorkItemProgressPresentationPart.this.fWorkingCopy != null && event.getSource().equals(WorkItemProgressPresentationPart.this.fWorkingCopy) && WorkItemProgressPresentationPart.this.fComposite != null && !WorkItemProgressPresentationPart.this.fComposite.isDisposed() && "reverted".equals(event.getType())) {
                WorkItemProgressPresentationPart.this.refreshProgress();
            }
        }
    }
}

