/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.rest.snapshot.dto.WorkItemScheduleDTO;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WorkItemPlannedTimePresentationPart
extends PresentationPart {
    private static final String NONE = Messages.WorkItemPlannedTimePresentationPart_NONE;
    private IWorkItem fWorkItem;
    private Label fStartDateLabel;
    private Label fEndDateLabel;
    private Text fStartDateContent;
    private Text fEndDateContent;
    private Composite fContainer;
    private WorkItemScheduleDTO fWorkItemMember;
    private DateFormat fDateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)3);

    public void createContent(ITeamFormLayout formLayout) {
        this.createStartDateContent(formLayout);
        this.createEndDateContent(formLayout);
    }

    protected void doUpdateReadOnly(boolean readOnly) {
    }

    protected boolean isDirty() {
        return false;
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            WorkItemWorkingCopy workingCopy = extended.getWorkingCopy();
            this.fWorkItem = workingCopy.getWorkItem();
            new FoundationJob(Messages.WorkItemPlannedTimePresentationPart_COMPUTING_PLANNED_TIME_JOB_NAME){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)WorkItemPlannedTimePresentationPart.this.fWorkItem);
                    WorkItemPlannedTimePresentationPart.this.fWorkItemMember = client.fetchWorkItemScheduleFromSnapshotType(WorkItemPlannedTimePresentationPart.this.fWorkItem, "com.ibm.team.apt.plansnapshot.planned", monitor);
                    UI.syncExec((Control)WorkItemPlannedTimePresentationPart.this.fContainer, new Runnable(){

                        @Override
                        public void run() {
                            WorkItemPlannedTimePresentationPart.this.updateContent(WorkItemPlannedTimePresentationPart.this.fStartDateContent, DateTypes.START_DATE);
                        }
                    });
                    UI.syncExec((Control)WorkItemPlannedTimePresentationPart.this.fContainer, new Runnable(){

                        @Override
                        public void run() {
                            WorkItemPlannedTimePresentationPart.this.updateContent(WorkItemPlannedTimePresentationPart.this.fEndDateContent, DateTypes.END_DATE);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void createStartDateContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        if (this.isLabelVisible()) {
            String text = Messages.WorkItemPlannedTimePresentationPart_START_DATE_DISPLAY_NAME;
            this.fStartDateLabel = this.createLabel(formLayout, text, toolkit);
        }
        this.createComposite(formLayout, toolkit);
        this.fStartDateContent = this.createContent(toolkit, this.fStartDateLabel);
    }

    private void createEndDateContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        if (this.isLabelVisible()) {
            String text = Messages.WorkItemPlannedTimePresentationPart_END_DATE_DISPLAY_NAME;
            this.fEndDateLabel = this.createLabel(formLayout, text, toolkit);
        }
        this.createComposite(formLayout, toolkit);
        this.fEndDateContent = this.createContent(toolkit, this.fEndDateLabel);
    }

    private void createComposite(ITeamFormLayout formLayout, WorkItemEditorToolkit toolkit) {
        Composite parent = formLayout.getContainer();
        this.fContainer = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        TeamFormLayouts.setLayoutData((Control)this.fContainer, (ITeamFormData)SINGLE_LINE_GROW_READONLY_TEXT);
        Util.addWidthHint((Control)this.fContainer);
        formLayout.add((Control)this.fContainer, "content");
        this.fContainer.setLayout((Layout)new GridLayout(2, false));
        ((GridLayout)this.fContainer.getLayout()).marginWidth = 0;
        ((GridLayout)this.fContainer.getLayout()).marginHeight = 0;
    }

    private Label createLabel(ITeamFormLayout formLayout, String text, WorkItemEditorToolkit toolkit) {
        Composite parent = formLayout.getContainer();
        Label label = toolkit.createLabel(parent, text, 0, this.getBackgroundStyle());
        formLayout.add((Control)label, "label");
        return label;
    }

    private Text createContent(WorkItemEditorToolkit toolkit, Label dateLabel) {
        Composite composite = toolkit.createComposite(this.fContainer, 0, this.getBackgroundStyle());
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Text content = toolkit.createReadOnlyText(composite, "", 0, this.getBackgroundStyle());
        this.initAccessible((Control)content);
        GridData data = new GridData(4, 4, true, false, 4, 1);
        content.setLayoutData((Object)data);
        return content;
    }

    private String getStartDateString(WorkItemScheduleDTO workItemMember) {
        Timestamp startDateTime;
        String dateString = NONE;
        if (workItemMember != null && (startDateTime = workItemMember.getScheduledStart()) != null) {
            Date startDate = new Date(startDateTime.getTime());
            dateString = this.getFormattedDateString(startDate);
        }
        return dateString;
    }

    private String getEndDateString(WorkItemScheduleDTO workItemMember) {
        Timestamp endDateTime;
        String dateString = NONE;
        if (workItemMember != null && (endDateTime = workItemMember.getScheduledEnd()) != null) {
            Date endDate = new Date(endDateTime.getTime());
            dateString = this.getFormattedDateString(endDate);
        }
        return dateString;
    }

    private void updateContent(Text content, DateTypes dateType) {
        String dateString = NONE;
        String message = Messages.WorkItemPlannedTimePresentationPart_NO_PLANNED_SNAPSHOTS;
        if (this.fWorkItem != null && this.fWorkItem.getTarget() == null) {
            message = Messages.WorkItemPlannedTimePresentationPart_WORKITEM_IN_SNAPSHOT_UNASSIGNED;
        } else {
            switch (dateType) {
                case START_DATE: {
                    dateString = this.getStartDateString(this.fWorkItemMember);
                    break;
                }
                case END_DATE: {
                    dateString = this.getEndDateString(this.fWorkItemMember);
                }
            }
            if (this.fWorkItemMember != null) {
                String snapshotName = this.fWorkItemMember.getSnapshotName();
                String planName = this.fWorkItemMember.getPlanName();
                message = this.fWorkItemMember.isFoundInMultiple() ? NLS.bind((String)Messages.WorkItemPlannedTimePresentationPart_WORKITEM_IN_MULTIPLE_SNAPSHOTS, (Object)snapshotName, (Object[])new Object[]{planName}) : NLS.bind((String)Messages.WorkItemPlannedTimePresentationPart_PLANNED_DATES_FROM_SNAPSHOT, (Object)snapshotName, (Object[])new Object[]{planName});
            }
        }
        if (!content.getText().equals(dateString)) {
            content.setText(dateString);
            content.setToolTipText(message);
        }
    }

    protected String getFormattedDateString(Date date) {
        if (date == null) {
            return NONE;
        }
        return this.fDateTimeFormat.format(date);
    }

    private static enum DateTypes {
        START_DATE("Start Date"),
        END_DATE("End Date");

        private final String fKey;

        private DateTypes(String key) {
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }
    }
}

