/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.client.DurationSupport;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IProcessAreaInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.client.util.WorkItems;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public final class WorkItemEstimateAttributePart
extends AttributePart {
    private static final Status INFO_STATUS = new Status(1, PlanningUIPlugin.getPluginId(), Messages.WorkItemEstimateAttributePart_ESTIMATE_HINT);
    private static final Status ERROR_STATUS = new Status(4, PlanningUIPlugin.getPluginId(), Messages.WorkItemEstimateAttributePart_INCOMPATIBLE_ATTRIBUTE_ID);
    private IAttribute fAttribute = null;
    private Label fCorrectionLabel;
    private ISchedulingRule fCorrectionRule;
    private DecoratedText fCorrectionTextField;
    private DurationSupport fDurationSupport;
    private volatile DurationFormat fDurationFormat = null;
    private RequiredPropertyLabel fEstimateLabel;
    private ISchedulingRule fEstimateRule;
    private DecoratedText fEstimateTextField;
    private final Object fFormatLock = new Object();
    private IPresentationUpdater fEstimateUpdater = new AbstractPresentationUpdater(){

        public void setRequired(boolean required) {
            if (WorkItemEstimateAttributePart.this.fEstimateLabel != null && !WorkItemEstimateAttributePart.this.fEstimateLabel.isDisposed()) {
                WorkItemEstimateAttributePart.this.fEstimateLabel.setRequired(required);
            }
        }

        public void setReadOnly(boolean readOnly) {
            WorkItemEstimateAttributePart.this.updateReadOnly(readOnly);
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            WorkItemEstimateAttributePart.this.updateEstimateField();
        }

        public void setStatus(IStatus status) {
            WorkItemEstimateAttributePart.this.fEstimateTextField.setStatus(status);
        }
    };
    private IPresentationUpdater fCorrectionUpdater = new AbstractPresentationUpdater(){

        public void attributeChanged(WorkItemChangeEvent event) {
            WorkItemEstimateAttributePart.this.updateCorrectionField();
        }

        public void setStatus(IStatus status) {
            WorkItemEstimateAttributePart.this.fCorrectionTextField.setStatus(status);
        }

        public void setReadOnly(boolean readOnly) {
            Control control;
            if (!WorkItemEstimateAttributePart.this.isReadOnly() && WorkItemEstimateAttributePart.this.fCorrectionTextField != null && !(control = WorkItemEstimateAttributePart.this.fCorrectionTextField.getLayoutControl()).isDisposed()) {
                control.setEnabled(!readOnly);
            }
        }
    };
    private final AtomicInteger fUpdateToken = new AtomicInteger(0);

    private static final Duration getDuration(ResolvedWorkItem item, IAttribute attribute) {
        Long number = (Long)item.getValue(attribute);
        if (number != null) {
            return new Duration(number.longValue());
        }
        return Duration.UNSPECIFIED;
    }

    boolean isBuiltInEstimationAttribute() {
        IAttribute estimateAttribute = this.getEstimateAttribute();
        String id = estimateAttribute.getIdentifier();
        return IWorkItem.DURATION_PROPERTY.equals(id);
    }

    private IStatus getIdleStatus(DecoratedText field) {
        if (this.isBuiltInEstimationAttribute()) {
            Text text = field.getText();
            if (text.isFocusControl() && text.isEnabled()) {
                return INFO_STATUS;
            }
            return Status.OK_STATUS;
        }
        field.getText().setEnabled(false);
        return ERROR_STATUS;
    }

    private static long getWorkYearMillis(DurationFormat format) {
        return format.getMillisPerDay() * (long)format.getDaysPerWeek() * 52L;
    }

    private static Duration parseDuration(String text, String name, DurationFormat format) throws ParseException {
        if (text == null || text.length() == 0) {
            return Duration.UNSPECIFIED;
        }
        Duration duration = format.parse(text);
        if (duration.longValue() > WorkItemEstimateAttributePart.getWorkYearMillis(format)) {
            throw new ParseException(MessageFormat.format(Messages.WorkItemEstimateAttributePart_ONE_WORK_YEAR_HINT, name), 0);
        }
        return duration;
    }

    private static void syncExec(DecoratedText field, final Runnable runnable) {
        Display display;
        final Text text = field.getText();
        if (!text.isDisposed() && !(display = text.getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!text.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static void updateFocusStatus(DecoratedText field, boolean focus) {
        IStatus status = field.getStatus();
        if (!status.matches(4) && !status.matches(2)) {
            Text text = field.getText();
            if (focus && text.isEnabled()) {
                field.setStatus((IStatus)INFO_STATUS);
            } else {
                field.setStatus(Status.OK_STATUS);
            }
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fEstimateUpdater, this.getPresentation());
            if (this.getCorrectionAttribute() != null) {
                mgr.addPresentationUpdater(this.fCorrectionUpdater, new PresentationDescriptor(null, null, null, WorkItemAttributes.getPropertyIdentifier((String)this.getCorrectionAttribute().getIdentifier()), new HashMap()));
            }
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fEstimateLabel = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
        String displayName = this.getLabel();
        if (displayName == null) {
            displayName = this.getEstimateAttribute().getDisplayName();
        }
        this.fEstimateLabel.setText(MessageFormat.format(Messages.WorkItemEstimateAttributePart_DISPLAY_NAME_PATTERN, displayName));
        this.fEstimateLabel.setTooltip(this.getDescription());
        if (!this.isBuiltInEstimationAttribute()) {
            this.fEstimateLabel.setEnabled(false);
        }
        formLayout.add(this.fEstimateLabel.getLayoutControl(), "label");
        int styles = "carbon".equals(SWT.getPlatform()) ? 16384 : 131072;
        this.fEstimateTextField = new DecoratedFormsText(parent, this.getSite(), styles, 0, this.getBackgroundStyle());
        this.initAccessible((Control)this.fEstimateTextField.getText());
        Util.addNarrowWidthHint((Control)this.fEstimateTextField.getLayoutControl());
        formLayout.add(this.fEstimateTextField.getLayoutControl(), "content");
        this.fEstimateTextField.setStatus(this.getIdleStatus(this.fEstimateTextField));
        this.fEstimateTextField.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                final IAttribute estimateAttribute = WorkItemEstimateAttributePart.this.getEstimateAttribute();
                final String estimateValue = WorkItemEstimateAttributePart.this.fEstimateTextField.getText().getText().trim();
                if (!Messages.WorkItemEstimateAttributePart_PENDING_LABEL.equals(estimateValue)) {
                    AttributePartUpdateJob job = new AttributePartUpdateJob(WorkItemEstimateAttributePart.this, Messages.WorkItemEstimateAttributePart_UPDATE_ESTIMATE_JOB_NAME){

                        @Override
                        protected IStatus doRunProtected(IProgressMonitor monitor) {
                            DurationFormat format = WorkItemEstimateAttributePart.this.getCachedDurationFormat();
                            if (format == null) {
                                format = WorkItemEstimateAttributePart.this.getDurationFormat(monitor);
                            }
                            WorkItemEstimateAttributePart.this.updateAttribute(this.getToken(), resolved, estimateAttribute, estimateValue, WorkItemEstimateAttributePart.this.fEstimateTextField, format, true);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(10);
                    job.setRule(WorkItemEstimateAttributePart.this.fEstimateRule);
                    job.setSystem(true);
                    job.schedule();
                }
            }
        });
        this.fEstimateTextField.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fEstimateTextField, true);
            }

            public void focusLost(FocusEvent event) {
                ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                IAttribute estimateAttribute = WorkItemEstimateAttributePart.this.getEstimateAttribute();
                String estimateValue = WorkItemEstimateAttributePart.this.fEstimateTextField.getText().getText().trim();
                WorkItemEstimateAttributePart.this.updateAttribute(WorkItemEstimateAttributePart.this.fUpdateToken.get(), resolved, estimateAttribute, estimateValue, WorkItemEstimateAttributePart.this.fEstimateTextField, WorkItemEstimateAttributePart.this.getCachedDurationFormat(), false);
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fEstimateTextField, false);
            }
        });
        this.fCorrectionLabel = toolkit.createLabel(parent, MessageFormat.format(Messages.WorkItemEstimateAttributePart_DISPLAY_NAME_PATTERN, Messages.WorkItemEstimateAttributePart_CORRECTION_DISPLAY_NAME), 0, this.getBackgroundStyle());
        formLayout.add((Control)this.fCorrectionLabel, "label2");
        if (!this.isBuiltInEstimationAttribute()) {
            this.fCorrectionLabel.setEnabled(false);
        }
        this.fCorrectionTextField = new DecoratedFormsText(parent, this.getSite(), styles, 0, this.getBackgroundStyle());
        this.initAccessible((Control)this.fCorrectionTextField.getText(), this.fCorrectionLabel.getText());
        Util.addNarrowWidthHint((Control)this.fCorrectionTextField.getLayoutControl());
        formLayout.add(this.fCorrectionTextField.getLayoutControl(), "content2");
        this.fCorrectionTextField.setStatus(this.getIdleStatus(this.fCorrectionTextField));
        this.fCorrectionTextField.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                final IAttribute correctionAttribute = WorkItemEstimateAttributePart.this.getCorrectionAttribute();
                final String correctionValue = WorkItemEstimateAttributePart.this.fCorrectionTextField.getText().getText().trim();
                if (!Messages.WorkItemEstimateAttributePart_PENDING_LABEL.equals(correctionValue)) {
                    AttributePartUpdateJob job = new AttributePartUpdateJob(WorkItemEstimateAttributePart.this, Messages.WorkItemEstimateAttributePart_UPDATE_CORRECTION_JOB_NAME){

                        @Override
                        protected IStatus doRunProtected(IProgressMonitor monitor) {
                            DurationFormat format = WorkItemEstimateAttributePart.this.getCachedDurationFormat();
                            if (format == null) {
                                format = WorkItemEstimateAttributePart.this.getDurationFormat(monitor);
                            }
                            WorkItemEstimateAttributePart.this.updateAttribute(this.getToken(), resolved, correctionAttribute, correctionValue, WorkItemEstimateAttributePart.this.fCorrectionTextField, format, true);
                            this.runWithToken(WorkItemEstimateAttributePart.this.fEstimateTextField, new Runnable(){

                                @Override
                                public void run() {
                                    WorkItemEstimateAttributePart.this.fEstimateTextField.getText().setEnabled("".equals(correctionValue) || Messages.WorkItemEstimateAttributePart_PENDING_LABEL.equals(correctionValue));
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(10);
                    job.setRule(WorkItemEstimateAttributePart.this.fCorrectionRule);
                    job.setSystem(true);
                    job.schedule();
                }
            }
        });
        this.fCorrectionTextField.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fCorrectionTextField, true);
            }

            public void focusLost(FocusEvent event) {
                ResolvedWorkItem resolved = WorkItemEstimateAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                IAttribute correctionAttribute = WorkItemEstimateAttributePart.this.getCorrectionAttribute();
                String correctionValue = WorkItemEstimateAttributePart.this.fCorrectionTextField.getText().getText().trim();
                WorkItemEstimateAttributePart.this.updateAttribute(WorkItemEstimateAttributePart.this.fUpdateToken.get(), resolved, correctionAttribute, correctionValue, WorkItemEstimateAttributePart.this.fCorrectionTextField, WorkItemEstimateAttributePart.this.getCachedDurationFormat(), false);
                WorkItemEstimateAttributePart.updateFocusStatus(WorkItemEstimateAttributePart.this.fCorrectionTextField, false);
            }
        });
        this.doUpdateReadOnly(this.isReadOnly());
    }

    protected void doUpdateReadOnly(boolean readOnly) {
        this.updateReadOnlyFor(this.fEstimateTextField, readOnly);
        this.updateReadOnlyFor(this.fCorrectionTextField, readOnly);
    }

    private void updateReadOnlyFor(DecoratedText textField, boolean readOnly) {
        Control contorl;
        if (textField != null && !(contorl = textField.getLayoutControl()).isDisposed()) {
            contorl.setEnabled(!readOnly);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.getWorkingCopy());
    }

    private DurationFormat getCachedDurationFormat() {
        return this.fDurationFormat;
    }

    private IAttribute getCorrectionAttribute() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        if (copy == null || this.fAttribute != null && copy.getWorkItem().getProjectArea().sameItemId((IItemHandle)this.fAttribute.getProjectArea())) {
            return this.fAttribute;
        }
        return this.getUIWorkingCopy().getResolvedWorkItem().findAttribute(WorkItemAttributes.CORRECTED_ESTIMATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DurationFormat getDurationFormat(IProgressMonitor monitor) {
        if (this.fDurationFormat == null) {
            Object object = this.fFormatLock;
            synchronized (object) {
                if (this.fDurationFormat == null) {
                    DurationFormat format = new DurationFormat(2);
                    WorkItemWorkingCopy copy = this.getWorkingCopy();
                    if (copy != null) {
                        try {
                            IterationPlanClient planClient;
                            EstimateOutputFormat outputFormat;
                            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
                            IProjectAreaHandle projectArea = copy.getWorkItem().getProjectArea();
                            IProcessAreaInfo info = manager.getProcessAreaInfo((IProcessAreaHandle)projectArea, false, monitor);
                            if (info != null) {
                                int days = info.getWorkWeekDays();
                                if (days <= 0) {
                                    days = 5;
                                }
                                format.setDaysPerWeek(days);
                                long millis = info.getWorkDayMillis();
                                if (millis <= 0L) {
                                    millis = 28800000L;
                                }
                                format.setMillisPerDay(millis);
                            }
                            if (EstimateOutputFormat.Hours.equals((Object)(outputFormat = (planClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)copy.getTeamRepository())).fetchEstimateOutputFormatCached((IProcessAreaHandle)projectArea, monitor)))) {
                                format.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
                            }
                        }
                        catch (TeamRepositoryException exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    }
                    this.fDurationFormat = format;
                }
            }
        }
        return this.fDurationFormat;
    }

    private IAttribute getEstimateAttribute() {
        return this.getAttribute();
    }

    private WorkItemUIWorkingCopy getUIWorkingCopy() {
        return (WorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
    }

    private boolean isProcessAreaInfoCached() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
        return manager.findCachedProcessAreaInfo((IProcessAreaHandle)copy.getWorkItem().getProjectArea()) != null;
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fEstimateUpdater);
            mgr.removePresentationUpdater(this.fCorrectionUpdater);
        }
    }

    public void setFocus() {
        this.fCorrectionTextField.getText().setFocus();
    }

    public void setInput(Object input) {
        this.fUpdateToken.getAndIncrement();
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.fEstimateRule = new ExclusiveSchedulingRule(this.getEstimateAttribute());
            this.fCorrectionRule = new ExclusiveSchedulingRule(this.getCorrectionAttribute());
            this.addListeners();
            Text text = this.fEstimateTextField.getText();
            DurationFormat cached = this.getCachedDurationFormat();
            boolean refreshInfo = !this.isProcessAreaInfoCached();
            ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
            if (cached == null && WorkItemEstimateAttributePart.getDuration(resolved, this.getEstimateAttribute()).longValue() >= 0L && refreshInfo) {
                text.setEnabled(false);
                text.setText(Messages.WorkItemEstimateAttributePart_PENDING_LABEL);
            }
            text = this.fCorrectionTextField.getText();
            if (cached == null && WorkItemEstimateAttributePart.getDuration(resolved, this.getCorrectionAttribute()).longValue() >= 0L && refreshInfo) {
                text.setEnabled(false);
                text.setText(Messages.WorkItemEstimateAttributePart_PENDING_LABEL);
            }
            this.updateEstimateField();
            this.updateCorrectionField();
        } else {
            this.fEstimateRule = null;
            this.fCorrectionRule = null;
            this.fWorkingCopy = null;
        }
    }

    private void updateAttribute(final int token, ResolvedWorkItem item, IAttribute attribute, final String value, final DecoratedText field, DurationFormat format, final boolean dirtyOnly) {
        Duration duration = Duration.INVALID;
        try {
            try {
                duration = WorkItemEstimateAttributePart.parseDuration(value, attribute.getDisplayName(), format);
                long number = duration.longValue();
                if (number >= 0L && number % 1000L != 0L) {
                    throw new ParseException(MessageFormat.format(Messages.WorkItemEstimateAttributePart_NO_MILLISECONDS_HINT, attribute.getDisplayName()), 0);
                }
                final Duration finalDuration = duration;
                final DurationFormat finalFormat = format;
                WorkItemEstimateAttributePart.syncExec(field, new Runnable(){

                    @Override
                    public void run() {
                        if (token == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                            String formatted;
                            if (!dirtyOnly && !value.equals(formatted = finalFormat.format(finalDuration))) {
                                field.setValue(formatted);
                            }
                            field.setStatus(WorkItemEstimateAttributePart.this.getIdleStatus(field));
                        }
                    }
                });
            }
            catch (ParseException exception) {
                WorkItemWorkingCopy copy;
                Duration predecessor;
                WorkItemEstimateAttributePart.syncExec(field, new Runnable(){

                    @Override
                    public void run() {
                        if (token == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                            field.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                        }
                    }
                });
                if (token == this.fUpdateToken.get() && !duration.equals((Object)(predecessor = WorkItemEstimateAttributePart.getDuration(item, attribute))) && (copy = this.getWorkingCopy()) != null) {
                    if (dirtyOnly) {
                        if (!Duration.INVALID.equals((Object)predecessor)) {
                            ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                        }
                    } else if (!Duration.INVALID.equals((Object)duration)) {
                        this.fDurationSupport.setCurrentEstimate(item.getWorkItem(), attribute.sameItemId((IItemHandle)this.getCorrectionAttribute()), WorkItems.isResolved((IWorkItem)item.getWorkItem(), (IWorkflowInfo)item.getWorkflowInfo()), duration.longValue());
                    }
                }
            }
        }
        finally {
            WorkItemWorkingCopy copy;
            Duration predecessor;
            if (token == this.fUpdateToken.get() && !duration.equals((Object)(predecessor = WorkItemEstimateAttributePart.getDuration(item, attribute))) && (copy = this.getWorkingCopy()) != null) {
                if (dirtyOnly) {
                    if (!Duration.INVALID.equals((Object)predecessor)) {
                        ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                    }
                } else if (!Duration.INVALID.equals((Object)duration)) {
                    this.fDurationSupport.setCurrentEstimate(item.getWorkItem(), attribute.sameItemId((IItemHandle)this.getCorrectionAttribute()), WorkItems.isResolved((IWorkItem)item.getWorkItem(), (IWorkflowInfo)item.getWorkflowInfo()), duration.longValue());
                }
            }
        }
    }

    private void updateCorrectionField() {
        final ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
        final IAttribute correctionAttribute = this.getCorrectionAttribute();
        final String correctionValue = this.fCorrectionTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(this, Messages.WorkItemEstimateAttributePart_UPDATE_CORRECTION_FIELD_JOB_NAME){

            @Override
            protected IStatus doRunProtected(IProgressMonitor monitor) {
                DurationFormat format = this.getCachedDurationFormat();
                if (format == null) {
                    format = this.getDurationFormat(monitor);
                }
                this.updateTextField(this, resolved, correctionAttribute, correctionValue, fCorrectionTextField, format, true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(this.fCorrectionRule);
        job.setSystem(true);
        job.schedule();
    }

    private void updateEstimateField() {
        final ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
        final IAttribute estimateAttribute = this.getEstimateAttribute();
        final IAttribute correctionAttribute = this.getCorrectionAttribute();
        final String estimateValue = this.fEstimateTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(this, Messages.WorkItemEstimateAttributePart_UPDATE_ESTIMATE_FIELD_JOB_NAME){

            @Override
            protected IStatus doRunProtected(IProgressMonitor monitor) {
                DurationFormat format = this.getCachedDurationFormat();
                if (format == null) {
                    format = this.getDurationFormat(monitor);
                }
                Duration duration = WorkItemEstimateAttributePart.getDuration(resolved, correctionAttribute);
                this.updateTextField(this, resolved, estimateAttribute, estimateValue, fEstimateTextField, format, Duration.UNSPECIFIED.equals((Object)duration));
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(this.fEstimateRule);
        job.setSystem(true);
        job.schedule();
    }

    private void updateTextField(AttributePartUpdateJob job, ResolvedWorkItem item, IAttribute attribute, String value, final DecoratedText field, DurationFormat format, final boolean enabled) {
        block3: {
            Duration duration = WorkItemEstimateAttributePart.getDuration(item, attribute);
            try {
                if (!duration.equals((Object)WorkItemEstimateAttributePart.parseDuration(value, attribute.getDisplayName(), format))) {
                    final String formatted = format.format(duration);
                    job.runWithToken(field, new Runnable(){

                        @Override
                        public void run() {
                            Text text = field.getText();
                            text.setText(formatted);
                            text.setEnabled(enabled);
                        }
                    });
                }
            }
            catch (ParseException exception) {
                if (!duration.isValid()) break block3;
                final String formatted = format.format(duration);
                job.runWithToken(field, new Runnable(){

                    @Override
                    public void run() {
                        Text text = field.getText();
                        text.setText(formatted);
                        text.setEnabled(enabled);
                    }
                });
            }
        }
    }

    private abstract class AttributePartUpdateJob
    extends FoundationJob {
        private final int fToken;

        AttributePartUpdateJob(String name) {
            super(name);
            this.fToken = WorkItemEstimateAttributePart.this.fUpdateToken.get();
        }

        protected abstract IStatus doRunProtected(IProgressMonitor var1) throws Exception;

        protected final int getToken() {
            return this.fToken;
        }

        protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (WorkItemEstimateAttributePart.this.fDurationSupport == null) {
                IWorkItem workItem = WorkItemEstimateAttributePart.this.getWorkingCopy().getWorkItem();
                WorkItemEstimateAttributePart.this.fDurationSupport = DurationSupport.FACTORY.getInstance((IProcessAreaHandle)workItem.getProjectArea(), monitor);
            }
            if (WorkItemEstimateAttributePart.this.fDurationSupport == null) {
                return Status.CANCEL_STATUS;
            }
            if (this.fToken == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                return this.doRunProtected(monitor);
            }
            return Status.OK_STATUS;
        }

        protected final void runWithToken(DecoratedText field, final Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            WorkItemEstimateAttributePart.syncExec(field, new Runnable(){

                @Override
                public void run() {
                    if (AttributePartUpdateJob.this.fToken == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                        runnable.run();
                    }
                }
            });
        }

        protected final void runWithToken(Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            if (this.fToken == WorkItemEstimateAttributePart.this.fUpdateToken.get()) {
                runnable.run();
            }
        }
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private final IAttribute fAttribute;

        ExclusiveSchedulingRule(IAttribute attribute) {
            this.fAttribute = attribute;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof ExclusiveSchedulingRule) {
                ExclusiveSchedulingRule extended = (ExclusiveSchedulingRule)rule;
                return extended.fAttribute.sameItemId((IItemHandle)this.fAttribute);
            }
            return false;
        }
    }
}

