/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.team.apt.common.resource.IWorkDayDefinition;
import com.ibm.team.apt.common.resource.IWorkLocationDefinition;
import com.ibm.team.apt.common.resource.ResourcePlanningUtils;
import com.ibm.team.apt.internal.client.resource.OperationStatus;
import com.ibm.team.apt.internal.common.resource.model.WorkDayDefinition;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.apt.internal.ide.ui.resource.parts.AbstractContributorResourceFormPart;
import com.ibm.team.apt.internal.ide.ui.resource.parts.IWorkLocationListener;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.apt.internal.ide.ui.resource.widgets.WorkDayDefinitionDialog;
import com.ibm.team.apt.internal.ide.ui.util.PixelConverter;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.internal.ide.ui.editors.contributor.ContributorEditor;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class WorkDaysDefinitionFormPart
extends AbstractContributorResourceFormPart
implements IWorkLocationListener {
    static final DurationFormat fgDurationFormat = new DurationFormat(2);
    public static final String PART_ID = "com.ibm.team.apt.resource.work.days.definition.part.name";
    private TableColumn fDayColumn;
    private Button fDeselectAllButton;
    private Button fEditButton;
    private Locale fLocale = null;
    private IProgressMonitor fMonitor = null;
    private final ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Button fSelectAllButton;
    private DateFormat fWeekDayFormat = new SimpleDateFormat("EEEE");
    private TableViewer fWorkDayViewer;
    private TableColumn fWorkEndColumn;
    private final DateFormat fWorkEndFormat = DateFormat.getTimeInstance((int)3);
    private TableColumn fWorkTimeColumn;

    static {
        fgDurationFormat.setMillisPerDay(86400000L);
        fgDurationFormat.setDaysPerWeek(7);
    }

    private static void setButtonWidth(Button button) {
        Assert.isNotNull((Object)button);
        Object data = button.getLayoutData();
        if (data instanceof GridData) {
            GridData extended = (GridData)data;
            extended.widthHint = Math.max(new PixelConverter((Control)button).convertHorizontalDLUsToPixels(61), button.computeSize((int)-1, (int)-1, (boolean)true).x);
            extended.horizontalAlignment = 4;
        }
    }

    public WorkDaysDefinitionFormPart(AbstractContributorResourceFormPage page) {
        super(page);
        this.setId(PART_ID);
        this.fWorkEndFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
    }

    private Button createButton(Composite parent, String label) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)label);
        FormToolkit toolkit = this.getToolkit();
        Button button = toolkit.createButton(parent, label, 8);
        button.setLayoutData((Object)new GridData(258));
        WorkDaysDefinitionFormPart.setButtonWidth(button);
        return button;
    }

    private void createButtons(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(144));
        this.fEditButton = this.createButton(composite, Messages.WorkDaysDefinitionFormPart_EDIT_BUTTON_LABEL);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkDaysDefinitionFormPart.this.editSelection((IStructuredSelection)WorkDaysDefinitionFormPart.this.fWorkDayViewer.getSelection());
            }
        });
        this.fEditButton.setEnabled(false);
        Label dummy = toolkit.createLabel(composite, "");
        this.fSelectAllButton = this.createButton(composite, Messages.WorkDaysDefinitionFormPart_SELECT_ALL_BUTTON_LABEL);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkDaysDefinitionFormPart.this.selectAll();
            }
        });
        this.fDeselectAllButton = this.createButton(composite, Messages.WorkDaysDefinitionFormPart_DESELECT_ALL_BUTTON_LABEL);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WorkDaysDefinitionFormPart.this.fWorkDayViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        });
        this.fDeselectAllButton.setEnabled(false);
        GridData data = new GridData();
        data.heightHint = new PixelConverter((Control)parent).convertHeightInCharsToPixels(1) / 2;
        dummy.setLayoutData((Object)data);
    }

    public void createContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent event) {
                4 var2_2 = this;
                synchronized (var2_2) {
                    if (WorkDaysDefinitionFormPart.this.fMonitor != null && !WorkDaysDefinitionFormPart.this.fMonitor.isCanceled()) {
                        WorkDaysDefinitionFormPart.this.fMonitor.setCanceled(true);
                    }
                }
            }
        });
        this.createDescription(parent);
        Composite composite = toolkit.createComposite(parent);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createWorkDayViewer(composite);
        this.createButtons(composite);
        this.hookGlobalActions();
    }

    private void createDescription(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        Text sectionLabel = toolkit.createText(parent, Messages.WorkDaysDefinitionFormPart_DEFINE_WORK_DAYS_LABEL, 8);
        sectionLabel.setLayoutData((Object)new GridData(4, 1, false, false));
    }

    private void createWorkDayViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        FormToolkit toolkit = this.getToolkit();
        final Table table = toolkit.createTable(parent, 67586);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fDayColumn = new TableColumn(table, 16384, 0);
        this.fDayColumn.setWidth(140);
        this.fDayColumn.setResizable(true);
        this.fDayColumn.setText(Messages.WorkDaysDefinitionFormPart_DAY_COLUMN);
        this.fDayColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn column = table.getSortColumn();
                if (column != WorkDaysDefinitionFormPart.this.fDayColumn) {
                    table.setSortColumn(WorkDaysDefinitionFormPart.this.fDayColumn);
                } else {
                    int direction = table.getSortDirection();
                    if (direction == 128) {
                        table.setSortDirection(1024);
                    } else if (direction == 1024) {
                        table.setSortDirection(128);
                    }
                }
                WorkDaysDefinitionFormPart.this.fWorkDayViewer.refresh(false);
            }
        });
        this.fWorkTimeColumn = new TableColumn(table, 16384, 1);
        this.fWorkTimeColumn.setWidth(180);
        this.fWorkTimeColumn.setResizable(true);
        this.fWorkTimeColumn.setText(Messages.WorkDaysDefinitionFormPart_WORK_TIME_COLUMN);
        this.fWorkTimeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn column = table.getSortColumn();
                if (column != WorkDaysDefinitionFormPart.this.fWorkTimeColumn) {
                    table.setSortColumn(WorkDaysDefinitionFormPart.this.fWorkTimeColumn);
                } else {
                    int direction = table.getSortDirection();
                    if (direction == 128) {
                        table.setSortDirection(1024);
                    } else if (direction == 1024) {
                        table.setSortDirection(128);
                    }
                }
                WorkDaysDefinitionFormPart.this.fWorkDayViewer.refresh(false);
            }
        });
        this.fWorkEndColumn = new TableColumn(table, 16384, 2);
        this.fWorkEndColumn.setWidth(180);
        this.fWorkEndColumn.setResizable(true);
        this.fWorkEndColumn.setText(Messages.WorkDaysDefinitionFormPart_END_TIME_COLUMN);
        this.fWorkEndColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableColumn column = table.getSortColumn();
                if (column != WorkDaysDefinitionFormPart.this.fWorkEndColumn) {
                    table.setSortColumn(WorkDaysDefinitionFormPart.this.fWorkEndColumn);
                } else {
                    int direction = table.getSortDirection();
                    if (direction == 128) {
                        table.setSortDirection(1024);
                    } else if (direction == 1024) {
                        table.setSortDirection(128);
                    }
                }
                WorkDaysDefinitionFormPart.this.fWorkDayViewer.refresh(false);
            }
        });
        table.setSortColumn(this.fDayColumn);
        table.setSortDirection(128);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Work time";
            }
        });
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                final IStructuredSelection selection = (IStructuredSelection)WorkDaysDefinitionFormPart.this.fWorkDayViewer.getSelection();
                if (!selection.isEmpty()) {
                    menu.add((IAction)new Action(Messages.WorkDaysDefinitionFormPart_EDIT_CONTEXT_ACTION){

                        public void run() {
                            WorkDaysDefinitionFormPart.this.editSelection(selection);
                        }
                    });
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)table);
        table.setMenu(menu);
        this.fWorkDayViewer = new TableViewer(table);
        this.fWorkDayViewer.setLabelProvider((IBaseLabelProvider)new WorkDaysLabelProvider());
        this.fWorkDayViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fWorkDayViewer.setComparator((ViewerComparator)new WorkDaysViewerComparator());
        this.fWorkDayViewer.setColumnProperties(new String[]{Messages.WorkDaysDefinitionFormPart_DAY_PROPERTY, Messages.WorkDaysDefinitionFormPart_WORK_TIME_PROPERTY, Messages.WorkDaysDefinitionFormPart_END_TIME_PROPERTY});
        this.fWorkDayViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Assert.isNotNull((Object)event);
                int total = 0;
                Collection definitions = (Collection)WorkDaysDefinitionFormPart.this.fWorkDayViewer.getInput();
                if (definitions != null) {
                    total = definitions.size();
                }
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int size = selection.size();
                WorkDaysDefinitionFormPart.this.fEditButton.setEnabled(size >= 1);
                WorkDaysDefinitionFormPart.this.fDeselectAllButton.setEnabled(size > 0);
                WorkDaysDefinitionFormPart.this.fSelectAllButton.setEnabled(size != total);
            }
        });
        this.fWorkDayViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    WorkDaysDefinitionFormPart.this.editSelection(selection);
                }
            }
        });
        new TooltipSupport((Control)table, true, true){

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof IWorkDayDefinition) {
                    IWorkDayDefinition definition = (IWorkDayDefinition)element;
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(System.currentTimeMillis());
                    calendar.set(7, definition.getDay().getValue());
                    StringBuilder builder = new StringBuilder(256);
                    builder.append("<b>");
                    builder.append(WorkDaysDefinitionFormPart.this.fWeekDayFormat.format(calendar.getTime()));
                    builder.append("</b><br/>");
                    long workingTime = definition.getWorkingTime();
                    if (workingTime > 0L) {
                        String formatted = fgDurationFormat.format(new Duration(workingTime));
                        builder.append(MessageFormat.format((String)Messages.WorkDaysDefinitionFormPart_WORK_TIME_PATTERN, (Object[])new String[]{formatted}));
                    } else {
                        builder.append(Messages.WorkDaysDefinitionFormPart_NO_WORK_TIME_LABEL);
                    }
                    long endTime = definition.getEndTime();
                    if (endTime > 0L) {
                        calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                        calendar.setTimeInMillis(endTime);
                        builder.append("<br/>");
                        builder.append(MessageFormat.format((String)Messages.WorkDaysDefinitionFormPart_END_TIME_PATTERN, (Object[])new String[]{WorkDaysDefinitionFormPart.this.fWorkEndFormat.format(calendar.getTime())}));
                    }
                    WorkDaysDefinitionFormPart.this.appendMailLinks(builder, isFocus);
                    return builder.toString();
                }
                return super.getMarkup(element, isFocus);
            }

            protected void openRequested(Object element) {
                if (element != null) {
                    WorkDaysDefinitionFormPart.this.editSelection((IStructuredSelection)new StructuredSelection(element));
                }
            }
        };
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fWorkDayViewer, this.fWorkDayViewer.getControl());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fResourceManager.dispose();
    }

    private void editSelection(IStructuredSelection selection) {
        WorkDayDefinitionDialog dialog;
        List definitions = selection.toList();
        if (!definitions.isEmpty() && (dialog = new WorkDayDefinitionDialog(this.getShell(), Messages.WorkDaysDefinitionFormPart_EDIT_WORK_DAY_DIALOG_CAPTION, definitions, this.fLocale)).open() == 0) {
            boolean workDay = dialog.isWorkDay();
            for (IWorkDayDefinition definition : definitions) {
                if (!(definition instanceof WorkDayDefinition)) continue;
                WorkDayDefinition extended = (WorkDayDefinition)definition;
                if (workDay) {
                    extended.setWorkingTime(dialog.getWorkingTime());
                    extended.setEndTime(dialog.getEndTime());
                    continue;
                }
                extended.setWorkingTime(0L);
                extended.setEndTime(0L);
            }
            this.fWorkDayViewer.refresh(true);
            this.getFormPage().setDirty(true);
            this.validate();
        }
    }

    private void hookGlobalActions() {
        IActionBars bars = this.getFormPage().getEditorSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new Action(Messages.WorkDaysDefinitionFormPart_SELECT_ALL_GLOBAL_ACTION_LABEL){

            public void run() {
                WorkDaysDefinitionFormPart.this.selectAll();
            }
        });
    }

    @Override
    public void localeChanged(Locale locale) {
        this.fLocale = locale;
        if (this.fLocale != null && this.fWorkDayViewer != null) {
            this.fWorkDayViewer.refresh();
        }
    }

    @Override
    public synchronized boolean save(IProgressMonitor monitor) {
        block4: {
            Control control;
            AbstractContributorResourceInput input = this.getInput();
            if (input != null && !(control = this.fWorkDayViewer.getControl()).isDisposed()) {
                Display display = control.getDisplay();
                try {
                    final IWorkLocationDefinition workingCopy = input.getWorkLocationWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!control.isDisposed()) {
                                    WorkDaysDefinitionFormPart.this.fWorkDayViewer.setInput((Object)workingCopy.getWorkDays());
                                }
                            }
                        });
                    }
                }
                catch (TeamRepositoryException exception) {
                    if (display.isDisposed()) break block4;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FormEditor editor;
                            AbstractContributorResourceFormPage page;
                            if (!control.isDisposed() && (page = WorkDaysDefinitionFormPart.this.getFormPage()) != null && (editor = page.getEditor()) instanceof ContributorEditor) {
                                ContributorEditor extended = (ContributorEditor)editor;
                                extended.setStatus(Messages.WorkDaysDefinitionFormPart_SAVE_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                            }
                        }
                    });
                }
            }
        }
        return true;
    }

    private void selectAll() {
        Collection definitions = (Collection)this.fWorkDayViewer.getInput();
        this.fWorkDayViewer.setSelection((ISelection)new StructuredSelection(definitions.toArray()), true);
        this.fWorkDayViewer.getTable().setFocus();
    }

    @Override
    public synchronized void setInput(Object object) {
        AbstractContributorResourceInput predecessor = this.getInput();
        if (predecessor == object) {
            return;
        }
        super.setInput(object);
        final AbstractContributorResourceInput input = this.getInput();
        FoundationJob job = new FoundationJob(Messages.WorkDaysDefinitionFormPart_FETCHING_WORK_INFORMATION_JOB_NAME){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus runProtected(IProgressMonitor monitor) {
                block15: {
                    Assert.isNotNull((Object)monitor);
                    16 var2_2 = this;
                    synchronized (var2_2) {
                        WorkDaysDefinitionFormPart.this.fMonitor = monitor;
                    }
                    final Control control = WorkDaysDefinitionFormPart.this.fWorkDayViewer.getControl();
                    if (control.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    Display display = control.getDisplay();
                    try {
                        boolean permissions;
                        IWorkLocationDefinition workingCopy;
                        OperationStatus<IWorkLocationDefinition> status;
                        monitor.beginTask(Messages.WorkDaysDefinitionFormPart_FETCHING_WORK_INFORMATION_TASK_NAME, 300);
                        16 var7_4 = this;
                        synchronized (var7_4) {
                            if (input != null) {
                                status = input.getWorkLocation((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                workingCopy = input.getWorkLocationWorkingCopy((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                permissions = input.checkWritePermissions((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                            } else {
                                status = null;
                                workingCopy = null;
                                permissions = true;
                            }
                        }
                        if (workingCopy != null && !display.isDisposed()) {
                            display.asyncExec(new Runnable((IStatus)status, permissions, workingCopy){
                                private final /* synthetic */ IStatus val$status;
                                private final /* synthetic */ boolean val$permissions;
                                private final /* synthetic */ IWorkLocationDefinition val$workingCopy;
                                {
                                    this.val$status = iStatus;
                                    this.val$permissions = bl;
                                    this.val$workingCopy = iWorkLocationDefinition;
                                }

                                @Override
                                public void run() {
                                    if (!control.isDisposed()) {
                                        WorkDaysDefinitionFormPart.this.fLocale = null;
                                        AbstractContributorResourceFormPage page = WorkDaysDefinitionFormPart.this.getFormPage();
                                        if (this.val$status != null) {
                                            if (!this.val$permissions) {
                                                page.setPermanentMessage(Messages.WorkDaysDefinitionFormPart_NO_PERMISSION_HINT, 1);
                                            }
                                            WorkDaysDefinitionFormPart.this.fLocale = ResourcePlanningUtils.getLocale((IWorkLocationDefinition)this.val$workingCopy);
                                            WorkDaysDefinitionFormPart.this.fWeekDayFormat = (DateFormat)new SimpleDateFormat("EEEE");
                                            WorkDaysDefinitionFormPart.this.fWorkDayViewer.setInput((Object)this.val$workingCopy.getWorkDays());
                                            WorkDaysDefinitionFormPart.this.fEditButton.setEnabled(false);
                                            WorkDaysDefinitionFormPart.this.fSelectAllButton.setEnabled(true);
                                            WorkDaysDefinitionFormPart.this.fDeselectAllButton.setEnabled(false);
                                        } else {
                                            WorkDaysDefinitionFormPart.this.fEditButton.setEnabled(false);
                                            WorkDaysDefinitionFormPart.this.fSelectAllButton.setEnabled(false);
                                            WorkDaysDefinitionFormPart.this.fDeselectAllButton.setEnabled(false);
                                        }
                                        page.getManagedForm().getForm().layout(true, true);
                                        WorkDaysDefinitionFormPart.this.validate();
                                    }
                                }
                            });
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        if (display.isDisposed()) break block15;
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                FormEditor editor;
                                AbstractContributorResourceFormPage page;
                                if (!control.isDisposed() && (page = WorkDaysDefinitionFormPart.this.getFormPage()) != null && (editor = page.getEditor()) instanceof ContributorEditor) {
                                    ContributorEditor extended = (ContributorEditor)editor;
                                    extended.setStatus(Messages.WorkDaysDefinitionFormPart_LOAD_PROBLEM, (IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                                }
                            }
                        });
                    }
                }
                16 var4_9 = this;
                synchronized (var4_9) {
                    WorkDaysDefinitionFormPart.this.fMonitor = null;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.setSystem(true);
        job.schedule();
    }

    private void validate() {
        Collection workDays = (Collection)this.fWorkDayViewer.getInput();
        boolean isValid = true;
        if (workDays != null) {
            isValid = false;
            for (IWorkDayDefinition workDay : workDays) {
                isValid |= workDay.getWorkingTime() > 0L && workDay.getEndTime() > 0L;
            }
        }
        AbstractContributorResourceFormPage page = this.getFormPage();
        if (!isValid) {
            page.setValidationMessage(Messages.WorkDaysDefinitionFormPart_NO_WORK_DAYS_ERROR, 3);
        } else {
            page.setValidationMessage(null, 0);
            for (IWorkDayDefinition workDay : workDays) {
                if (workDay.getWorkingTime() <= workDay.getEndTime()) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.set(7, workDay.getDay().getValue());
                page.setValidationMessage(NLS.bind((String)Messages.WorkDaysDefinitionFormPart_WORKING_TIME_EXCEEDS_QUITTING_TIME_ERROR, (Object)this.fWeekDayFormat.format(calendar.getTime()), (Object[])new Object[0]), 3);
                break;
            }
        }
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    @Override
    public void timeZoneChanged(TimeZone zone) {
    }

    private final class WorkDaysLabelProvider
    extends CellLabelProvider {
        private WorkDaysLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Assert.isNotNull((Object)cell);
            IWorkDayDefinition definition = (IWorkDayDefinition)cell.getElement();
            int index = cell.getColumnIndex();
            if (index == 0) {
                cell.setImage(WorkDaysDefinitionFormPart.this.fResourceManager.createImage(ImagePool.DUE_DATE));
                Calendar calendar = Calendar.getInstance();
                calendar.set(7, definition.getDay().getValue());
                cell.setText(WorkDaysDefinitionFormPart.this.fWeekDayFormat.format(calendar.getTime()));
            } else if (index == 1) {
                long workingTime = definition.getWorkingTime();
                if (workingTime > 0L) {
                    cell.setText(fgDurationFormat.format(new Duration(workingTime)));
                } else {
                    cell.setText(Messages.WorkDaysDefinitionFormPart_NONE_LABEL);
                }
            } else if (index == 2) {
                long endTime = definition.getEndTime();
                if (endTime > 0L) {
                    Calendar calendar = Calendar.getInstance((TimeZone)TimeZone.getTimeZone((String)"GMT"), (Locale)WorkDaysDefinitionFormPart.this.fLocale);
                    calendar.setTimeInMillis(endTime);
                    cell.setText(WorkDaysDefinitionFormPart.this.fWorkEndFormat.format(calendar.getTime()));
                } else {
                    cell.setText(Messages.WorkDaysDefinitionFormPart_NONE_LABEL);
                }
            }
        }
    }

    private final class WorkDaysViewerComparator
    extends ViewerComparator {
        private WorkDaysViewerComparator() {
        }

        public int compare(Viewer viewer, Object first, Object second) {
            TableViewer extended = (TableViewer)viewer;
            IWorkDayDefinition firstDefinition = (IWorkDayDefinition)first;
            IWorkDayDefinition secondDefinition = (IWorkDayDefinition)second;
            Table table = extended.getTable();
            TableColumn column = table.getSortColumn();
            boolean up = table.getSortDirection() == 128;
            int result = 0;
            if (column == WorkDaysDefinitionFormPart.this.fDayColumn) {
                int firstDay = Calendar.getInstance().getFirstDayOfWeek();
                int firstValue = firstDefinition.getDay().getValue();
                if (firstDay >= 0 && firstDay - firstValue > 0) {
                    firstValue += 7;
                }
                int secondValue = secondDefinition.getDay().getValue();
                if (firstDay >= 0 && firstDay - secondValue > 0) {
                    secondValue += 7;
                }
                result = firstValue - secondValue;
            } else if (column == WorkDaysDefinitionFormPart.this.fWorkTimeColumn) {
                long secondTime;
                long firstTime = firstDefinition.getWorkingTime();
                if (firstTime < (secondTime = secondDefinition.getWorkingTime())) {
                    result = -1;
                } else if (firstTime > secondTime) {
                    result = 1;
                }
            } else if (column == WorkDaysDefinitionFormPart.this.fWorkEndColumn) {
                long secondTime;
                long firstTime = firstDefinition.getEndTime();
                if (firstTime < (secondTime = secondDefinition.getEndTime())) {
                    result = -1;
                } else if (firstTime > secondTime) {
                    result = 1;
                }
            }
            if (result != 0) {
                return up ? result : -1 * result;
            }
            return 0;
        }
    }
}

