/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.resource.IProcessAreaInfo;
import com.ibm.team.apt.internal.client.resource.ResourcePlanningManager;
import com.ibm.team.apt.internal.common.util.EstimateOutputFormat;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.resource.parts.Messages;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public final class DurationAttributePart
extends AttributePart {
    private static final long SECOND_MILLIS = 1000L;
    private static final Status INFO_STATUS = new Status(1, PlanningUIPlugin.getPluginId(), Messages.DurationAttributePart_INFO_MESSAGE);
    private volatile DurationFormat fDurationFormat = null;
    private RequiredPropertyLabel fLabel;
    private ISchedulingRule fRule;
    private DecoratedText fTextField;
    private final Object fFormatLock = new Object();
    private IPresentationUpdater fEstimateUpdater = new AbstractPresentationUpdater(){

        public void setRequired(boolean required) {
            if (DurationAttributePart.this.fLabel != null && !DurationAttributePart.this.fLabel.isDisposed()) {
                DurationAttributePart.this.fLabel.setRequired(required);
            }
        }

        public void setReadOnly(boolean readOnly) {
            DurationAttributePart.this.updateReadOnly(readOnly);
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            DurationAttributePart.this.updateEstimateField();
        }

        public void setStatus(IStatus status) {
            DurationAttributePart.this.fTextField.setStatus(status);
        }
    };
    private final AtomicInteger fUpdateToken = new AtomicInteger(0);

    private static final Duration getDuration(ResolvedWorkItem item, IAttribute attribute) {
        Long number = (Long)item.getValue(attribute);
        if (number != null) {
            return new Duration(number.longValue());
        }
        return Duration.UNSPECIFIED;
    }

    private static IStatus getIdleStatus(DecoratedText field) {
        Text text = field.getText();
        if (text.isFocusControl() && text.isEnabled()) {
            return INFO_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static long getWorkYearMillis(DurationFormat format) {
        return format.getMillisPerDay() * (long)format.getDaysPerWeek() * 52L;
    }

    private static Duration parseDuration(String text, String name, DurationFormat format) throws ParseException {
        if (text == null || text.length() == 0) {
            return Duration.UNSPECIFIED;
        }
        Duration duration = format.parse(text);
        if (duration.longValue() > DurationAttributePart.getWorkYearMillis(format)) {
            throw new ParseException(Messages.DurationAttributePart_NOT_LONGER_THEN_A_YEAR, 0);
        }
        return duration;
    }

    private static void syncExec(DecoratedText field, final Runnable runnable) {
        Display display;
        final Text text = field.getText();
        if (!text.isDisposed() && !(display = text.getDisplay()).isDisposed()) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!text.isDisposed()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static void updateFocusStatus(DecoratedText field, boolean focus) {
        IStatus status = field.getStatus();
        if (!status.matches(4) && !status.matches(2)) {
            Text text = field.getText();
            if (focus && text.isEnabled()) {
                field.setStatus((IStatus)INFO_STATUS);
            } else {
                field.setStatus(Status.OK_STATUS);
            }
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fEstimateUpdater, this.getPresentation());
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fLabel = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
        String displayName = this.getLabel();
        if (displayName == null) {
            displayName = this.getAttribute().getDisplayName();
        }
        this.fLabel.setText(MessageFormat.format(Messages.DurationAttributePart_LABEL_FORMAT, displayName));
        this.fLabel.setTooltip(this.getDescription());
        formLayout.add(this.fLabel.getLayoutControl(), "label");
        int styles = "carbon".equals(SWT.getPlatform()) ? 16384 : 131072;
        this.fTextField = new DecoratedFormsText(parent, this.getSite(), styles, 0, this.getBackgroundStyle());
        this.initAccessible((Control)this.fTextField.getText());
        Util.addNarrowWidthHint((Control)this.fTextField.getLayoutControl());
        formLayout.add(this.fTextField.getLayoutControl(), "content");
        this.fTextField.setStatus(DurationAttributePart.getIdleStatus(this.fTextField));
        this.fTextField.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                final ResolvedWorkItem resolved = DurationAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                final IAttribute attribute = DurationAttributePart.this.getAttribute();
                final String value = DurationAttributePart.this.fTextField.getText().getText().trim();
                if (!Messages.DurationAttributePart_PENDING_LABEL.equals(value)) {
                    AttributePartUpdateJob job = new AttributePartUpdateJob(DurationAttributePart.this, Messages.DurationAttributePart_UPDATE_ATTRIBUTE){

                        @Override
                        protected IStatus doRunProtected(IProgressMonitor monitor) {
                            DurationFormat format = DurationAttributePart.this.getCachedDurationFormat();
                            if (format == null) {
                                format = DurationAttributePart.this.getDurationFormat(monitor);
                            }
                            DurationAttributePart.this.updateAttribute(this.getToken(), resolved, attribute, value, DurationAttributePart.this.fTextField, format, true);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setPriority(10);
                    job.setRule(DurationAttributePart.this.fRule);
                    job.setSystem(true);
                    job.schedule();
                }
            }
        });
        this.fTextField.getText().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                DurationAttributePart.updateFocusStatus(DurationAttributePart.this.fTextField, true);
            }

            public void focusLost(FocusEvent event) {
                ResolvedWorkItem resolved = DurationAttributePart.this.getUIWorkingCopy().getResolvedWorkItem();
                IAttribute attribute = DurationAttributePart.this.getAttribute();
                String value = DurationAttributePart.this.fTextField.getText().getText().trim();
                DurationAttributePart.this.updateAttribute(DurationAttributePart.this.fUpdateToken.get(), resolved, attribute, value, DurationAttributePart.this.fTextField, DurationAttributePart.this.getCachedDurationFormat(), false);
                DurationAttributePart.updateFocusStatus(DurationAttributePart.this.fTextField, false);
            }
        });
        this.doUpdateReadOnly(this.isReadOnly());
    }

    protected void doUpdateReadOnly(boolean readOnly) {
        Control control;
        if (this.fTextField != null && !(control = this.fTextField.getLayoutControl()).isDisposed()) {
            control.setEnabled(!readOnly);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.getWorkingCopy());
    }

    private DurationFormat getCachedDurationFormat() {
        return this.fDurationFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DurationFormat getDurationFormat(IProgressMonitor monitor) {
        if (this.fDurationFormat == null) {
            Object object = this.fFormatLock;
            synchronized (object) {
                if (this.fDurationFormat == null) {
                    DurationFormat format = new DurationFormat(2);
                    WorkItemWorkingCopy copy = this.getWorkingCopy();
                    if (copy != null) {
                        try {
                            ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
                            IProjectAreaHandle projectArea = copy.getWorkItem().getProjectArea();
                            IProcessAreaInfo info = manager.getProcessAreaInfo((IProcessAreaHandle)projectArea, false, monitor);
                            boolean forceUpperBound = false;
                            if (info != null) {
                                int days = info.getWorkWeekDays();
                                if (days > 0) {
                                    format.setDaysPerWeek(days);
                                } else {
                                    forceUpperBound = true;
                                }
                                long millis = info.getWorkDayMillis();
                                if (millis > 0L) {
                                    format.setMillisPerDay(millis);
                                } else {
                                    forceUpperBound = true;
                                }
                            }
                            if (forceUpperBound) {
                                format.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
                            } else {
                                IterationPlanClient planClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)copy.getTeamRepository());
                                EstimateOutputFormat outputFormat = planClient.fetchEstimateOutputFormatCached((IProcessAreaHandle)projectArea, monitor);
                                if (EstimateOutputFormat.Hours.equals((Object)outputFormat)) {
                                    format.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
                                }
                            }
                        }
                        catch (TeamRepositoryException exception) {
                            PlanningUIPlugin.log(exception);
                        }
                    }
                    this.fDurationFormat = format;
                }
            }
        }
        return this.fDurationFormat;
    }

    private WorkItemUIWorkingCopy getUIWorkingCopy() {
        return (WorkItemUIWorkingCopy)this.getWorkingCopy().getAdapter(IWorkItemUIWorkingCopy.class);
    }

    private boolean isProcessAreaInfoCached() {
        WorkItemWorkingCopy copy = this.getWorkingCopy();
        ResourcePlanningManager manager = PlanningClientPlugin.getResourcePlanningManager((ITeamRepository)copy.getTeamRepository());
        return manager.findCachedProcessAreaInfo((IProcessAreaHandle)copy.getWorkItem().getProjectArea()) != null;
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fEstimateUpdater);
        }
    }

    public void setInput(Object input) {
        this.fUpdateToken.getAndIncrement();
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)input).isResolved()) {
            WorkItemEditorInput extended = (WorkItemEditorInput)input;
            this.fWorkingCopy = extended.getWorkingCopy();
            this.fRule = new ExclusiveSchedulingRule(this.getAttribute());
            this.addListeners();
            Text text = this.fTextField.getText();
            DurationFormat cached = this.getCachedDurationFormat();
            boolean refreshInfo = !this.isProcessAreaInfoCached();
            ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
            if (cached == null && DurationAttributePart.getDuration(resolved, this.getAttribute()).longValue() >= 0L && refreshInfo) {
                text.setEnabled(false);
                text.setText(Messages.DurationAttributePart_PENDING_LABEL);
            }
            this.updateEstimateField();
        } else {
            this.fRule = null;
            this.fWorkingCopy = null;
        }
    }

    private void updateAttribute(final int token, ResolvedWorkItem item, IAttribute attribute, String value, final DecoratedText field, DurationFormat format, final boolean dirtyOnly) {
        block12: {
            Duration duration = Duration.INVALID;
            try {
                try {
                    duration = DurationAttributePart.parseDuration(value, attribute.getDisplayName(), format);
                    long number = duration.longValue();
                    if (number >= 0L && number % 1000L != 0L) {
                        throw new ParseException(MessageFormat.format(Messages.DurationAttributePart_NO_MILLI_SECONDS, attribute.getDisplayName()), 0);
                    }
                    Duration finalDuration = duration;
                    DurationFormat finalFormat = format;
                    DurationAttributePart.syncExec(field, new Runnable((Format)finalFormat, finalDuration, value, field){
                        private final /* synthetic */ Format val$finalFormat;
                        private final /* synthetic */ Duration val$finalDuration;
                        private final /* synthetic */ String val$value;
                        private final /* synthetic */ DecoratedText val$field;
                        {
                            this.val$finalFormat = format;
                            this.val$finalDuration = duration;
                            this.val$value = string;
                            this.val$field = decoratedText;
                        }

                        @Override
                        public void run() {
                            if (token == DurationAttributePart.this.fUpdateToken.get()) {
                                String formatted;
                                if (!dirtyOnly && !this.val$value.equals(formatted = this.val$finalFormat.format(this.val$finalDuration))) {
                                    this.val$field.setValue(formatted);
                                }
                                this.val$field.setStatus(DurationAttributePart.getIdleStatus(this.val$field));
                            }
                        }
                    });
                }
                catch (ParseException exception) {
                    WorkItemWorkingCopy copy;
                    Duration predecessor;
                    DurationAttributePart.syncExec(field, new Runnable(){

                        @Override
                        public void run() {
                            if (token == DurationAttributePart.this.fUpdateToken.get()) {
                                field.setStatus((IStatus)new Status(4, PlanningUIPlugin.getPluginId(), exception.getLocalizedMessage()));
                            }
                        }
                    });
                    if (token != this.fUpdateToken.get() || duration.equals((Object)(predecessor = DurationAttributePart.getDuration(item, attribute))) || (copy = this.getWorkingCopy()) == null) break block12;
                    if (dirtyOnly) {
                        if (!Duration.INVALID.equals((Object)predecessor)) {
                            ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                        }
                        break block12;
                    }
                    item.getWorkItem().setValue(this.getAttribute(), (Object)duration.longValue());
                }
            }
            finally {
                WorkItemWorkingCopy copy;
                Duration predecessor;
                if (token == this.fUpdateToken.get() && !duration.equals((Object)(predecessor = DurationAttributePart.getDuration(item, attribute))) && (copy = this.getWorkingCopy()) != null) {
                    if (dirtyOnly) {
                        if (!Duration.INVALID.equals((Object)predecessor)) {
                            ((WorkItemWorkingCopyImpl)copy).setDirty(true);
                        }
                    } else {
                        item.getWorkItem().setValue(this.getAttribute(), (Object)duration.longValue());
                    }
                }
            }
        }
    }

    private void updateEstimateField() {
        final ResolvedWorkItem resolved = this.getUIWorkingCopy().getResolvedWorkItem();
        final IAttribute estimateAttribute = this.getAttribute();
        final String estimateValue = this.fTextField.getText().getText().trim();
        AttributePartUpdateJob job = new AttributePartUpdateJob(this, Messages.DurationAttributePart_UPDATE_ATTRIBUTE){

            @Override
            protected IStatus doRunProtected(IProgressMonitor monitor) {
                DurationFormat format = this.getCachedDurationFormat();
                if (format == null) {
                    format = this.getDurationFormat(monitor);
                }
                this.updateTextField(this, resolved, estimateAttribute, estimateValue, fTextField, format);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setRule(this.fRule);
        job.setSystem(true);
        job.schedule();
    }

    private void updateTextField(AttributePartUpdateJob job, ResolvedWorkItem item, IAttribute attribute, String value, final DecoratedText field, DurationFormat format) {
        block3: {
            Duration duration = DurationAttributePart.getDuration(item, attribute);
            try {
                if (!duration.equals((Object)DurationAttributePart.parseDuration(value, attribute.getDisplayName(), format))) {
                    final String formatted = format.format(duration);
                    job.runWithToken(field, new Runnable(){

                        @Override
                        public void run() {
                            Text text = field.getText();
                            text.setText(formatted);
                        }
                    });
                }
            }
            catch (ParseException exception) {
                if (!duration.isValid()) break block3;
                final String formatted = format.format(duration);
                job.runWithToken(field, new Runnable(){

                    @Override
                    public void run() {
                        Text text = field.getText();
                        text.setText(formatted);
                    }
                });
            }
        }
    }

    private abstract class AttributePartUpdateJob
    extends FoundationJob {
        private final int fToken;

        AttributePartUpdateJob(String name) {
            super(name);
            this.fToken = DurationAttributePart.this.fUpdateToken.get();
        }

        protected final int getToken() {
            return this.fToken;
        }

        protected final IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (this.fToken == DurationAttributePart.this.fUpdateToken.get()) {
                return this.doRunProtected(monitor);
            }
            return Status.OK_STATUS;
        }

        protected abstract IStatus doRunProtected(IProgressMonitor var1) throws Exception;

        protected final void runWithToken(DecoratedText field, final Runnable runnable) {
            Assert.isNotNull((Object)runnable);
            DurationAttributePart.syncExec(field, new Runnable(){

                @Override
                public void run() {
                    if (AttributePartUpdateJob.this.fToken == DurationAttributePart.this.fUpdateToken.get()) {
                        runnable.run();
                    }
                }
            });
        }
    }

    private static final class ExclusiveSchedulingRule
    implements ISchedulingRule {
        private final IAttribute fAttribute;

        ExclusiveSchedulingRule(IAttribute attribute) {
            this.fAttribute = attribute;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            if (rule instanceof ExclusiveSchedulingRule) {
                ExclusiveSchedulingRule extended = (ExclusiveSchedulingRule)rule;
                return extended.fAttribute.sameItemId((IItemHandle)this.fAttribute);
            }
            return false;
        }
    }
}

