/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.resource.parts;

import com.ibm.team.apt.internal.common.util.XMLStrings;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceFormPage;
import com.ibm.team.apt.internal.ide.ui.resource.AbstractContributorResourceInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormPart;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractContributorResourceFormPart
extends TeamFormPart {
    private AbstractContributorResourceInput fEditorInput;
    private final AbstractContributorResourceFormPage fFormPage;

    protected static final String urlEncode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
    }

    protected AbstractContributorResourceFormPart(AbstractContributorResourceFormPage page) {
        Assert.isNotNull((Object)((Object)page));
        this.fFormPage = page;
    }

    protected final void appendMailLinks(StringBuilder builder, boolean isFocus) {
        Assert.isNotNull((Object)builder);
        AbstractContributorResourceInput input = this.getInput();
        if (input != null) {
            IContributor contributor = input.getContributor();
            ITeamRepository repository = input.getTeamRepository();
            if (isFocus) {
                URI uri = Location.itemLocation((IItemHandle)contributor, (String)repository.getRepositoryURI()).toAbsoluteUri();
                builder.append("<br/>");
                if (uri != null) {
                    builder.append("<br/><a href=\"");
                    builder.append(uri.toString());
                    builder.append("\">");
                    builder.append(XMLStrings.escape((String)contributor.getName()));
                    builder.append("</a>");
                }
                builder.append("<br/><a href=\"mailto:");
                try {
                    StringBuilder hname = new StringBuilder(64);
                    hname.append('\"');
                    hname.append(XMLStrings.escape((String)contributor.getName()));
                    hname.append("\" <");
                    hname.append(XMLStrings.escape((String)contributor.getEmailAddress()));
                    hname.append('>');
                    builder.append(AbstractContributorResourceFormPart.urlEncode(hname.toString()));
                }
                catch (UnsupportedEncodingException exception) {
                    Assert.isTrue((boolean)false);
                }
                builder.append("\">");
                builder.append(XMLStrings.escape((String)contributor.getEmailAddress()));
                builder.append("</a>");
            } else {
                builder.append("<br/><br/>");
                builder.append(XMLStrings.escape((String)contributor.getName()));
                builder.append("<br/>");
                builder.append(XMLStrings.escape((String)contributor.getEmailAddress()));
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.fEditorInput = null;
    }

    public AbstractContributorResourceFormPage getFormPage() {
        return this.fFormPage;
    }

    public synchronized AbstractContributorResourceInput getInput() {
        return this.fEditorInput;
    }

    protected final Shell getShell() {
        IWorkbenchWindow window;
        IWorkbenchPage page;
        ITeamFormPartSite site = this.getSite();
        if (site != null && (page = site.getWorkbenchPage()) != null && (window = page.getWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return null;
    }

    public final FormToolkit getToolkit() {
        ITeamFormPartSite site = this.getSite();
        if (site != null) {
            return site.getToolkit();
        }
        return null;
    }

    public synchronized boolean save(IProgressMonitor monitor) {
        return false;
    }

    public synchronized void setInput(Object input) {
        if (input instanceof AbstractContributorResourceInput) {
            this.fEditorInput = (AbstractContributorResourceInput)((Object)input);
            this.getFormPage().setDirty(false);
        } else if (this.fEditorInput != null) {
            this.fEditorInput = null;
        }
    }
}

