/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.progress;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.ide.ui.util.GCState;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ProgressBarDrawingStrategy {
    private static final boolean IS_CARBON = SWT.getPlatform().equals("carbon");
    private BarResources fResources;
    private IProgressInformation fInput;
    private IProgressLabelProvider fLabelProvider;

    public ProgressBarDrawingStrategy(BarResources resources) {
        this.fResources = resources;
    }

    public void setInput(IProgressInformation input) {
        this.fInput = input;
    }

    public void setLabelProvider(IProgressLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public int computeMinimalHeight() {
        FontMetrics metrics = this.fResources.getMessageFontMetrics();
        return this.computeTrimHeight(metrics.getHeight() - metrics.getLeading());
    }

    public int computeTrimHeight(int height) {
        return height <= 12 ? height + 2 * (IS_CARBON ? 3 : 4) : (int)(1.8f * (float)height);
    }

    public int computeTopSpacing(int height) {
        return (height <= 20 ? 4 : height / 5) - 2;
    }

    public void paint(GC gc, Rectangle bounds) {
        if (this.fLabelProvider == null) {
            return;
        }
        GCState state = GCState.save(gc, 65930);
        try {
            gc.setFont(this.fResources.getInlineMessageFont());
            int indent = bounds.height <= 20 ? 4 : bounds.height / 5;
            Rectangle innerBar = Rectangles.create(bounds);
            int delta = Math.max(0, indent - 2);
            Rectangles.move(innerBar, 0, delta);
            Rectangles.resize(innerBar, -indent - 2, -1 - 2 * delta);
            gc.setBackground(this.fResources.getWhite());
            gc.setForeground(this.fResources.getOutline());
            gc.fillRectangle(innerBar);
            gc.drawRectangle(innerBar);
            Rectangle textBox = Rectangles.create(innerBar);
            Rectangles.resize(textBox, -2, -2);
            Rectangles.move(textBox, 1, 1);
            Rectangles.resize(innerBar, -3, -3);
            Rectangles.move(innerBar, 2, 2);
            String message = this.fLabelProvider.getMessage(this.fInput);
            if (message != null) {
                Point point = gc.stringExtent(message);
                Point align = BarPainters.align(textBox, point.x, point.y, BarPainters.Alignment.Center, new BarPainters.Alignment[0]);
                gc.setForeground(this.fResources.getOutline());
                BarPainters.drawString(gc, textBox, message, align);
            } else {
                double fillLevel = this.fLabelProvider.getFillLevel(this.fInput);
                double[] doneRange = this.fLabelProvider.getDoneRange(this.fInput);
                double[] projectionRange = this.fLabelProvider.getProjectionRange(this.fInput);
                boolean isBehind = this.fLabelProvider.getDeltaDirection(this.fInput) < 0.0;
                boolean isDone = doneRange[1] == 1.0;
                boolean canProject = !isDone && projectionRange[0] != -1.0 && projectionRange[1] != -1.0;
                int lenDone = (int)((double)innerBar.width * doneRange[1]);
                int totalWidth = (int)((double)lenDone + (canProject ? (double)innerBar.width * projectionRange[1] : 0.0));
                gc.setForeground(this.fResources.getGradientStart());
                gc.setBackground(this.fResources.getGradientEnd());
                gc.fillGradientRectangle(innerBar.x, innerBar.y, totalWidth, innerBar.height, true);
                int totalHeight = (int)((double)innerBar.height * fillLevel);
                Rectangle estimateBar = new Rectangle(innerBar.x, innerBar.y + (innerBar.height - totalHeight), innerBar.width, totalHeight);
                GCState innerState = GCState.save(gc, 2);
                gc.setAlpha(85);
                gc.setBackground(this.fResources.getGreen());
                gc.fillRectangle(estimateBar.x, estimateBar.y, lenDone, estimateBar.height);
                if (canProject) {
                    gc.setBackground(isBehind ? this.fResources.getRed() : this.fResources.getBrightGreen());
                    gc.fillRectangle(estimateBar.x + lenDone, estimateBar.y, totalWidth - lenDone, estimateBar.height);
                }
                innerState.restore();
                if (doneRange[1] != (double)((int)doneRange[1]) && canProject) {
                    gc.setForeground(this.fResources.getWhite());
                    gc.drawLine(estimateBar.x + lenDone, innerBar.y, estimateBar.x + lenDone, innerBar.y + innerBar.height);
                }
                if (!isDone) {
                    gc.setBackground(this.fResources.getTwistie());
                    BarPainters.paintTwistie(gc, BarPainters.Direction.Left, estimateBar.x + estimateBar.width + 3, estimateBar.y, indent);
                }
            }
        }
        finally {
            state.restore();
        }
    }
}

