/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.common.util.SizeUnit;
import com.ibm.team.apt.internal.common.util.XMLStrings;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.ide.ui.editor.WikiPageAttachmentStore;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WikiPageAttachmentDomainAdapter
extends DomainAdapter {
    protected Object convertToDomainObject(Object object) {
        if (object instanceof IWikiPageAttachment) {
            return object;
        }
        if (object instanceof ResolvedWikiPageAttachment) {
            return ((ResolvedWikiPageAttachment)object).getAttachment();
        }
        return null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.WikiPageAttachmentDomainAdapter_JOB_INFO;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        IWikiPageAttachment attachment = (IWikiPageAttachment)this.convertToDomainObject(input);
        if (attachment == null) {
            return;
        }
        Html.append((CharSequence)body, (CharSequence)Messages.WikiPageAttachmentDomainAdapter_CONTENT_NAME);
        Html.append((CharSequence)body, (CharSequence)XMLStrings.escape((String)attachment.getName()));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        try {
            IContributor creator = (IContributor)this.resolve((IItemHandle)attachment.getCreator(), IContributor.NAME_PROPERTY, new String[0]);
            Html.append((CharSequence)body, (CharSequence)Messages.WikiPageAttachmentDomainAdapter_CONTENT_CREATED_BY);
            if (input instanceof ResolvedWikiPageAttachment && ((ResolvedWikiPageAttachment)input).isPredefined()) {
                Html.append((CharSequence)body, (CharSequence)Messages.WikiPageAttachmentDomainAdapter_PREDEFINED_CREATOR);
            } else {
                Html.append((CharSequence)body, (CharSequence)XMLStrings.escape((String)creator.getName()));
            }
            Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        }
        catch (TeamRepositoryException creator) {
            // empty catch block
        }
        Html.append((CharSequence)body, (CharSequence)Messages.WikiPageAttachmentDomainAdapter_CONTENT_TYPE);
        Html.append((CharSequence)body, (CharSequence)XMLStrings.escape((String)attachment.getContent().getContentType()));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        long rawLength = attachment.getContent().getRawLength();
        SizeUnit unit = SizeUnit.find((long)rawLength);
        long value = SizeUnit.convert((long)rawLength, (SizeUnit)SizeUnit.BYTE, (SizeUnit)unit);
        Html.append((CharSequence)body, (CharSequence)Messages.WikiPageAttachmentDomainAdapter_CONTENT_SIZE);
        Html.append((CharSequence)body, (CharSequence)MessageFormat.format(Messages.WikiPageAttachmentDomainAdapter_CONTENT_SIZE_VALUE_UNIT, value, unit));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        String type = attachment.getContent().getContentType();
        if (Attachments.IMAGE_CONTENT_TYPES.contains(type) && WikiPageAttachmentStore.isDownloaded(attachment)) {
            URI fileUri = WikiPageAttachmentStore.getFileUri(attachment);
            Html.IMG.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("src", fileUri.toString())});
        }
    }

    private <T extends IItem> T resolve(IItemHandle handle, String first, String ... rest) throws TeamRepositoryException {
        IItemManager manager = PlanningClientPlugin.getTeamRepository((IItemHandle)handle).itemManager();
        ArrayList<String> list = new ArrayList<String>(1 + rest.length);
        list.add(first);
        list.addAll(Arrays.asList(rest));
        return (T)manager.fetchPartialItem(handle, 0, list, (IProgressMonitor)new NullProgressMonitor());
    }
}

