/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.progress.ProgressBarMarkupStrategy;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressPresentationMarkupPart
extends PresentationMarkupPart {
    public void fillPartName(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        builder.plain(Messages.ProgressPresentationMarkupPart_PROGRESS);
    }

    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IterationPlanClient client = (IterationPlanClient)this.getTeamRepository().getClientLibrary(IIterationPlanClient.class);
        IProgressInformation progressInformation = client.fetchWorkItemProgress((IWorkItemHandle)this.getItem(), monitor);
        IComplexityAttribute complexityAttribute = client.findComplexityAttribute((IProcessAreaHandle)this.getItem().getProjectArea(), monitor);
        IProgressLabelProvider labelProvider = ProgressIDE.newLabelProvider(((IScriptableProxy)progressInformation).getScriptEnvironment(), complexityAttribute);
        ProgressBarMarkupStrategy strategy = new ProgressBarMarkupStrategy(labelProvider, progressInformation);
        strategy.generateHead(this.getHeadDefinitions());
        StringBuilder progressHTML = new StringBuilder();
        strategy.generateBody((CharSequence)progressHTML);
        builder.xml(progressHTML.toString());
        builder.plain(labelProvider.getProgressText(progressInformation));
        builder.plain(" ");
        builder.plain(labelProvider.getQualityText(progressInformation));
    }
}

