/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.internal.client.ResolvedIterationPlan;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptEnvironment;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProgressInformationDomainAdapter
extends DomainAdapter {
    private static final String GENERAL_CSS = "__general__css";

    protected Object convertToDomainObject(Object object) {
        if (object instanceof IProgressInformation) {
            return object;
        }
        return null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return "";
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuilder css = new StringBuilder();
        Html.STYLE.open((CharSequence)css, new Html.Attribute[]{new Html.Attribute("type", "text/css")});
        css.append("body { overflow: auto; }\n");
        css.append("table{ ").append(MarkupUtil.getFont()).append(" }");
        css.append("a:link { color: #0000FF; text-decoration: none; }");
        css.append("a:hover { color: #000080; text-decoration: underline; }");
        css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        css.append("span.action { cursor: pointer; }");
        css.append("span.header { font-weight: bold; padding-bottom: 0.3em; }");
        css.append("span.warning { padding-left: 16px; background-image: url(" + JazzResources.createURL((ImageDescriptor)ImagePool.WARNING_OBJ).toString() + "); background-position: center left; background-repeat: no-repeat; }");
        Html.STYLE.close((CharSequence)css);
        map.put(GENERAL_CSS, css.toString());
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (!(input instanceof IProgressInformation)) {
            return;
        }
        IScriptEnvironment environment = ((IScriptableProxy)input).getScriptEnvironment();
        if (environment == null) {
            return;
        }
        IComplexityAttribute attribute = null;
        ResolvedIterationPlan plan = (ResolvedIterationPlan)environment.adapt(ResolvedIterationPlan.class);
        if (plan != null) {
            attribute = plan.getComplexityAttribute();
        }
        IProgressLabelProvider labelProvider = ProgressIDE.newLabelProvider(environment, attribute);
        this.generateContentWithLabelProvider(head, body, input, labelProvider);
    }

    public void generateContentWithLabelProvider(HashMap head, StringBuffer body, Object input, IProgressLabelProvider labelProvider) {
        IScriptEnvironment environment = ((IScriptableProxy)input).getScriptEnvironment();
        if (environment == null) {
            return;
        }
        ResolvedIterationPlan plan = (ResolvedIterationPlan)environment.adapt(ResolvedIterationPlan.class);
        String projectAreaUri = "";
        if (plan != null) {
            Location location = Location.itemLocation((IItemHandle)plan.getProjectArea(), (String)plan.getTeamRepository().getRepositoryURI());
            projectAreaUri = location.toAbsoluteUri().toString();
        }
        this.generateHead(head);
        String tooltipText = labelProvider.getTooltipText((IProgressInformation)input);
        tooltipText = tooltipText.replace("<!--INSERT(PROJECT_AREA_LINK)-->", NLS.bind((String)"<a href=\"{0}\">", (Object)projectAreaUri, (Object[])new Object[0]));
        tooltipText = tooltipText.replace("<!--INSERT_END-->", "</a>");
        body.append(tooltipText);
    }
}

