/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.progress.ProgressBarMarkupStrategy;
import com.ibm.team.apt.internal.common.util.IterationPlanUtil;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.apt.internal.ide.ui.util.BlockingItemResolver;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class PlanDomainAdapter
extends DomainAdapter {
    protected Object convertToDomainObject(Object object) {
        if (object instanceof IIterationPlanRecordHandle) {
            return object;
        }
        return null;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info, IProgressMonitor monitor) {
        if (!(input instanceof IIterationPlanRecordHandle)) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        try {
            try {
                IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)((IItemHandle)input)).itemManager();
                IIterationPlanRecord record = (IIterationPlanRecord)itemManager.fetchCompleteItem((IItemHandle)input, 0, (IProgressMonitor)progress.newChild(1));
                IIteration iteration = (IIteration)itemManager.fetchCompleteItem((IItemHandle)record.getIteration(), 0, (IProgressMonitor)progress.newChild(1));
                IProcessArea owner = (IProcessArea)itemManager.fetchCompleteItem((IItemHandle)record.getOwner(), 0, (IProgressMonitor)progress.newChild(1));
                IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)record);
                IProgressInformation progressInformation = client.fetchPlanProgress((IIterationPlanRecordHandle)record, (IProgressMonitor)progress.newChild(1));
                IComplexityAttribute attribute = client.findComplexityAttribute(record.getOwner(), (IProgressMonitor)progress.newChild(1));
                IProgressLabelProvider labelProvider = ProgressIDE.newLabelProvider(((IScriptableProxy)progressInformation).getScriptEnvironment(), attribute);
                ProgressBarMarkupStrategy strategy = new ProgressBarMarkupStrategy(labelProvider, progressInformation);
                IterationPlanUtil.buildPlanHover((Map)head, (StringBuffer)body, (IIterationPlanRecord)record, (IProcessArea)owner, (IIteration)iteration, (ProgressBarMarkupStrategy)strategy, (IProgressLabelProvider)labelProvider, (IProgressInformation)progressInformation, (Locale)Locale.getDefault(), (String)MarkupUtil.getFont(), (boolean)info.isFocusTooltip);
            }
            catch (TeamRepositoryException e) {
                PlanningClientPlugin.log((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public String generateContentAsText(Object input) {
        return this.generateTitle(input);
    }

    public String generateTitle(Object input) {
        if (input instanceof IIterationPlanRecordHandle) {
            try {
                IIterationPlanRecord iterationPlan = (IIterationPlanRecord)new BlockingItemResolver().resolvePartial((IItemHandle)input, Arrays.asList(IIterationPlanRecord.NAME_PROPERTY));
                if (iterationPlan != null) {
                    return iterationPlan.getName();
                }
            }
            catch (InvocationTargetException e) {
                PlanningUIPlugin.log(e);
                return Messages.PlanDomainAdapter_FAILED_GENERATE_TITLE;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        IIterationPlanRecord iterationPlan;
        if (info.isHoverTooltip) {
            return null;
        }
        if (input instanceof IIterationPlanRecord && (iterationPlan = (IIterationPlanRecord)input).isPropertySet(IIterationPlanRecord.NAME_PROPERTY)) {
            return NLS.bind((String)Messages.PlanDomainAdapter_JOB_INFO_DETAIL, (Object)iterationPlan.getName(), (Object[])new Object[0]);
        }
        return Messages.PlanDomainAdapter_JOB_INFO;
    }
}

