/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.api.ui.essentials.IMarker;
import com.ibm.team.apt.internal.common.IMessage;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.common.util.XMLStrings;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.LocationMarker;
import com.ibm.team.apt.internal.ide.ui.common.MessageMarker;
import com.ibm.team.apt.internal.ide.ui.editor.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class MarkerDomainAdapter
extends DomainAdapter {
    private static final String GENERAL_CSS = "GENERAL_IMARKER_CSS";

    protected Object convertToDomainObject(Object object) {
        if (object instanceof IMarker) {
            return object;
        }
        return null;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (!(input instanceof IMarker)) {
            return;
        }
        if (!head.containsKey(GENERAL_CSS)) {
            StringBuilder css = new StringBuilder();
            String font = MarkupUtil.getFont();
            css.append("<style type=\"text/css\">table{ ").append(font).append(" }</style>");
            head.put(GENERAL_CSS, css.toString());
        }
        if (input instanceof MessageMarker) {
            List<IMessage> messages = ((MessageMarker)input).getMessages();
            Html.TABLE.open((CharSequence)body, new Html.Attribute[0]);
            if (messages.size() > 1) {
                Html.THEAD.open((CharSequence)body, new Html.Attribute[0]);
                body.append(Messages.OutlinePage_MARKER_HOVER_MULTIPLE_MARKERS);
                Html.THEAD.close((CharSequence)body);
            }
            for (IMessage message : messages) {
                Html.TR.open((CharSequence)body, new Html.Attribute[0]);
                ImageDescriptor image = this.getImage(message);
                Html.TD.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("valign", "middle")});
                if (image != null) {
                    Html.IMG.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("src", JazzResources.createURL((ImageDescriptor)image).toString()), new Html.Attribute("border", "0")});
                }
                Html.TD.close((CharSequence)body);
                Html.TD.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("valign", "middle")});
                body.append(message.getMessage());
                Html.TD.close((CharSequence)body);
                Html.TR.close((CharSequence)body);
            }
            Html.TABLE.close((CharSequence)body);
        } else if (input instanceof LocationMarker) {
            String message = null;
            try {
                message = ((LocationMarker)input).getLocationMessage((IProgressMonitor)new NullProgressMonitor());
                message = message.replace("\n", "<br />");
            }
            catch (TeamRepositoryException e) {
                message = Messages.MarkerDomainAdapter_FAILED_TO_DISPLAY_MARKER;
                PlanningUIPlugin.log(e);
            }
            Html.DIV.open((CharSequence)body, new Html.Attribute[0]);
            body.append(XMLStrings.escape((String)message));
            Html.DIV.close((CharSequence)body);
        }
    }

    public String generateContentAsText(Object input) {
        return this.generateTitle(input);
    }

    public String generateTitle(Object input) {
        if (input instanceof MessageMarker) {
            return Messages.MarkerDomainAdapter_PROBLEMS_TITLE;
        }
        return null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        if (info.isHoverTooltip) {
            return null;
        }
        return Messages.MarkerDomainAdapter_JOB_NAME;
    }

    private ImageDescriptor getImage(IMessage message) {
        switch (message.getSeverity()) {
            case ERROR: 
            case FATAL_ERROR: {
                return ImagePool.ERROR_OBJ;
            }
            case WARNING: {
                return ImagePool.WARNING_OBJ;
            }
            case INFO: {
                return null;
            }
        }
        return null;
    }
}

