/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.common.resource.IContributorAbsence;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.common.util.XMLStrings;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.util.NLS;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;

public class LoadItemDomainAdapter
extends DomainAdapter {
    private static final String GENERAL_CSS = "GENERAL_CSS";

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        if (!(input instanceof LoadItem)) {
            return null;
        }
        return Messages.LoadItemDomainAdapter_JOB_INFO;
    }

    protected Object convertToDomainObject(Object object) {
        if (object instanceof LoadItem) {
            return object;
        }
        return null;
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        String font = MarkupUtil.getFont();
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; }\n");
        css.append("table{ ").append(font).append(" }");
        css.append("a:link { color: #0000FF; text-decoration: none; }");
        css.append("a:hover { color: #000080; text-decoration: underline; }");
        css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        String text;
        if (!(input instanceof LoadItem)) {
            return;
        }
        this.generateHead(head);
        LoadItem item = (LoadItem)input;
        body.append(this.generateTitle(item, true));
        if (item.usesDefaultWorkAssignment() && item.usesDefaultWorkLocation()) {
            text = NLS.bind((String)Messages.LoadItemDomainAdapter_MSG_DEFAULT_INFO, (Object)this.userEditorLink(item.getContributor()), (Object[])new Object[0]);
            body.append(this.warning(text));
        } else if (item.usesDefaultWorkAssignment()) {
            text = NLS.bind((String)Messages.LoadItemDomainAdapter_MSG_DEFAULT_ASSIGNMENT, (Object)this.userEditorLink(item.getContributor()), (Object[])new Object[0]);
            body.append(this.warning(text));
        } else if (item.usesDefaultWorkLocation()) {
            text = NLS.bind((String)Messages.LoadItemDomainAdapter_MSG_DEFAULT_WORK_DAYS, (Object)item.getContributor(), (Object[])new Object[0]);
            body.append(this.warning(text));
        }
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_HOURS_AVAILABLE, (Object)LoadItems.getTextWorkTimeLeft((LoadItem)item), (Object[])new Object[0]));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_HOURS_ESTIMATED, (Object)LoadItems.getTextSumOfEstimates((LoadItem)item), (Object[])new Object[0]));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        if (LoadItems.isOverbooked((AbstractLoadItem)item)) {
            body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_HOURS_OVERBOOKED, (Object)LoadItems.getHoursOverbooked((AbstractLoadItem)item), (Object[])new Object[0]));
            Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        }
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_RATIO_ESTIMATED, (Object)item.getEstimatedItems().size(), (Object[])new Object[]{item.getOpenItems().size(), LoadItems.getQualityOfPlanning((AbstractLoadItem)item)}));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_QUALITY_OF_PLANNING, (Object)(String.valueOf(Html.ITALIC.open) + LoadItems.getTextQualityOfPlanning((LoadItem)item) + Html.ITALIC.close), (Object[])new Object[0]));
        Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        if (!item.getAbsences().isEmpty()) {
            Html.BR.open((CharSequence)body, new Html.Attribute[0]);
            body.append(Messages.LoadItemDomainAdapter_CONTENT_ABSENCES_HEADER);
            Html.OL.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("style", "margin-top: 0px;")});
            for (IContributorAbsence absence : item.getAbsences()) {
                Html.LI.open((CharSequence)body, new Html.Attribute[0]);
                body.append(MessageFormat.format(Messages.LoadItemDomainAdapter_CONTENT_ABSENCE_DETAIL, XMLStrings.escape((String)absence.getSummary()), absence.getStartDate(), absence.getEndDate()));
                Html.LI.close((CharSequence)body);
            }
            Html.OL.close((CharSequence)body);
        }
    }

    private CharSequence userEditorLink(IContributor contributor) {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)contributor);
        Location location = Location.itemLocation((IItemHandle)contributor, (String)repository.getRepositoryURI());
        StringBuilder body = new StringBuilder();
        Html.ANCHOR.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("href", location.toAbsoluteUri().toASCIIString())});
        body.append(XMLStrings.escape((String)contributor.getName()));
        Html.ANCHOR.close((CharSequence)body);
        return body;
    }

    private CharSequence warning(String warning) {
        StringBuffer body = new StringBuffer();
        Html.TABLE.open((CharSequence)body, new Html.Attribute[0]);
        Html.TR.open((CharSequence)body, new Html.Attribute[0]);
        Html.TD.open((CharSequence)body, new Html.Attribute[0]);
        Html.IMG.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("src", JazzResources.createURL((ImageDescriptor)ImagePool.WARNING_OBJ).toString())});
        Html.TD.close((CharSequence)body);
        Html.TD.open((CharSequence)body, new Html.Attribute[0]);
        body.append(warning);
        Html.TD.close((CharSequence)body);
        Html.TR.close((CharSequence)body);
        Html.TABLE.close((CharSequence)body);
        return body;
    }

    public String generateTitle(Object input, boolean markup) {
        if (!(input instanceof LoadItem)) {
            return null;
        }
        LoadItem item = (LoadItem)input;
        StringBuilder body = new StringBuilder();
        if (markup) {
            Html.BOLD.open((CharSequence)body, new Html.Attribute[]{new Html.Attribute("style", "margin-bottom: 0px;")});
        }
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_TITLE, (Object)XMLStrings.escape((String)item.getContributor().getName()), (Object[])new Object[0]));
        if (markup) {
            Html.BOLD.close((CharSequence)body);
        }
        body.append(' ');
        body.append(NLS.bind((String)Messages.LoadItemDomainAdapter_CONTENT_ASSIGNMENT, (Object)item.getAssignmentRange(), (Object[])new Object[0]));
        if (markup) {
            Html.BR.open((CharSequence)body, new Html.Attribute[0]);
        }
        return body.toString();
    }

    public String generateTitle(Object input) {
        return this.generateTitle(input, false);
    }
}

