/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.preview;

import com.ibm.team.apt.api.common.planning.IProgressInformation;
import com.ibm.team.apt.api.common.planning.IProgressLabelProvider;
import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IIterationPlanClient;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.common.duration.IComplexityAttribute;
import com.ibm.team.apt.internal.common.progress.ProgressBarMarkupStrategy;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.common.util.XMLStrings;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.CurrentPlansFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningContentProvider;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.RecentlyViewedPlansFolder;
import com.ibm.team.apt.internal.ide.ui.preview.Messages;
import com.ibm.team.apt.internal.ide.ui.progress.ProgressIDE;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.common.scriptengine.IScriptableProxy;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.progress.IElementCollector;

public class IterationFolderDomainAdapter
extends DomainAdapter {
    private static final List<Class<? extends PlanningDomainFolder>> fgTypes = Arrays.asList(AbstractIterationFolder.class, RecentlyViewedPlansFolder.class, CurrentPlansFolder.class);

    protected Object convertToDomainObject(Object object) {
        for (Class<? extends PlanningDomainFolder> type : fgTypes) {
            if (!type.isInstance(object)) continue;
            return type.cast(object);
        }
        return null;
    }

    public void generateContentAsHTML(HashMap head, StringBuffer buffer, Object input, IDomainAdapter.Info info, IProgressMonitor monitor) {
        PlanningDomainFolder folder = (PlanningDomainFolder)this.convertToDomainObject(input);
        if (folder == null) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        final ArrayList plans = new ArrayList();
        IElementCollector planCollector = new IElementCollector(){

            public void add(Object[] elements, IProgressMonitor monitor) {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    this.add(element, monitor);
                    ++n2;
                }
            }

            public void add(Object element, IProgressMonitor monitor) {
                if (element instanceof IIterationPlanRecord) {
                    plans.add((IIterationPlanRecord)element);
                }
            }

            public void done() {
            }
        };
        PlanningContentProvider contentProvider = (PlanningContentProvider)folder.getRoot().getDomainSubtreeRoot().getDomain().getContentProvider();
        contentProvider.fetchDeferredChildren(this.toTreePath(folder), planCollector, (IProgressMonitor)progress.newChild(1));
        if (plans.isEmpty()) {
            return;
        }
        if (input instanceof AbstractIterationFolder) {
            Html.BOLD.open((CharSequence)buffer, new Html.Attribute[0]);
            buffer.append(NLS.bind((String)Messages.IterationFolderDomainAdapter_ITERATION_FOLDER_TITLE, (Object)XMLStrings.escape((String)folder.getName()), (Object[])new Object[0]));
            Html.BOLD.close((CharSequence)buffer);
            Html.DIV.open((CharSequence)buffer, new Html.Attribute[0]);
            IIteration iteration = ((AbstractIterationFolder)input).getIteration();
            Date startDate = iteration.getStartDate();
            Date endDate = iteration.getEndDate();
            boolean datesSet = startDate != null && endDate != null;
            Html.SPAN.open((CharSequence)buffer, new Html.Attribute[0]);
            if (datesSet) {
                buffer.append(MessageFormat.format(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_DATES, startDate, endDate));
            } else if (startDate != null) {
                buffer.append(MessageFormat.format(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_NO_END_DATE, startDate));
            } else if (endDate != null) {
                buffer.append(MessageFormat.format(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_NO_START_END, endDate));
            } else {
                buffer.append(Messages.IterationFolderHTMLGenerator_DURATION_RANGE_NO_DATES);
            }
            Html.SPAN.close((CharSequence)buffer);
            Html.DIV.close((CharSequence)buffer);
        } else {
            Html.BOLD.open((CharSequence)buffer, new Html.Attribute[0]);
            buffer.append(XMLStrings.escape((String)folder.getName()));
            Html.BOLD.close((CharSequence)buffer);
        }
        Html.HR.open((CharSequence)buffer, new Html.Attribute[0]);
        Html.TABLE.open((CharSequence)buffer, new Html.Attribute[]{new Html.Attribute("border", "0"), new Html.Attribute("width", "100%")});
        try {
            IProjectAreaHandle projectArea = contentProvider.getProjectAreaHandle(folder);
            ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea);
            IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)repository);
            List progressInformations = client.fetchPlanProgress(plans, (IProgressMonitor)progress.newChild(1));
            progress.setWorkRemaining(plans.size());
            int index = 0;
            while (index < plans.size()) {
                Html.TR.open((CharSequence)buffer, new Html.Attribute[0]);
                this.generatePlanMarkup(head, buffer, (IIterationPlanRecord)plans.get(index), (IProgressInformation)progressInformations.get(index), (IProgressMonitor)progress.newChild(1));
                Html.TR.close((CharSequence)buffer);
                ++index;
            }
        }
        catch (TeamRepositoryException e) {
            PlanningClientPlugin.log((Throwable)e);
        }
        Html.TABLE.close((CharSequence)buffer);
    }

    protected void generatePlanMarkup(HashMap<String, String> head, StringBuffer buffer, IIterationPlanRecord plan, IProgressInformation progressInformation, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IIterationPlanClient client = PlanningClientPlugin.getIterationPlanClient((IItemHandle)plan);
        IComplexityAttribute attribute = client.findComplexityAttribute(plan.getOwner(), (IProgressMonitor)progress.newChild(1));
        IProgressLabelProvider labelProvider = ProgressIDE.newLabelProvider(((IScriptableProxy)progressInformation).getScriptEnvironment(), attribute);
        ProgressBarMarkupStrategy strategy = new ProgressBarMarkupStrategy(labelProvider, progressInformation);
        Html.TD.open((CharSequence)buffer, new Html.Attribute[]{new Html.Attribute("width", "100%")});
        Html.append((CharSequence)buffer, (CharSequence)NLS.bind((String)Messages.IterationFolderDomainAdapter_PLAN_TITLE, (Object)XMLStrings.escape((String)plan.getName()), (Object[])new Object[0]));
        Html.BR.open((CharSequence)buffer, new Html.Attribute[0]);
        strategy.generateHead(head);
        strategy.generateBody((CharSequence)buffer);
        Html.DIV.open((CharSequence)buffer, new Html.Attribute[]{new Html.Attribute("style", "float: left;")});
        Html.append((CharSequence)buffer, (CharSequence)labelProvider.getProgressText(progressInformation));
        Html.DIV.close((CharSequence)buffer);
        Html.DIV.open((CharSequence)buffer, new Html.Attribute[]{new Html.Attribute("style", "float: right; clear: both;")});
        Html.append((CharSequence)buffer, (CharSequence)labelProvider.getQualityText(progressInformation));
        Html.DIV.close((CharSequence)buffer);
        Html.TD.close((CharSequence)buffer);
    }

    public String generateContentAsText(Object input) {
        return this.generateTitle(input);
    }

    public String generateTitle(Object input) {
        return (input = this.convertToDomainObject(input)) != null ? ((PlanningDomainFolder)input).getName() : null;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        if (info.isHoverTooltip) {
            return null;
        }
        return (input = this.convertToDomainObject(input)) != null ? NLS.bind((String)Messages.IterationFolderDomainAdapter_JOB_INFO_DETAIL, (Object)((PlanningDomainFolder)input).getName(), (Object[])new Object[0]) : Messages.IterationFolderDomainAdapter_JOB_INFO;
    }

    private TreePath toTreePath(PlanningDomainFolder folder) {
        ArrayList<PlanningDomainFolder> path = new ArrayList<PlanningDomainFolder>();
        PlanningDomainFolder parentFolder = folder;
        while (parentFolder != null) {
            path.add(0, parentFolder);
            Object obj = parentFolder.getParent();
            parentFolder = (PlanningDomainFolder)(obj instanceof PlanningDomainFolder ? obj : null);
        }
        return path.isEmpty() ? TreePath.EMPTY : new TreePath(path.toArray());
    }
}

