/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IUsageStatistics;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.RootFolder;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RecentlyViewedPlansFolder
extends PlanningDomainFolder {
    private static final String SCOPE = "plans.recent@";

    public static IUsageStatistics getStats(IProjectAreaHandle projectArea) {
        IUsageStatistics usage = PlanningUIPlugin.getDefault().getUsageStatistics(SCOPE + projectArea.getItemId().getUuidValue());
        return usage;
    }

    protected RecentlyViewedPlansFolder(PlanningDomainFolder parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return Messages.RecentlyViewedPlansFolder_LABEL;
    }

    public Collection<IIterationPlanRecord> getContents(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IUsageStatistics usage = RecentlyViewedPlansFolder.getStats(projectArea);
        ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>();
        List<String> keys = usage.keys();
        if (keys.size() > 9) {
            Iterator<String> iter = keys.listIterator(9);
            while (iter.hasNext()) {
                usage.remove((String)iter.next());
            }
        }
        for (String uuidValue : keys) {
            try {
                UUID uuid = UUID.valueOf((String)uuidValue);
                handles.add(IIterationPlanRecord.ITEM_TYPE.createItemHandle(uuid, null));
            }
            catch (IllegalArgumentException e) {
                PlanningUIPlugin.log(e);
            }
        }
        progress.worked(1);
        IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectArea).itemManager();
        ArrayList<IIterationPlanRecord> result = new ArrayList<IIterationPlanRecord>(itemManager.fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(1)));
        ListIterator filterIter = result.listIterator();
        while (filterIter.hasNext()) {
            if (filterIter.next() != null) continue;
            usage.remove(((IItemHandle)handles.get(filterIter.nextIndex() - 1)).getItemId().getUuidValue());
            filterIter.remove();
        }
        return result;
    }

    @Override
    protected void unmanage(RootFolder root) {
    }
}

