/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.NewIterationPlanAction;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningContentProvider;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningLabelProvider;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IProcessAreaCategory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class PlanningDomain
extends Domain {
    private PlanningLabelProvider fLabelProvider;
    private PlanningContentProvider fContentProvider;

    public Object getRoot() {
        return this;
    }

    public boolean contains(Object element) {
        return element instanceof PlanningDomain || element instanceof IIterationPlanRecord || element instanceof PlanningDomainFolder;
    }

    public ITreePathLabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new PlanningLabelProvider();
        }
        return this.fLabelProvider;
    }

    public ITreePathContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new PlanningContentProvider(this);
        }
        return this.fContentProvider;
    }

    public boolean supportsCategory(Category category) {
        return category instanceof IProcessAreaCategory;
    }

    public void contributeContextMenuActions(IMenuManager manager, IStructuredSelection selection) {
        if (selection.size() != 1) {
            super.contributeContextMenuActions(manager, selection);
            return;
        }
        Object element = selection.getFirstElement();
        IWorkbenchPartSite workbenchPartSite = this.getWorkbenchPart().getSite();
        if (element instanceof DomainSubtreeRoot || element instanceof PlanningDomainFolder) {
            IMenuManager menu = manager.findMenuUsingPath("jazz.new");
            if (menu != null) {
                menu.appendToGroup("group1", (IAction)new NewIterationPlanAction(workbenchPartSite.getWorkbenchWindow().getWorkbench(), selection));
            }
        } else {
            super.contributeContextMenuActions(manager, selection);
        }
    }

    public boolean open(IWorkbenchPartSite site, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (!(element instanceof IIterationPlanRecord)) continue;
            PlanningUIPlugin.openIterationPlanEditor((IIterationPlanRecordHandle)((IIterationPlanRecord)element), site.getWorkbenchWindow().getActivePage());
            return true;
        }
        return false;
    }

    public ViewerSorter getSorter() {
        return new ViewerSorter(){

            public int category(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return 1;
                }
                if (element instanceof IIterationPlanRecordHandle) {
                    return 2;
                }
                if (element instanceof PlanningDomainFolder) {
                    return 3;
                }
                return super.category(element);
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                boolean pending1 = e1 instanceof PendingUpdateAdapter;
                boolean pending2 = e2 instanceof PendingUpdateAdapter;
                if (pending1 && pending2) {
                    return 0;
                }
                if (pending1) {
                    return -1;
                }
                if (pending2) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public void dispose() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
        super.dispose();
    }
}

