/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.internal.client.IterationPlanClient;
import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.util.IterationStructure;
import com.ibm.team.apt.internal.common.plantype.IBacklogIteration;
import com.ibm.team.apt.internal.common.util.CMode;
import com.ibm.team.apt.internal.common.util.ItemArrayList;
import com.ibm.team.apt.internal.common.util.ItemCollections;
import com.ibm.team.apt.internal.common.util.ItemHashMap;
import com.ibm.team.apt.internal.common.util.ItemHashSet;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemMap;
import com.ibm.team.apt.internal.common.util.SortMode;
import com.ibm.team.apt.internal.ide.core.IPlanElementChangedListener;
import com.ibm.team.apt.internal.ide.core.PlanAddedEvent;
import com.ibm.team.apt.internal.ide.core.PlanChangedEvent;
import com.ibm.team.apt.internal.ide.core.PlanDeletedEvent;
import com.ibm.team.apt.internal.ide.core.PlanEvent;
import com.ibm.team.apt.internal.ide.core.PlanModel;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.AbstractIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.AllPlansFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.CurrentIterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.CurrentPlansFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.DevelopmentLineFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.IterationFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.apt.internal.ide.ui.navigator.MyCurrentPlansFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomain;
import com.ibm.team.apt.internal.ide.ui.navigator.PlanningDomainFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.RecentlyViewedPlansFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.RootFolder;
import com.ibm.team.apt.internal.ide.ui.util.DevelopmentLineUIComparator;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.rcp.ui.ProcessRCPUI;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IAuditableCommonProcess;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class PlanningContentProvider
implements ITreeContentProvider,
ITreePathContentProvider,
IDeferredWorkbenchAdapter {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    private PlanningDomain fDomain;
    private PlanListener fPlanListener;
    private PreferenceListener fPreferenceListener;
    private AbstractTreeViewer fViewer;
    private ItemMap<IProjectAreaHandle, RootFolder> fRootFolders;
    private ItemMap<IProjectAreaHandle, IterationStructure> fIterationStructures;
    private IIteration fInlinedIteration;
    private DeferredTreeContentManager fManager;

    public PlanningContentProvider(PlanningDomain domain) {
        Assert.isLegal((domain != null ? 1 : 0) != 0);
        this.fDomain = domain;
        this.addListeners();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fRootFolders = new ItemHashMap();
        this.fIterationStructures = new ItemHashMap();
        this.fInlinedIteration = null;
        this.fViewer = (AbstractTreeViewer)viewer;
        if (this.fManager == null) {
            this.fManager = new DeferredTreeContentManager(this, (AbstractTreeViewer)viewer, this.fDomain.getWorkbenchPart().getSite()){

                protected IDeferredWorkbenchAdapter getAdapter(Object element) {
                    if (PlanningContentProvider.this.hasChildren(element)) {
                        return PlanningContentProvider.this;
                    }
                    return super.getAdapter(element);
                }
            };
        }
    }

    public void dispose() {
        this.fManager = null;
        this.removeListeners();
    }

    public Object getParent(Object element) {
        if (element instanceof PlanningDomainFolder) {
            ((PlanningDomainFolder)element).getParent();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreePath) {
            return this.hasChildren((TreePath)element);
        }
        return false;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreePath) {
            return this.getChildren((TreePath)parentElement);
        }
        return null;
    }

    public Object[] getChildren(TreePath parentPath) {
        Object parentElement = parentPath.getLastSegment();
        if (parentElement instanceof DomainSubtreeRoot || parentElement instanceof PlanningDomainFolder) {
            return this.fManager.getChildren((Object)parentPath);
        }
        return EMPTY_ARRAY;
    }

    public TreePath[] getParents(Object element) {
        return EMPTY_TREEPATH_ARRAY;
    }

    public boolean hasChildren(TreePath path) {
        Object element = path.getLastSegment();
        return element instanceof DomainSubtreeRoot || element instanceof PlanningDomainFolder;
    }

    public boolean isContainer() {
        return true;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        block56: {
            TreePath path = (TreePath)object;
            Object element = path.getLastSegment();
            if (!(element instanceof DomainSubtreeRoot) && !(element instanceof PlanningDomainFolder) || monitor.isCanceled()) {
                return;
            }
            try {
                boolean showArchived = ProcessRCPUI.getPreferenceStore().getBoolean("teamArtifactsNavigator.showArchived");
                if (element instanceof DomainSubtreeRoot) {
                    monitor.beginTask("", 4);
                    DomainSubtreeRoot root = (DomainSubtreeRoot)element;
                    RootFolder rootFolder = this.createRootFolder(root);
                    this.fIterationStructures.clear();
                    this.fInlinedIteration = null;
                    IProjectAreaHandle projectAreaHandle = null;
                    ITeamArea teamArea = null;
                    Object categoryElement = root.getCategoryElement();
                    if (categoryElement instanceof IProjectAreaHandle) {
                        projectAreaHandle = (IProjectAreaHandle)categoryElement;
                    } else if (categoryElement instanceof ITeamArea) {
                        teamArea = (ITeamArea)categoryElement;
                        projectAreaHandle = teamArea.getProjectArea();
                    }
                    if (projectAreaHandle == null && teamArea == null) {
                        return;
                    }
                    List teamMemberAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
                    if (teamMemberAreas.isEmpty()) {
                        return;
                    }
                    ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
                    collector.add((Object)new RecentlyViewedPlansFolder(rootFolder), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    collector.add((Object)new MyCurrentPlansFolder(rootFolder, repository.loggedInContributor()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    collector.add((Object)new CurrentPlansFolder(rootFolder), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    collector.add((Object)new AllPlansFolder(rootFolder), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    break block56;
                }
                if (element instanceof RecentlyViewedPlansFolder) {
                    IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle((PlanningDomainFolder)element);
                    Collection<IIterationPlanRecord> plans = ((RecentlyViewedPlansFolder)element).getContents(projectAreaHandle, monitor);
                    collector.add(plans.toArray(), monitor);
                    break block56;
                }
                if (element instanceof AllPlansFolder) {
                    ItemList devLines;
                    AllPlansFolder allPlansFolder = (AllPlansFolder)element;
                    IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle((PlanningDomainFolder)element);
                    IterationStructure iterationStructure = this.fetchIterationStructure(projectAreaHandle, monitor);
                    ITeamRepository repository = (ITeamRepository)projectAreaHandle.getOrigin();
                    IAuditableClient auditableCommon = PlanningClientPlugin.getAuditableClient((ITeamRepository)repository);
                    IProcessItemService pis = PlanningClientPlugin.getProcessItemService((ITeamRepository)repository);
                    IProcessArea teamArea = null;
                    List teamMemberAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
                    if (teamMemberAreas.isEmpty()) {
                        return;
                    }
                    if (teamArea != null) {
                        devLines = new ItemArrayList(1);
                        IDevelopmentLine line = pis.getDevelopmentLine(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (showArchived || !line.isArchived()) {
                            devLines.add((Object)line);
                        }
                    } else {
                        devLines = iterationStructure.getDevelopmentLines(showArchived);
                        monitor.worked(1);
                    }
                    ItemCollections.sort((ItemList)devLines, (Comparator)new DevelopmentLineUIComparator(SortMode.ASC, auditableCommon.findDefaultDevelopmentLine(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1))));
                    ArrayList<ItemArrayList> currentIterations = new ArrayList<ItemArrayList>();
                    SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                    sub.beginTask("", devLines.size());
                    for (IDevelopmentLine developmentLine : devLines) {
                        ItemList itemList = iterationStructure.getCurrentIterations((IDevelopmentLineHandle)developmentLine);
                        ArrayList toUse = new ArrayList();
                        for (IIteration iteration : itemList) {
                            if (!this.showIteration(iterationStructure, iteration, showArchived)) continue;
                            toUse.add(iteration);
                        }
                        Collections.reverse(toUse);
                        ItemArrayList iterations = new ItemArrayList((Collection)toUse);
                        currentIterations.add(iterations);
                    }
                    sub.done();
                    if (currentIterations.size() == 1 && ((ItemList)currentIterations.get(0)).size() == 1) {
                        this.fInlinedIteration = (IIteration)((ItemList)currentIterations.get(0)).get(0);
                        this.fetchPlanRecords(repository, this.fInlinedIteration, teamMemberAreas, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        ItemHashMap devLineMap = new ItemHashMap();
                        for (IDevelopmentLine line : devLines) {
                            devLineMap.put(line.getItemHandle(), (Object)line);
                        }
                        ArrayList<AbstractIterationFolder> folders = new ArrayList<AbstractIterationFolder>();
                        for (ItemList itemList : currentIterations) {
                            for (IIteration iteration : itemList) {
                                IDevelopmentLine line = (IDevelopmentLine)devLineMap.get((IItemHandle)iteration.getDevelopmentLine());
                                if (line != null) {
                                    folders.add(new CurrentIterationFolder(allPlansFolder, iteration, line));
                                    continue;
                                }
                                folders.add(new IterationFolder(allPlansFolder, iteration));
                            }
                        }
                        collector.add(folders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    if (monitor.isCanceled()) {
                        return;
                    }
                    ArrayList<DevelopmentLineFolder> devLineFolders = new ArrayList<DevelopmentLineFolder>(devLines.size());
                    for (IDevelopmentLine devLine : devLines) {
                        devLineFolders.add(new DevelopmentLineFolder(allPlansFolder, devLine));
                    }
                    collector.add(devLineFolders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    break block56;
                }
                if (element instanceof CurrentPlansFolder) {
                    IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle((PlanningDomainFolder)element);
                    IItemManager itemManager = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager();
                    IAuditableClient auditableClient = PlanningClientPlugin.getAuditableClient((IItemHandle)projectAreaHandle);
                    IterationPlanClient planClient = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((IItemHandle)projectAreaHandle);
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ArrayList<Object> owner = new ArrayList<Object>();
                    IAuditableCommonProcess commonProcess = auditableClient.getProcess((IProcessAreaHandle)projectAreaHandle, (IProgressMonitor)progress.newChild(5));
                    owner.add((IProjectArea)itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)progress.newChild(5)));
                    owner.addAll(((CurrentPlansFolder)element).getProcessAreas(projectAreaHandle, (IProgressMonitor)progress.newChild(5)));
                    IterationStructure iterationStructure = this.fetchIterationStructure(projectAreaHandle, (IProgressMonitor)progress.newChild(5));
                    ArrayList<IIteration> iterations = new ArrayList<IIteration>();
                    ItemHashSet timelines = new ItemHashSet(CMode.CURRENT_HANDLEONLY);
                    IProcessItemService processItemService = PlanningClientPlugin.getProcessItemService((IItemHandle)projectAreaHandle);
                    Iterator iter = owner.iterator();
                    progress.setWorkRemaining(25 + owner.size() * 3);
                    while (iter.hasNext()) {
                        IProcessArea processArea = (IProcessArea)iter.next();
                        if (processArea.isArchived() && !showArchived) {
                            iter.remove();
                            progress.worked(3);
                            continue;
                        }
                        IDevelopmentLine iDevelopmentLine = processItemService.getDevelopmentLine(processArea, (IProgressMonitor)progress.newChild(1));
                        if (iDevelopmentLine != null && !timelines.contains((Object)iDevelopmentLine)) {
                            ItemList currentIterations = iterationStructure.getCurrentIterations((IDevelopmentLineHandle)iDevelopmentLine);
                            for (IIteration iteration : currentIterations) {
                                if (iteration.isArchived() && !showArchived) continue;
                                iterations.add(iteration);
                            }
                            IBacklogIteration backlogConfig = (IBacklogIteration)planClient.findConfigurationElement(IBacklogIteration.class, iDevelopmentLine.getId(), commonProcess, (IProgressMonitor)progress.newChild(1));
                            if (backlogConfig != null) {
                                IIteration backlogIteration = IterationsHelper.resolveIterationFromPath((IProcessAreaHandle)projectAreaHandle, (String)backlogConfig.getPath(), (IAuditableCommon)auditableClient, (IProgressMonitor)progress.newChild(1));
                                if (backlogIteration != null) {
                                    iterations.add(backlogIteration);
                                }
                            } else {
                                progress.worked(1);
                            }
                            timelines.add((Object)iDevelopmentLine);
                            continue;
                        }
                        if (iDevelopmentLine == null) {
                            iter.remove();
                        }
                        progress.worked(2);
                    }
                    if (owner.isEmpty() || iterations.isEmpty()) {
                        return;
                    }
                    List planRecordHandles = planClient.fetchIterationPlanRecords(owner, iterations, (IProgressMonitor)progress.newChild(5));
                    List list = itemManager.fetchCompleteItems(planRecordHandles, 0, (IProgressMonitor)progress.newChild(5));
                    collector.add(list.toArray(), monitor);
                    break block56;
                }
                if (element instanceof DevelopmentLineFolder) {
                    monitor.beginTask("", 5);
                    DevelopmentLineFolder folder = (DevelopmentLineFolder)element;
                    folder.clearChildren();
                    IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle(folder);
                    List teamMemberAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
                    if (teamMemberAreas.isEmpty()) {
                        return;
                    }
                    IterationStructure iterationStructure = this.fetchIterationStructure(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ItemList projectPhases = iterationStructure.getIterations(folder.getDevelopmentLine().getIterations());
                    if (projectPhases.size() > 0) {
                        ArrayList<IterationFolder> folders = new ArrayList<IterationFolder>(projectPhases.size());
                        for (IIteration iteration : projectPhases) {
                            if (iteration == null || !this.showIteration(iterationStructure, iteration, showArchived)) continue;
                            folders.add(new IterationFolder(folder, iteration));
                        }
                        collector.add(folders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    break block56;
                }
                if (element instanceof IterationFolder) {
                    monitor.beginTask("", 4);
                    IterationFolder folder = (IterationFolder)element;
                    folder.clearChildren();
                    IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle(folder);
                    List teamMemberAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
                    if (teamMemberAreas.isEmpty()) {
                        return;
                    }
                    ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle);
                    this.fetchPlanRecords(repository, folder.getIteration(), teamMemberAreas, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    IterationStructure iterationStructure = this.fetchIterationStructure(projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    ItemList iterations = iterationStructure.getIterations(folder.getIteration().getChildren());
                    if (iterations.isEmpty()) {
                        return;
                    }
                    ArrayList<IterationFolder> folders = new ArrayList<IterationFolder>(iterations.size());
                    for (IIteration iteration : iterations) {
                        if (iteration == null || !this.showIteration(iterationStructure, iteration, showArchived)) continue;
                        folders.add(new IterationFolder(folder, iteration));
                    }
                    collector.add(folders.toArray(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    break block56;
                }
                if (!(element instanceof CurrentIterationFolder)) break block56;
                monitor.beginTask("", -1);
                AbstractIterationFolder folder = (AbstractIterationFolder)element;
                folder.clearChildren();
                IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle(folder);
                List teamMemberAreas = this.fDomain.getConnectedProjectAreaRegistry().getSelectedProcessAreas(projectAreaHandle);
                if (teamMemberAreas.isEmpty()) {
                    return;
                }
                try {
                    this.fetchPlanRecords(PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle), folder.getIteration(), teamMemberAreas, collector, monitor);
                }
                catch (TeamRepositoryException e) {
                    PlanningUIPlugin.log(e);
                }
            }
            finally {
                collector.done();
                monitor.done();
            }
        }
    }

    private RootFolder createRootFolder(DomainSubtreeRoot root) {
        IProjectAreaHandle projectAreaHandle = this.getProjectAreaHandle(root);
        RootFolder result = this.getRootFolder(projectAreaHandle);
        if (result != null) {
            return result;
        }
        result = new RootFolder(root);
        this.fRootFolders.put((IItemHandle)projectAreaHandle, (Object)result);
        return result;
    }

    private RootFolder getRootFolder(DomainSubtreeRoot root) {
        return this.getRootFolder(this.getProjectAreaHandle(root));
    }

    private RootFolder getRootFolder(IProjectAreaHandle projectAreaHandle) {
        return (RootFolder)this.fRootFolders.get((IItemHandle)projectAreaHandle);
    }

    private IterationStructure fetchIterationStructure(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IterationStructure iterationStructure = (IterationStructure)this.fIterationStructures.get((IItemHandle)projectAreaHandle);
        if (iterationStructure == null) {
            iterationStructure = IterationStructure.create((IProjectAreaHandle)projectAreaHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.fIterationStructures.put((IItemHandle)projectAreaHandle, (Object)iterationStructure);
        }
        return iterationStructure;
    }

    private boolean showIteration(IterationStructure iterationStructure, IIteration iteration, boolean showArchived) {
        return iterationStructure.showIteration((IIterationHandle)iteration) && (!iteration.isArchived() || showArchived);
    }

    private void fetchPlanRecords(ITeamRepository repository, IIteration iteration, List<IProcessAreaHandle> teamMemberAreas, IElementCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemManager manager = repository.itemManager();
        IterationPlanClient client = (IterationPlanClient)PlanningClientPlugin.getIterationPlanClient((ITeamRepository)repository);
        List planRecords = client.fetchIterationPlanRecords(teamMemberAreas, (IIterationHandle)iteration, monitor);
        if (monitor.isCanceled()) {
            return;
        }
        List items = manager.fetchCompleteItems(planRecords, 0, monitor);
        collector.add(items.toArray(), monitor);
    }

    public IProjectAreaHandle getProjectAreaHandle(PlanningDomainFolder folder) {
        return this.getProjectAreaHandle(folder.getRoot().getDomainSubtreeRoot());
    }

    private IProjectAreaHandle getProjectAreaHandle(DomainSubtreeRoot parent) {
        Object categoryElement = parent.getCategoryElement();
        if (categoryElement instanceof IProjectAreaHandle) {
            return (IProjectAreaHandle)categoryElement;
        }
        if (categoryElement instanceof ITeamArea) {
            return ((ITeamArea)categoryElement).getProjectArea();
        }
        Assert.isTrue((boolean)false, (String)("Shouldn't happen. Category element is: " + categoryElement.getClass().getName()));
        return null;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        if (o instanceof ITeamRepository) {
            return ((ITeamRepository)o).getRepositoryURI();
        }
        if (o instanceof IIterationPlanRecord) {
            return ((IIterationPlanRecord)o).getName();
        }
        if (o instanceof TreePath) {
            TreePath path = (TreePath)o;
            Object lastSegement = path.getLastSegment();
            if (lastSegement instanceof DomainSubtreeRoot) {
                return Messages.PlanningContentProvider_LABEL_PLANNING_DOMAIN;
            }
            if (lastSegement instanceof PlanningDomainFolder) {
                return ((PlanningDomainFolder)lastSegement).getName();
            }
            return o.toString();
        }
        return o.toString();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    private void addListeners() {
        if (this.fPlanListener == null) {
            this.fPlanListener = new PlanListener();
            PlanModel.INSTANCE.addListener((IPlanElementChangedListener)this.fPlanListener);
        }
        if (this.fPreferenceListener == null) {
            this.fPreferenceListener = new PreferenceListener();
            ProcessRCPUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private void removeListeners() {
        if (this.fPlanListener != null) {
            PlanModel.INSTANCE.removeListener((IPlanElementChangedListener)this.fPlanListener);
            this.fPlanListener = null;
        }
        if (this.fPreferenceListener != null) {
            ProcessRCPUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    private void refreshViewer() {
        if (this.fViewer == null) {
            return;
        }
        UI.syncExec(this.fViewer.getControl(), new Runnable(){

            @Override
            public void run() {
                for (RootFolder rootFolder : PlanningContentProvider.this.fRootFolders.values()) {
                    PlanningContentProvider.this.fViewer.refresh((Object)rootFolder.getDomainSubtreeRoot());
                }
            }
        });
    }

    private void handlePlanAdded(final PlanAddedEvent event) {
        this.postUpdate(new Runnable(){

            @Override
            public void run() {
                RootFolder rootFolder;
                if (PlanningContentProvider.this.fRootFolders.isEmpty()) {
                    return;
                }
                IIterationPlanRecord record = event.getPlan();
                IProjectAreaHandle connectedProjectArea = PlanningContentProvider.this.getConnectedProjectArea(record);
                if (connectedProjectArea != null && (rootFolder = PlanningContentProvider.this.getRootFolder(connectedProjectArea)) != null) {
                    IIterationHandle iteration = record.getIteration();
                    if (PlanningContentProvider.this.fInlinedIteration != null && PlanningContentProvider.this.fInlinedIteration.sameItemId((IItemHandle)iteration)) {
                        PlanningContentProvider.this.fViewer.refresh((Object)rootFolder.getDomainSubtreeRoot());
                    } else {
                        List<PlanningDomainFolder> folders = rootFolder.getFolders((IItemHandle)iteration);
                        if (folders != null) {
                            for (PlanningDomainFolder folder : folders) {
                                PlanningContentProvider.this.fViewer.refresh((Object)folder);
                            }
                        }
                    }
                }
            }
        });
    }

    private void handlePlanChanged(final PlanChangedEvent event) {
        this.postUpdate(new Runnable(){

            @Override
            public void run() {
                if (event.isIntervalChanged()) {
                    RootFolder folder;
                    IProjectAreaHandle connectedProjectArea = PlanningContentProvider.this.getConnectedProjectArea(event.getPlan());
                    if (connectedProjectArea != null && (folder = PlanningContentProvider.this.getRootFolder(connectedProjectArea)) != null) {
                        PlanningContentProvider.this.fViewer.refresh((Object)folder.getDomainSubtreeRoot());
                    }
                } else {
                    PlanningContentProvider.this.fViewer.update((Object)event.getPlan(), null);
                }
            }
        });
    }

    private void handlePlanDeleted(final PlanDeletedEvent event) {
        UI.syncExec(this.fViewer.getControl(), new Runnable(){

            @Override
            public void run() {
                PlanningContentProvider.this.fViewer.remove((Object)event.getPlan());
            }
        });
    }

    private void postUpdate(Runnable runnable) {
        if (this.fViewer == null) {
            return;
        }
        Control tree = this.fViewer.getControl();
        if (!tree.isDisposed()) {
            tree.getDisplay().syncExec(runnable);
        }
    }

    private IProjectAreaHandle getConnectedProjectArea(IIterationPlanRecord record) {
        IProjectAreaHandle connectedProjectArea;
        IProcessAreaHandle owner = record.getOwner();
        connectedProjectArea = owner instanceof IProjectAreaHandle ? (connectedProjectArea = (IProjectAreaHandle)owner) : this.fDomain.getConnectedProjectAreaRegistry().getConnectedProjectArea((ITeamAreaHandle)owner);
        return connectedProjectArea;
    }

    private class PlanListener
    implements IPlanElementChangedListener {
        private PlanListener() {
        }

        public void changed(PlanEvent event) {
            if (!(event.getPlan() instanceof IIterationPlanRecord)) {
                return;
            }
            if (event instanceof PlanAddedEvent) {
                PlanningContentProvider.this.handlePlanAdded((PlanAddedEvent)event);
            }
            if (event instanceof PlanChangedEvent) {
                PlanningContentProvider.this.handlePlanChanged((PlanChangedEvent)event);
            }
            if (event instanceof PlanDeletedEvent) {
                PlanningContentProvider.this.handlePlanDeleted((PlanDeletedEvent)event);
            }
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("teamArtifactsNavigator.showDeletedIterations".equals(event.getProperty())) {
                PlanningContentProvider.this.refreshViewer();
            }
        }
    }
}

