/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.ide.ui.navigator.CurrentPlansFolder;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.apt.internal.ide.ui.navigator.RootFolder;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class MyCurrentPlansFolder
extends CurrentPlansFolder {
    private final IContributor fContributor;

    protected MyCurrentPlansFolder(RootFolder parent, IContributor contributor) {
        super(parent);
        this.fContributor = contributor;
        parent.storeMapping(this.fContributor.getItemHandle(), this);
    }

    public IContributor getContributor() {
        return this.fContributor;
    }

    @Override
    public List<? extends IProcessArea> getProcessAreas(IProjectAreaHandle projectAreaHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IProcessItemService processItemService = PlanningClientPlugin.getProcessItemService((IItemHandle)projectAreaHandle);
        List handles = processItemService.findProcessAreas(this.getContributor(), projectAreaHandle, null, (IProgressMonitor)progress.newChild(1));
        List items = PlanningClientPlugin.getTeamRepository((IItemHandle)projectAreaHandle).itemManager().fetchCompleteItems(handles, 0, (IProgressMonitor)progress.newChild(1));
        return new ArrayList(items);
    }

    @Override
    public String getName() {
        return Messages.MyCurrentPlansFolder_LABEL;
    }

    @Override
    protected void unmanage(RootFolder root) {
        root.removeMapping(this.fContributor.getItemHandle(), this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MyCurrentPlansFolder)) {
            return false;
        }
        MyCurrentPlansFolder other = (MyCurrentPlansFolder)obj;
        return this.fContributor.sameItemId((IItemHandle)other.fContributor);
    }

    public int hashCode() {
        return this.fContributor.getItemId().hashCode();
    }
}

