/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.navigator;

import com.ibm.team.apt.common.IIterationPlanRecord;
import com.ibm.team.apt.common.IIterationPlanRecordHandle;
import com.ibm.team.apt.ide.ui.PlanningUI;
import com.ibm.team.apt.internal.common.util.Html;
import com.ibm.team.apt.internal.ide.ui.navigator.Messages;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.IFeedService;
import com.ibm.team.repository.common.util.NLS;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class AddPlanToSubscriptionsAction
implements IObjectActionDelegate {
    private IWorkbenchPartSite fSite;
    private IIterationPlanRecordHandle fIterationPlanHandle;

    public AddPlanToSubscriptionsAction() {
    }

    public AddPlanToSubscriptionsAction(IWorkbenchPartSite site) {
        this.fSite = site;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            this.fIterationPlanHandle = (IIterationPlanRecordHandle)element;
        }
    }

    public void run(IAction action) {
        Assert.isNotNull((Object)this.fIterationPlanHandle);
        this.run(this.fIterationPlanHandle);
    }

    public void run(final IIterationPlanRecordHandle planHandle) {
        final ITeamRepository repository = (ITeamRepository)planHandle.getOrigin();
        if (!repository.loggedIn()) {
            MessageDialog.openError((Shell)this.fSite.getShell(), (String)Messages.AddPlanToSubscriptionsAction_FAILURE_CREATE_SUBSCRIPTION, (String)Messages.AddPlanToSubscriptionsAction_FAILURE_NOT_LOGGED_IN);
            return;
        }
        UIUpdaterJob job = new UIUpdaterJob(Messages.AddPlanToSubscriptionsAction_JOB_RESOLVE_ITEMS){
            private IIterationPlanRecord fRecord;
            private IIteration fInterval;

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    this.fRecord = (IIterationPlanRecord)repository.itemManager().fetchCompleteItem((IItemHandle)planHandle, 0, monitor);
                    this.fInterval = (IIteration)repository.itemManager().fetchCompleteItem((IItemHandle)this.fRecord.getIteration(), 0, monitor);
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, PlanningUI.getPluginId(), 4, e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                try {
                    AddPlanToSubscriptionsAction.this.createChannel(repository, this.fRecord, this.fInterval);
                }
                catch (UnsupportedEncodingException e) {
                    MessageDialog.openError((Shell)AddPlanToSubscriptionsAction.this.fSite.getShell(), (String)Messages.AddPlanToSubscriptionsAction_FAILURE_CREATE_CHANNEL, (String)e.getLocalizedMessage());
                }
                catch (URISyntaxException e) {
                    MessageDialog.openError((Shell)AddPlanToSubscriptionsAction.this.fSite.getShell(), (String)Messages.AddPlanToSubscriptionsAction_FAILURE_CREATE_CHANNEL, (String)e.getLocalizedMessage());
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void createChannel(ITeamRepository repository, IIterationPlanRecord plan, IIteration interval) throws UnsupportedEncodingException, URISyntaxException {
        FeedManager newsMgr = FeedManager.getDefault();
        String url = this.buildURL(repository, plan);
        this.createChannel(plan, interval, newsMgr, url);
    }

    private String buildURL(ITeamRepository repository, IIterationPlanRecord plan) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("?provider=iterationPlan&itemId=");
        queryBuilder.append(plan.getItemId().getUuidValue());
        Location location = Location.serviceLocation((String)repository.getRepositoryURI(), IFeedService.class);
        return String.valueOf(location.toString()) + queryBuilder.toString();
    }

    protected void createChannel(IIterationPlanRecord plan, IIteration iteration, FeedManager newsMgr, String url) {
        if (newsMgr.getChannel(url) != null) {
            MessageDialog.openInformation((Shell)this.fSite.getShell(), (String)Messages.AddPlanToSubscriptionsAction_FAILURE_SUBSCRIPTS_EXISTS, (String)Messages.AddPlanToSubscriptionsAction_FAILURE_SUBSCRIPTION_EXISTS_DETAIL);
            return;
        }
        Channel channel = FeedFactory.eINSTANCE.createChannel();
        channel.setUrl(url);
        channel.setTitle(NLS.bind((String)Messages.AddPlanToSubscriptionsAction_FEED_NAME, (Object)plan.getName(), (Object[])new Object[]{iteration.getLabel()}));
        channel.setDescription(NLS.bind((String)Messages.AddPlanToSubscriptionsAction_FEED_DESCRIPTION, (Object)(String.valueOf(Html.ITALIC.open) + plan.getName()), (Object[])new Object[]{String.valueOf(iteration.getLabel()) + Html.ITALIC.close}));
        channel.setForceDownload(true);
        channel.setUpdateInterval(10);
        channel.setCategory("com.ibm.team.feed.core.SystemFeed");
        channel.setExplicitRefresh(true);
        newsMgr.addChannel(channel);
        newsMgr.loadNews(channel);
    }

    protected IWorkbenchPartSite getSite() {
        return this.fSite;
    }
}

