/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IPlanElementVisitor;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.ide.ui.common.GadgetFactory;
import com.ibm.team.apt.internal.ide.ui.common.IGadgetCreator;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GFiledAgainst;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GPlannedIteration;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanItemViewerSection;
import com.ibm.team.apt.internal.ide.ui.mywork.GColumnBox;
import com.ibm.team.apt.internal.ide.ui.mywork.GroupByMyWorkChangesDescription;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkGadgetFactory;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkItemGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkItemNodeContent;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewModel;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.InformationBar;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNode;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class SectionMyWorkChanges
extends AbstractPlanItemViewerSection {
    public static final String SECTION_ID = "com.ibm.team.apt.internal.ui.mywork.SectionMyWorkChanges";

    public SectionMyWorkChanges() {
        super("com.ibm.team.apt.actions.mywork.inbox");
    }

    @Override
    protected void onInit(IMemento memento) {
        super.onInit(memento);
    }

    @Override
    public void createContent(Composite parent) {
        super.createContent(parent);
        UI.hookHelpListener(this.getViewer().getControl(), "com.ibm.team.apt.ide.ui.section_myWorkNew");
    }

    @Override
    public void createTeaser(Composite parent) {
        super.createTeaser(parent);
        UI.hookHelpListener((Control)parent.getParent(), "com.ibm.team.apt.ide.ui.section_myWorkNew");
    }

    @Override
    protected GroupByDescription createGroupByDescription() {
        return new GroupByMyWorkChangesDescription();
    }

    @Override
    protected void onInitializePlan() {
        ResolvedPersonalPlan resolvedPersonalPlan = this.getPlan();
        if (resolvedPersonalPlan != null) {
            for (PlanItem planItem : this.getPlan().getAllPlanItems()) {
                if (!planItem.isNewItem() || planItem.isMarkedRead()) continue;
                this.runInUI(new Runnable(){

                    @Override
                    public void run() {
                        SectionMyWorkChanges.this.getSectionSite().showAlert(true, true);
                    }
                });
                break;
            }
        }
    }

    @Override
    protected void onUpdateSectionHeader(SectionLabel teaserLabel) {
        StringBuilder teaserTextBuilder = new StringBuilder();
        MyWorkViewModel viewModel = this.getViewModel();
        if (viewModel != null) {
            final int[] counts = new int[2];
            viewModel.readModel(new IViewModelReadFunction<int[], RuntimeException>(){

                public int[] run(IViewModelReader readAccessor) throws RuntimeException {
                    readAccessor.accept(new IViewEntryVisitor(){

                        public boolean visit(IViewEntry<?> entry) {
                            if (EntryUtils.isType(entry, PlanElement.class)) {
                                counts[0] = counts[0] + 1;
                                if (entry.isVisible()) {
                                    counts[1] = counts[1] + 1;
                                }
                            }
                            return true;
                        }
                    }, null);
                    return null;
                }
            });
            int elementCount = counts[0];
            int visibleCount = counts[1];
            if (this.isQuickFilterActive()) {
                teaserTextBuilder.append(MessageFormat.format(Messages.SectionMyWorkChanges_TEASER_QUICK_FILTER, visibleCount, elementCount));
            } else if (elementCount == 1) {
                teaserTextBuilder.append(Messages.SectionMyWorkChanges_TEASER_ITEM);
            } else if (elementCount > 1) {
                teaserTextBuilder.append(NLS.bind((String)Messages.SectionMyWorkChanges_TEASER_ITEMS, (Object)elementCount, (Object[])new Object[0]));
            }
            if (this.getPersonalPlanService().shouldShowQuickStartAffordance() && elementCount > 0) {
                String message = NLS.bind((String)Messages.SectionMyWorkChanges_ACCEPT_GETTING_STARTED, (Object)"accept", (Object[])new Object[]{"assistance"});
                this.setInformationMessage(message, 1, new InformationBar.IInformationBarListener(){

                    @Override
                    public void clicked(String ref) {
                        if ("accept".equals(ref)) {
                            SectionMyWorkChanges.this.getPlan().accept(new IPlanElementVisitor(){

                                public boolean visit(PlanElement element) {
                                    PlanItem planItem;
                                    if (element instanceof PlanItem && (planItem = (PlanItem)element).isNewItem()) {
                                        planItem.markAsNewItem(false);
                                    }
                                    return true;
                                }
                            });
                        } else if ("assistance".equals(ref)) {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.team.apt.ide.ui.section_myWorkNew");
                        }
                    }

                    @Override
                    public void closed() {
                        SectionMyWorkChanges.this.getPersonalPlanService().disableQuickStartAffordance();
                    }
                });
            } else {
                this.clearInformationMessage();
            }
        }
        teaserLabel.setText(teaserTextBuilder.toString());
    }

    @Override
    protected void onDispose() {
        super.onDispose();
    }

    @Override
    protected GadgetFactory getGadgetFactory() {
        final IViewSite viewSite = this.getSectionSite().getViewSite();
        return new MyWorkGadgetFactory(new IGadgetCreator<PlanItem>(){

            @Override
            public Class<PlanItem> getEntryType() {
                return PlanItem.class;
            }

            @Override
            public GTreeNode<?> createGadget(ContentOutlineItem outlineItem, IViewEntry<PlanItem> entry) {
                List colorTags = entry.getTags(ColorizeTag.class);
                MyWorkItemGadget planItemGadget = new MyWorkItemGadget(outlineItem, entry, (IWorkbenchSite)viewSite, colorTags);
                planItemGadget.setContent(new CustomizedWorkItemNodeContent(planItemGadget, (PlanItem)entry.getElement()));
                return planItemGadget;
            }
        });
    }

    @Override
    protected boolean onPlanElementChanged(IPlanElementDelta delta) {
        if (delta.getPlanElement() instanceof PlanItem) {
            PlanItem item = (PlanItem)delta.getPlanElement();
            if (delta.isAdded() || delta.isRemoved() || delta.affectsAttribute(PlanItem.NEW_ITEM) || delta.affectsAttribute(PlanItem.RESOLVED)) {
                this.updateSectionHeader();
            }
            if (delta.isAdded() && item.isNewItem() && !item.isMarkedRead()) {
                this.runInUI(new Runnable(){

                    @Override
                    public void run() {
                        SectionMyWorkChanges.this.getSectionSite().showAlert(true, true);
                    }
                });
                return false;
            }
        }
        return super.onPlanElementChanged(delta);
    }

    private static class CustomizedWorkItemNodeContent
    extends MyWorkItemNodeContent {
        private static final String[] LABEL_PROPERTIES = new String[]{PlanItem.CATEGORY.getId(), PlanItem.TARGET.getId()};

        static {
            Arrays.sort(LABEL_PROPERTIES);
        }

        public CustomizedWorkItemNodeContent(MyWorkItemGadget parent, PlanItem planItem) {
            super(parent, planItem);
        }

        @Override
        protected void contributeToPlanningControls(GColumnBox planningBox) {
            PlanItem planItem = (PlanItem)this.getElement();
            GPlannedIteration plannedIteration = new GPlannedIteration(planningBox, planItem);
            TextLayout textLayout = this.getOutlineResources().getTextLayout();
            textLayout.setText(IWorkItem.UNASSIGNED_TARGET_NAME);
            int width = textLayout.getBounds().width;
            plannedIteration.setLabelWidth(width);
            new GFiledAgainst(planningBox, planItem);
        }

        @Override
        protected boolean isExpanded() {
            return true;
        }

        @Override
        protected boolean showPlanningDetails() {
            return true;
        }

        @Override
        public boolean isLabelProperty(String property) {
            return super.isLabelProperty(property) || Arrays.binarySearch(LABEL_PROPERTIES, property) >= 0;
        }
    }
}

