/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.ILoadListener;
import com.ibm.team.apt.internal.client.IPlanElementDelta;
import com.ibm.team.apt.internal.client.IScheduleItem;
import com.ibm.team.apt.internal.client.MyWorkLoadInformation;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.client.teamload.AbstractLoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadInformation;
import com.ibm.team.apt.internal.client.teamload.LoadItem;
import com.ibm.team.apt.internal.client.teamload.LoadItems;
import com.ibm.team.apt.internal.common.util.ItemCollection;
import com.ibm.team.apt.internal.common.util.PlanRunnable;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.model.OutlineModelViewerRunnable;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelSequenceTransformer;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanItemViewerSection;
import com.ibm.team.apt.internal.ide.ui.mywork.GroupByMyCurrentWorkSequenceDescription;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkSettingsListener;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewModel;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkViewer;
import com.ibm.team.apt.internal.ide.ui.mywork.TimeSpansMode;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.LoadBarPainter;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Rectangles;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.internal.dashboard.ColorRegistry;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntryVisitor;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelNavigator;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;

public class SectionCurrentWork
extends AbstractPlanItemViewerSection {
    private static final String MYLOAD_SHOW_KEY = "myLoadShow";
    private static final String MYLOAD_DEVLINE_KEY = "myLoadDevLine";
    public static final String SECTION_ID = "com.ibm.team.apt.internal.ui.mywork.SectionMyCurrentWork";
    private IOutlineSettingsListener fSettingsListener;
    private Composite fContainer;
    private boolean fShowMyLoad = false;
    private UUID fMyLoadDevLine = null;
    private LoadBarPainter fProgressBarPainter;
    private Map<UUID, MyWorkLoadInformation> fMyWorkLoadInformation = new HashMap<UUID, MyWorkLoadInformation>();
    private Map<UUID, LoadItem> fLoadItems = new HashMap<UUID, LoadItem>();
    private Canvas fProgressBarCanvas;
    private TimespanUpdateJob fTimespanUpdateJob;
    private IViewEntry<?> fCurrentElement = null;
    private final IViewModelUpdateFunction fCurrentElementFinder = new IViewModelUpdateFunction<Void, RuntimeException>(){

        public Void run(IViewModelUpdater updateAccessor) throws RuntimeException {
            SectionCurrentWork.this.fCurrentElement = null;
            IViewEntry rootEntry = updateAccessor.getRootEntry(IViewModel.Domain.Content);
            if (rootEntry != null) {
                IViewModelNavigator n = updateAccessor.getEntryNavigator(true);
                for (IViewEntry groupEntry : n.childEntries(rootEntry)) {
                    for (IViewEntry itemEntry : n.childEntries(groupEntry)) {
                        if ((!EntryUtils.isType(itemEntry, IScheduleItem.class) || ((IScheduleItem)itemEntry.getElement()).isResolved()) && !EntryUtils.isType(itemEntry, MessageElement.class)) continue;
                        SectionCurrentWork.this.fCurrentElement = n.isFirst(itemEntry) ? groupEntry : itemEntry;
                        return null;
                    }
                }
            }
            return null;
        }
    };
    private IViewModel.IPostUpdateRunnerHandle fCurrentElementFinderToken;

    public SectionCurrentWork() {
        super("com.ibm.team.apt.actions.mywork.currentWork");
    }

    public void showCurrent() {
        this.doShowCurrent();
    }

    @Override
    protected void onInit(IMemento memento) {
        super.onInit(memento);
        if (memento != null) {
            this.fShowMyLoad = Boolean.parseBoolean(memento.getString(MYLOAD_SHOW_KEY));
            String devLineUuidString = memento.getString(MYLOAD_DEVLINE_KEY);
            if (devLineUuidString != null) {
                this.fMyLoadDevLine = UUID.valueOf((String)devLineUuidString);
            }
        }
        IMyWorkSettings settings = this.getSettings();
        this.fSettingsListener = new MyWorkSettingsListener(settings){

            @Override
            public void timeSpansModeChanged(TimeSpansMode mode) {
                SectionCurrentWork.this.handleTimeSpansModeChanged(mode);
            }
        };
        settings.addSettingsChangeListener(this.fSettingsListener);
        Assert.isTrue((this.fCurrentElementFinderToken == null ? 1 : 0) != 0);
        this.fCurrentElementFinderToken = this.getViewModel().addPostUpdateRunnable((IViewModelUpdateFunction<Void, ? extends RuntimeException>)this.fCurrentElementFinder, false);
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(MYLOAD_SHOW_KEY, Boolean.toString(this.fShowMyLoad));
        if (this.fMyLoadDevLine != null) {
            memento.putString(MYLOAD_DEVLINE_KEY, this.fMyLoadDevLine.getUuidValue());
        }
    }

    @Override
    public void sectionOpened() {
        Composite composite = this.getHeaderComposite();
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Display display = composite.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        ResolvedPersonalPlan plan = this.getPlan();
        if (plan == null) {
            return;
        }
        ItemCollection plans = plan.getRelatedPlans();
        if (plans.isEmpty()) {
            return;
        }
        Point location = display.getCursorLocation();
        PlanningUIPlugin.openIterationPlanMenu(this.getSectionSite().getViewSite().getPage(), location, new ArrayList(plans.toCollection()));
    }

    @Override
    protected GroupByDescription createGroupByDescription() {
        return new GroupByMyCurrentWorkSequenceDescription();
    }

    @Override
    protected void onInitializePlan() {
        this.doShowCurrent();
    }

    @Override
    protected boolean hasGroupByColorMenuItem() {
        return false;
    }

    @Override
    protected void onUpdateSectionHeader(SectionLabel teaserLabel) {
        StringBuilder teaserTextBuilder = new StringBuilder();
        MyWorkViewModel viewModel = this.getViewModel();
        if (viewModel != null) {
            final int[] counts = new int[3];
            viewModel.readModel(new IViewModelReadFunction<int[], RuntimeException>(){

                public int[] run(IViewModelReader readAccessor) throws RuntimeException {
                    readAccessor.accept(new IViewEntryVisitor(){

                        public boolean visit(IViewEntry<?> entry) {
                            if (EntryUtils.isType(entry, PlanElement.class)) {
                                counts[0] = counts[0] + 1;
                                if (entry.isVisible()) {
                                    counts[1] = counts[1] + 1;
                                }
                                if (EntryUtils.isType(entry, PlanItem.class) && !((PlanItem)entry.getElement()).isMarkedRead()) {
                                    counts[2] = counts[2] + 1;
                                }
                            }
                            return true;
                        }
                    }, null);
                    return null;
                }
            });
            int elementCount = counts[0];
            int visibleCount = counts[1];
            int unreadCount = counts[2];
            if (this.isQuickFilterActive()) {
                teaserTextBuilder.append(MessageFormat.format(Messages.SectionCurrentWork_TEASER_QUICK_FILTER, visibleCount, elementCount));
            } else if (unreadCount == 1) {
                teaserTextBuilder.append(Messages.SectionCurrentWork_TEASER_ITEM);
            } else if (unreadCount > 1) {
                teaserTextBuilder.append(NLS.bind((String)Messages.SectionCurrentWork_TEASER_ITEMS, (Object)unreadCount));
            }
        }
        teaserLabel.setText(teaserTextBuilder.toString());
    }

    @Override
    protected void doSetPostFilterState() {
        super.doSetPostFilterState();
        this.doShowCurrent();
    }

    @Override
    protected void onDispose() {
        Assert.isNotNull((Object)this.fCurrentElementFinderToken);
        this.getViewModel().removePostUpdateRunnable(this.fCurrentElementFinderToken);
        this.fCurrentElementFinderToken = null;
        this.getSettings().removeSettingsChangeListener(this.fSettingsListener);
        if (this.fTimespanUpdateJob != null) {
            this.fTimespanUpdateJob.cancel();
            this.fTimespanUpdateJob = null;
        }
        super.onDispose();
    }

    @Override
    protected void onInputChanged(ResolvedPersonalPlan oldInput, ResolvedPersonalPlan newInput) {
        for (MyWorkLoadInformation loadInformation : this.fMyWorkLoadInformation.values()) {
            loadInformation.dispose();
        }
        this.fMyWorkLoadInformation.clear();
        this.fLoadItems.clear();
        super.onInputChanged(oldInput, newInput);
        if (newInput != null) {
            ArrayList<LoadItem> iterationLoadItems = new ArrayList<LoadItem>();
            for (IIteration iteration : newInput.getPlannedIterations()) {
                LoadInformation loadInformation = newInput.getLoadInformation((IIterationHandle)iteration);
                if (loadInformation == null) continue;
                loadInformation.addTeamLoadListener(new ILoadListener(){

                    public void loadItemChanged(LoadItem item) {
                        SectionCurrentWork.this.runInUI(new Runnable(){

                            @Override
                            public void run() {
                                if (SectionCurrentWork.this.fProgressBarCanvas == null || SectionCurrentWork.this.fProgressBarCanvas.isDisposed()) {
                                    return;
                                }
                                if (((GridData)((SectionCurrentWork)(this).SectionCurrentWork.this).fProgressBarCanvas.getLayoutData()).exclude) {
                                    return;
                                }
                                SectionCurrentWork.this.fProgressBarCanvas.redraw();
                            }
                        });
                    }
                });
                LoadItem loadItem = loadInformation.getLoadItem((IContributorHandle)newInput.getPlanOwner());
                iterationLoadItems.add(loadItem);
                this.fLoadItems.put(iteration.getDevelopmentLine().getItemId(), loadItem);
            }
        }
        this.updateTimespans(false);
        this.runInUI(new Runnable(){

            @Override
            public void run() {
                SectionCurrentWork.this.showMyLoad(SectionCurrentWork.this.fShowMyLoad);
            }
        });
    }

    @Override
    protected boolean onPlanElementChanged(IPlanElementDelta delta) {
        if (delta.getPlanElement() instanceof PlanItem) {
            PlanItem item = (PlanItem)delta.getPlanElement();
            if (delta.isAdded() || delta.isRemoved() || delta.affectsAttribute(PlanItem.MARKED_READ) || delta.affectsAttribute(PlanItem.NEW_ITEM) || delta.affectsAttribute(PlanItem.TARGET)) {
                this.updateSectionHeader();
                return false;
            }
        }
        return super.onPlanElementChanged(delta);
    }

    @Override
    public void createTeaser(Composite parent) {
        super.createTeaser(parent);
        Menu sectionMenu = this.getSectionSite().getSectionMenu();
        String group1 = "group.allOrNothing";
        String group2 = "group.devLines";
        final MenuManager myLoadMenu = new MenuManager(Messages.SectionCurrentWork_MENU_MY_LOAD);
        myLoadMenu.add((IAction)new Action("Dummy"){});
        myLoadMenu.fill(sectionMenu, -1);
        myLoadMenu.setRemoveAllWhenShown(true);
        myLoadMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                myLoadMenu.add((IContributionItem)new Separator("group.allOrNothing"));
                myLoadMenu.add((IContributionItem)new Separator("group.devLines"));
                ResolvedPersonalPlan plan = SectionCurrentWork.this.getPlan();
                ItemCollection developmentLines = plan.getDevelopmentLines();
                myLoadMenu.appendToGroup("group.allOrNothing", (IAction)new ChooseDevelopmentLineAction(null));
                for (IDevelopmentLine developmentLine : developmentLines) {
                    myLoadMenu.appendToGroup("group.devLines", (IAction)new ChooseDevelopmentLineAction(developmentLine.getItemId()));
                }
            }
        });
        final MenuManager myTempoMenu = new MenuManager(Messages.SectionCurrentWork_MENU_TEMPO);
        myTempoMenu.add((IAction)new Action("Dummy"){});
        myTempoMenu.fill(sectionMenu, -1);
        myTempoMenu.setRemoveAllWhenShown(true);
        myTempoMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                myTempoMenu.add((IAction)new EnableTempoAction());
                myTempoMenu.add((IAction)new ShowTempoColorsAction());
                myTempoMenu.add((IAction)new RunTempoSimulationAction());
            }
        });
        UI.hookHelpListener((Control)parent.getParent(), "com.ibm.team.apt.ide.ui.section_myWorkCurrent");
    }

    @Override
    public void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).spacing(0, 0).applyTo(parent);
        this.fContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fContainer);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(0, 0).numColumns(1).applyTo(this.fContainer);
        this.createMyLoadCanvas(this.fContainer);
        super.createContent(this.fContainer);
        this.getCanvas().setCurrentItemProvider(new MyWorkCanvas.CurrentItemProvider(){

            @Override
            public OutlineItem getCurrentItem() {
                IViewEntry currentElement = SectionCurrentWork.this.getCurrentElement();
                if (currentElement != null) {
                    return SectionCurrentWork.this.getViewer().findOutlineItem(currentElement);
                }
                return null;
            }
        });
        UI.hookHelpListener((Control)this.fContainer, "com.ibm.team.apt.ide.ui.section_myWorkCurrent");
    }

    private void createMyLoadCanvas(Composite parent) {
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        FontData[] dialogFontDatas = JFaceResources.getDefaultFont().getFontData();
        int i = 0;
        while (i < dialogFontDatas.length) {
            FontData data = dialogFontDatas[i];
            data.setHeight(data.getHeight() - 1);
            ++i;
        }
        final Font statusFont = resourceManager.createFont(FontDescriptor.createFrom((FontData[])dialogFontDatas));
        Display display = parent.getDisplay();
        final Color color = display.getSystemColor(17);
        final TextLayout textLayout = new TextLayout((Device)display);
        textLayout.setFont(statusFont);
        int statusFontHeight = textLayout.getBounds().height;
        final BarResources barResources = new BarResources((ResourceManager)resourceManager, statusFont);
        this.fProgressBarPainter = new LoadBarPainter(barResources);
        final int BAR_HEIGHT = this.fProgressBarPainter.computeTrimHeight(statusFontHeight);
        int PROGRESSBAR_CANVAS_HEIGHT = BAR_HEIGHT + statusFontHeight;
        this.fProgressBarCanvas = new Canvas(parent, 262144);
        new TooltipSupport((Control)this.fProgressBarCanvas, true, false){

            public Object getElement(Control control, int x, int y) {
                return SectionCurrentWork.this.getLoadItem();
            }
        };
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, PROGRESSBAR_CANVAS_HEIGHT).applyTo((Control)this.fProgressBarCanvas);
        ColorRegistry colorreg = ColorRegistry.getDefault();
        this.fProgressBarCanvas.setBackground(JazzResources.getColor((ResourceManager)resourceManager, (ColorDescriptor)colorreg.getColorDescriptor((Object)"TEAM_CENTRAL_BACKGROUND")));
        new DoubleBufferPainter(this.fProgressBarCanvas){

            public void doPaint(PaintEvent e) {
                LoadItem loadItem = SectionCurrentWork.this.getLoadItem();
                if (loadItem == null) {
                    return;
                }
                GC gc = e.gc;
                Rectangle bounds = SectionCurrentWork.this.fProgressBarCanvas.getBounds();
                bounds.height = BAR_HEIGHT;
                int padding = BAR_HEIGHT / 4;
                Rectangles.resize(bounds, -2 * padding, 0);
                Rectangles.move(bounds, padding, 0);
                SectionCurrentWork.this.fProgressBarPainter.paint(gc, bounds, (AbstractLoadItem)loadItem);
                int x = bounds.x;
                int y = bounds.y + bounds.height;
                textLayout.setFont(statusFont);
                String status = LoadItems.getTextHours((AbstractLoadItem)loadItem);
                textLayout.setText(status);
                textLayout.setStyle(new TextStyle(null, color, null), 0, status.length());
                Color deltaColor = LoadItems.isOverbooked((AbstractLoadItem)loadItem) ? barResources.getRed() : barResources.getGreen();
                int index1 = status.lastIndexOf(124);
                if (index1 != -1) {
                    int index2 = status.lastIndexOf(104);
                    if (index2 == -1) {
                        index2 = status.length();
                    }
                    textLayout.setStyle(new TextStyle(null, deltaColor, null), index1 + 1, Math.max(index1 + 1, index2 - 1));
                    textLayout.draw(gc, x, y);
                }
                gc.setForeground(color);
                gc.setFont(statusFont);
                String estimateInfo = LoadItems.getTextEstimate((AbstractLoadItem)loadItem);
                Point sizeStr = gc.stringExtent(estimateInfo);
                gc.drawString(estimateInfo, x + bounds.width - sizeStr.x, y, true);
            }
        };
        this.fProgressBarCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textLayout.dispose();
            }
        });
    }

    private void doShowCurrent() {
        final MyWorkViewer viewer = this.getViewer();
        final IViewEntry<?> currentElement = this.getCurrentElement();
        if (currentElement != null && viewer != null) {
            new OutlineModelViewerRunnable(viewer){

                @Override
                protected void doRun() {
                    viewer.expandToLevel(currentElement, 0);
                    viewer.setTopItem(currentElement);
                }
            }.syncExec();
        }
    }

    private IViewEntry<?> getCurrentElement() {
        return this.fCurrentElement;
    }

    private synchronized void updateTimespans(boolean doUpdate) {
        final Timestamp newReferenceTime = new Timestamp(System.currentTimeMillis());
        final ResolvedPersonalPlan plan = this.getPlan();
        if (this.fTimespanUpdateJob != null) {
            this.fTimespanUpdateJob.cancel();
            this.fTimespanUpdateJob = null;
        }
        if (plan != null) {
            if (doUpdate) {
                this.runInUI(new Runnable(){

                    @Override
                    public void run() {
                        plan.runConnected((PlanRunnable)new PlanRunnable<RuntimeException>(){

                            public void run() {
                                MyWorkCanvas canvas = SectionCurrentWork.this.getCanvas();
                                MyWorkViewer viewer = SectionCurrentWork.this.getViewer();
                                MyWorkViewModel viewModel = SectionCurrentWork.this.getViewModel();
                                if (viewModel != null) {
                                    if (canvas != null && viewer != null) {
                                        canvas.setRedraw(false);
                                        try {
                                            plan.setReferenceTime((Date)newReferenceTime);
                                            viewModel.viewerPreservingRefresh();
                                        }
                                        finally {
                                            canvas.setRedraw(true);
                                        }
                                    } else {
                                        plan.setReferenceTime((Date)newReferenceTime);
                                        viewModel.viewerPreservingRefresh();
                                    }
                                }
                            }
                        });
                    }
                });
            }
            if (plan != null && plan.isConnected()) {
                Date timeSpanExpiration = ((PlanModelSequenceTransformer)this.getPlanModelTransformer()).getTimeSpanExpiration();
                long delay = -1L;
                if (timeSpanExpiration != null) {
                    delay = timeSpanExpiration.getTime() - newReferenceTime.getTime();
                }
                this.fTimespanUpdateJob = new TimespanUpdateJob();
                this.fTimespanUpdateJob.schedule(Math.max(Math.min(delay, 600000L), 60000L));
            }
        }
    }

    private void showMyLoad(boolean show) {
        boolean doShow;
        if (this.fProgressBarCanvas == null) {
            return;
        }
        this.fShowMyLoad = show;
        boolean bl = doShow = show && this.getLoadItem() != null;
        if (doShow != this.fProgressBarCanvas.isVisible() || doShow == ((GridData)this.fProgressBarCanvas.getLayoutData()).exclude) {
            this.fProgressBarCanvas.setVisible(doShow);
            ((GridData)this.fProgressBarCanvas.getLayoutData()).exclude = !doShow;
            this.fContainer.layout(true, true);
        } else if (doShow) {
            this.fProgressBarCanvas.redraw();
        }
    }

    private LoadItem getLoadItem() {
        return this.fMyLoadDevLine != null ? this.fLoadItems.get(this.fMyLoadDevLine) : null;
    }

    private void handleTimeSpansModeChanged(TimeSpansMode mode) {
        this.setPlanModeTransformer(this.getGroupMode().createModelTransformer(this));
    }

    public class ChooseDevelopmentLineAction
    extends Action {
        private final UUID fDevLineId;

        public ChooseDevelopmentLineAction(UUID devLineId) {
            super(null, 8);
            this.fDevLineId = devLineId;
            if (devLineId == null) {
                this.setText(Messages.SectionCurrentWork_LABEL_DISABLE);
            } else {
                IDevelopmentLine devLine = SectionCurrentWork.this.getPlan().getResolvedDevelopmentLine((IDevelopmentLineHandle)IDevelopmentLine.ITEM_TYPE.createItemHandle(devLineId, null));
                if (devLine != null) {
                    this.setText(devLine.getLabel());
                }
            }
            if (devLineId == null) {
                this.setChecked(!SectionCurrentWork.this.fShowMyLoad);
            } else {
                this.setChecked(devLineId.equals((Object)SectionCurrentWork.this.fMyLoadDevLine));
            }
        }

        public void run() {
            SectionCurrentWork.this.fMyLoadDevLine = this.fDevLineId;
            SectionCurrentWork.this.showMyLoad(this.fDevLineId != null);
            SectionCurrentWork.this.fProgressBarCanvas.redraw();
        }
    }

    public class EnableTempoAction
    extends Action {
        public EnableTempoAction() {
            super(Messages.SectionCurrentWork_MENU_TEMPO_ENABLE, 2);
            this.setEnabled(SectionCurrentWork.this.getPersonalPlanService().hasTempoLicense());
            this.setChecked(SectionCurrentWork.this.getPersonalPlanService().isTempoSimulationEnabled());
        }

        public void run() {
            SectionCurrentWork.this.getPersonalPlanService().setTempoSimulationEnabled(this.isChecked());
            SectionCurrentWork.this.getViewer().refresh();
        }
    }

    public class RunTempoSimulationAction
    extends Action {
        public RunTempoSimulationAction() {
            super(Messages.SectionCurrentWork_MENU_TEMPO_TRIGGER);
            this.setEnabled(SectionCurrentWork.this.getPersonalPlanService().isTempoSimulationEnabled() && SectionCurrentWork.this.getPersonalPlanService().hasTempoLicense());
        }

        public void run() {
            SectionCurrentWork.this.getPersonalPlanService().triggerTempoSimulation();
        }
    }

    public class ShowTempoColorsAction
    extends Action {
        public ShowTempoColorsAction() {
            super(Messages.SectionCurrentWork_MENU_TEMPO_COLORIZE, 2);
            this.setEnabled(SectionCurrentWork.this.getPersonalPlanService().isTempoSimulationEnabled() && SectionCurrentWork.this.getPersonalPlanService().hasTempoLicense());
            this.setChecked(SectionCurrentWork.this.getPersonalPlanService().isShowTempoColorsEnabled());
        }

        public void run() {
            SectionCurrentWork.this.getPersonalPlanService().setShowTempoColorsEnabled(this.isChecked());
        }
    }

    private class TimespanUpdateJob
    extends Job {
        public TimespanUpdateJob() {
            super(Messages.SectionCurrentWork_JOB_UPDATE_PLAN_REFERENCE_TIME);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SectionCurrentWork.this.updateTimespans(true);
            return Status.OK_STATUS;
        }
    }
}

