/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.common.IOutlineSettingsListener;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkSettingChangeEvent;
import com.ibm.team.apt.internal.ide.ui.mywork.TimeSpansMode;
import com.ibm.team.foundation.common.util.IMemento;
import org.eclipse.core.runtime.ListenerList;

public abstract class MyWorkSettings
implements IMyWorkSettings {
    private final String TIMESPANS_MODE = "timespansMode";
    private final String DEFAULT_WORK_ITEM_TYPE = "defaultWorkItemType";
    private TimeSpansMode fTimeSpansMode = TimeSpansMode.Progressive;
    private String fDefaultWorkItemType;
    private final ListenerList fSettingListeners = new ListenerList(1);

    @Override
    public ItemMovePolicy getItemMovePolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TimeSpansMode getTimeSpansMode() {
        return this.fTimeSpansMode;
    }

    public void setTimeSpansMode(TimeSpansMode timeSpansMode) {
        if (this.fTimeSpansMode != timeSpansMode) {
            this.fTimeSpansMode = timeSpansMode;
            this.fireChangeEvent(new MyWorkSettingChangeEvent(MyWorkSettingChangeEvent.Property.TIMESPANS_MODE, (Object)this.fTimeSpansMode, new Object[0]));
        }
    }

    @Override
    public String getDefaultWorkItemType() {
        return this.fDefaultWorkItemType;
    }

    @Override
    public void setDefaultWorkItemType(String workItemType) {
        if (this.fDefaultWorkItemType == null && workItemType != null || !this.fDefaultWorkItemType.equals(workItemType)) {
            this.fDefaultWorkItemType = workItemType;
            this.fireChangeEvent(new MyWorkSettingChangeEvent(MyWorkSettingChangeEvent.Property.DEFAULT_WORK_ITEM_TYPE, (Object)this.fDefaultWorkItemType, new Object[0]));
        }
    }

    public void saveState(IMemento memento) {
        memento.putString("timespansMode", this.fTimeSpansMode.getId());
        if (this.fDefaultWorkItemType != null) {
            memento.putString("defaultWorkItemType", this.fDefaultWorkItemType);
        }
    }

    public void loadState(IMemento uiState) {
        String timeSpansModeString = uiState.getString("timespansMode");
        TimeSpansMode[] timeSpansModeArray = TimeSpansMode.values();
        int n = timeSpansModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSpansMode timeSpansMode = timeSpansModeArray[n2];
            if (timeSpansMode.getId().equals(timeSpansModeString)) {
                this.fTimeSpansMode = timeSpansMode;
                break;
            }
            ++n2;
        }
        this.fDefaultWorkItemType = uiState.getString("defaultWorkItemType");
        this.fireChangeEvent(new MyWorkSettingChangeEvent(MyWorkSettingChangeEvent.Property.REFRESH, null, new Object[0]));
    }

    @Override
    public void addSettingsChangeListener(IOutlineSettingsListener listener) {
        this.fSettingListeners.add((Object)listener);
    }

    @Override
    public void removeSettingsChangeListener(IOutlineSettingsListener listener) {
        this.fSettingListeners.remove((Object)listener);
    }

    private void fireChangeEvent(MyWorkSettingChangeEvent event) {
        Object[] listeners = this.fSettingListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IOutlineSettingsListener listener = (IOutlineSettingsListener)listeners[i];
            listener.settingChanged(event);
            ++i;
        }
    }

    private boolean readBoolean(IMemento memento, String key, boolean defaultValue) {
        String value = memento.getString(key);
        return value != null ? Boolean.valueOf(value) : defaultValue;
    }
}

