/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.common.PlanOutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.jface.ColorUtils;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.dashboard.ColorRegistry;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;

public class MyWorkResources
extends PlanOutlineResources {
    private Color fGroupStatusColor;
    private Color fTimespanGroupLineColor;
    private Color fTimespanGroupBackgroundColor;
    private Insets fMarginInsets;
    private int fGroupNodeSpacing;
    private int fPlanItemSpacing;
    private Color fCanvasBackground;
    private Font fSchedulingErrorFont;
    private Color fSchedulingErrorColor;
    private int fDurationLabelWidth;

    public MyWorkResources(Control control) {
        super(control);
        LocalResourceManager manager = this.getResourceManager();
        this.fGroupStatusColor = PlanningUIPlugin.getDefault().getDarkShadow();
        this.fSchedulingErrorFont = this.getTextFonts().getNormalFont();
        this.fSchedulingErrorColor = JazzResources.getColor((ResourceManager)manager, (ColorDescriptor)PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().getColorDescriptor("com.ibm.team.apt.ide.ui.ERROR"));
        ColorRegistry colorreg = ColorRegistry.getDefault();
        this.fCanvasBackground = JazzResources.getColor((ResourceManager)manager, (ColorDescriptor)colorreg.getColorDescriptor((Object)"TEAM_CENTRAL_BACKGROUND"));
        RGB timeSpanBackSourceRGB = JazzResources.getColor((String)"com.ibm.team.jface.itemview.GradientColor").getRGB();
        RGB timeSpanLineSourceRGB = JazzResources.getColor((String)"com.ibm.team.jface.itemview.OutlineColor").getRGB();
        RGB timeSpanBackRGB = ColorUtils.blend((RGB)timeSpanBackSourceRGB, (RGB)this.fCanvasBackground.getRGB(), (int)20);
        RGB timeSpanLineRGB = ColorUtils.blend((RGB)timeSpanLineSourceRGB, (RGB)this.fCanvasBackground.getRGB(), (int)30);
        this.fTimespanGroupBackgroundColor = JazzResources.getColor((ResourceManager)manager, (RGB)timeSpanBackRGB);
        this.fTimespanGroupLineColor = JazzResources.getColor((ResourceManager)manager, (RGB)timeSpanLineRGB);
        this.fGroupNodeSpacing = 0;
        this.fPlanItemSpacing = 0;
        this.fMarginInsets = new Insets(2, 2, 2, 4);
        TextLayout textLayout = this.getTextLayout();
        textLayout.setWidth(-1);
        textLayout.setText("0.0w");
        this.fDurationLabelWidth = textLayout.getBounds().width;
    }

    @Override
    protected void dispose() {
        super.dispose();
    }

    @Override
    public Image getWorkItemTypeImage(IWorkItemType type) {
        ImageDescriptor descriptor = WorkItemUI.getImageDescriptor((IWorkItemType)type);
        return JazzResources.getImageWithDefault((ResourceManager)this.getResourceManager(), (ImageDescriptor)descriptor);
    }

    public Color getBackgroundColor() {
        return this.fCanvasBackground;
    }

    @Override
    public Color getGroupStatusColor() {
        return this.fGroupStatusColor;
    }

    @Override
    public Font getGroupTextFont() {
        return this.getTextFonts().getNormalFont();
    }

    @Override
    public int getGroupNodeSpacing() {
        return this.fGroupNodeSpacing;
    }

    @Override
    public int getPlanItemSpacing() {
        return this.fPlanItemSpacing;
    }

    public int getTypePrioSpacing() {
        return 2;
    }

    public int getDurationLabelWidth() {
        return this.fDurationLabelWidth;
    }

    public int getSummaryDurationSpacing() {
        return 2;
    }

    public Color getTimespanGroupBackgroundColor() {
        return this.fTimespanGroupBackgroundColor;
    }

    public Color getTimespanGroupLineColor() {
        return this.fTimespanGroupLineColor;
    }

    public Font getSchedulingErrorFont() {
        return this.fSchedulingErrorFont;
    }

    public Color getSchedulingErrorColor() {
        return this.fSchedulingErrorColor;
    }

    public int getErrorTextSpacing() {
        return this.getFontMetrics().getLeading() * 3;
    }

    public int getFirstErrorSpacing() {
        return 2;
    }

    public int getSubsequentErrorSpacing() {
        return 3;
    }

    @Override
    public Insets getTreeNodeInsets() {
        return this.fMarginInsets;
    }

    @Override
    protected Color createTableGridColor() {
        return this.blend(18, 25, 50);
    }

    @Override
    protected Color createMarkerIdColumnColor() {
        ColorRegistry colorreg = ColorRegistry.getDefault();
        Color color = this.getResourceManager().createColor(colorreg.getColorDescriptor((Object)"TEAM_CENTRAL_BACKGROUND"));
        return this.getResourceManager().createColor(FormColors.blend((RGB)this.getSystemColor(22), (RGB)color.getRGB(), (int)60));
    }

    @Override
    protected DurationFormat createDurationFormat() {
        DurationFormat result = new DurationFormat(5);
        result.setUnspecifiedString("----");
        return result;
    }
}

