/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.jface.StructuredContentProvider;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.TimeSpansMode;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MyWorkPreferencesDialog
extends StatusDialog {
    private TimeSpansMode fTimeSpansMode;
    private final MyWorkSettings fSettings;

    public MyWorkPreferencesDialog(Shell parent, MyWorkSettings settings) {
        super(parent);
        this.fSettings = settings;
        this.setTitle(Messages.MyWorkPreferencesDialog_TITLE);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTimeSpansMode = this.fSettings.getTimeSpansMode();
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)result.getLayout();
        layout.numColumns = 1;
        Group displayGroup = new Group(result, 0);
        displayGroup.setText(Messages.MyWorkPreferencesDialog_LABEL_SETTINGS);
        displayGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        displayGroup.setLayout((Layout)new GridLayout(2, false));
        this.createTimeSpansSettings(displayGroup);
        Dialog.applyDialogFont((Control)result);
        result.pack(true);
        this.checkStatus();
        return result;
    }

    private void createTimeSpansSettings(Group displayGroup) {
        Label timeSpansLabel = new Label((Composite)displayGroup, 0);
        timeSpansLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        timeSpansLabel.setText(Messages.MyWorkPreferencesDialog_LABEL_GROUP_BY);
        Combo timeSpansCombo = new Combo((Composite)displayGroup, 8);
        timeSpansCombo.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ComboViewer timeSpansComboViewer = new ComboViewer(timeSpansCombo);
        timeSpansComboViewer.setContentProvider((IContentProvider)new StructuredContentProvider(){

            @Override
            public Object[] getElements(Object inputElement) {
                return TimeSpansMode.values();
            }
        });
        timeSpansComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((TimeSpansMode)((Object)element)).getLabel();
            }
        });
        timeSpansComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() >= 1) {
                    MyWorkPreferencesDialog.this.fTimeSpansMode = (TimeSpansMode)((Object)selection.getFirstElement());
                }
                MyWorkPreferencesDialog.this.checkStatus();
            }
        });
        timeSpansComboViewer.setInput(TimeSpansMode.class);
        timeSpansComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.fTimeSpansMode));
    }

    protected void okPressed() {
        super.okPressed();
        this.fSettings.setTimeSpansMode(this.fTimeSpansMode);
    }

    private void checkStatus() {
        this.updateStatus(Status.OK_STATUS);
    }
}

