/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.EstimateMode;
import com.ibm.team.apt.internal.client.IPlanningAttribute;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.AttributeUtils;
import com.ibm.team.apt.internal.ide.ui.common.gadgets.GFadeableTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.IColumnBasedGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.GColumnBox;
import com.ibm.team.apt.internal.ide.ui.mywork.GExpandableTreeNode;
import com.ibm.team.apt.internal.ide.ui.mywork.GMyWorkDuration;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkItemGadget;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GButton;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GImage;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GLabel;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GText;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.TextFonts;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class MyWorkItemNodeContent
extends GFadeableTreeNodeContent
implements IColumnBasedGadget {
    private static final String[] LABEL_PROPERTIES = new String[]{PlanItem.DIRTY.getId(), PlanItem.ITEM_TYPE.getId(), PlanItem.PRIORITY.getId(), PlanItem.SUMMARY.getId(), PlanItem.ID.getId(), PlanItem.ESTIMATE.getId(), PlanItem.DURATION.getId(), PlanItem.MINIMAL_ESTIMATE.getId(), PlanItem.MAXIMAL_ESTIMATE.getId(), PlanItem.ORIGINAL_ESTIMATE.getId(), PlanItem.CORRECTED_ESTIMATE.getId(), PlanItem.TIMESPENT.getId(), PlanItem.DUE_DATE.getId(), PlanItem.MARKED_READ.getId(), PlanItem.DRAFT_ITEM.getId(), PlanItem.STATE.getId(), PlanItem.PLANCHECK_REPORT.getId()};
    private PlanItem fPlanItem;
    private GImage fTypeImage;
    private GButton fImportanceGadget;
    private GText fSummary;
    private GMyWorkDuration fEstimateControl;
    private GColumnBox fPlanningControls;

    static {
        Arrays.sort(LABEL_PROPERTIES);
    }

    public MyWorkItemNodeContent(MyWorkItemGadget parent, PlanItem planItem) {
        super(parent);
        this.fPlanItem = planItem;
        MyWorkResources resources = this.getTimelineResources();
        Image workItemImage = resources.getWorkItemLabelProvider().getImage((Object)planItem.getWorkItem(false));
        this.fTypeImage = new GImage(this, workItemImage);
        IPlanningAttribute importanceAttribute = this.fPlanItem.getPlan().findAttribute(PlanItem.PRIORITY);
        Image importanceImage = AttributeUtils.getIcon(planItem, importanceAttribute, (OutlineResources)resources);
        this.fImportanceGadget = new GButton(this, importanceImage, 1024);
        this.fImportanceGadget.setAction((IAction)new AttributeUtils.AttributeValueSetDropDownAction(planItem, importanceAttribute, resources));
        this.fEstimateControl = new GMyWorkDuration((CompositeGadget)this, planItem, PlanItem.ESTIMATE);
        this.fEstimateControl.setLabelWidth(resources.getDurationLabelWidth());
        TextFonts fonts = resources.getTextFonts();
        Font summaryFont = planItem.isMarkedRead() ? fonts.getNormalFont() : fonts.getBoldFont();
        this.fSummary = new GText(this, resources.isSingleClickMode() ? 2048 : 0);
        this.fSummary.setFont(summaryFont);
        this.fSummary.setColor(resources.getSummaryColor());
        this.fSummary.setText(planItem.getHTMLSummary().getPlainText());
        this.fPlanningControls = new GColumnBox(this);
        this.fPlanningControls.setHorizontalSpacing(15);
        this.contributeToPlanningControls(this.fPlanningControls);
    }

    @Override
    public Object getElement() {
        return this.fPlanItem;
    }

    public GText getSummary() {
        return this.fSummary;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnId(int index) {
        Assert.isLegal((index == 0 ? 1 : 0) != 0);
        return "xxx.internal.problem.summary";
    }

    @Override
    public int getColumnWidth(int index) {
        Assert.isLegal((index == 0 ? 1 : 0) != 0);
        return this.computeMinimalWidth();
    }

    @Override
    public int computeMinimalWidth() {
        MyWorkResources resources = this.getTimelineResources();
        int image = this.fTypeImage.computeMinimalWidth();
        int priority = this.fImportanceGadget.computeMinimalWidth();
        int summary = this.fSummary.computeMinimalWidth();
        int estimate = resources.getSummaryDurationSpacing() + this.fEstimateControl.computeMinimalWidth();
        int summaryIndent = image + resources.getTypePrioSpacing() + priority + resources.getIconSummarySpacing();
        int planningControls = 0;
        if (this.showPlanningDetails()) {
            planningControls = summaryIndent + this.fPlanningControls.computeMinimalWidth();
        }
        return this.max(summaryIndent + summary + estimate, summaryIndent + planningControls);
    }

    @Override
    protected Point arrangeContent(int x, int y, int wHint, int hHint) {
        int planningControlsWidth = 0;
        int startY = y;
        MyWorkResources resources = this.getTimelineResources();
        boolean showPlanningDetails = this.showPlanningDetails();
        this.fTypeImage.layout(x, y, -1, -1);
        int tx = x + this.fTypeImage.getWidth() + resources.getTypePrioSpacing();
        this.fImportanceGadget.layout(tx, y, -1, -1);
        int tWidth = wHint;
        this.fEstimateControl.layout(x, y, -1, -1);
        int estimateWidth = this.fEstimateControl.getWidth() + resources.getSummaryDurationSpacing();
        this.fEstimateControl.move(wHint - this.fEstimateControl.getWidth(), 0);
        int maxSummaryWidth = tWidth - ((tx += this.fImportanceGadget.getWidth() + resources.getIconSummarySpacing()) - x) - estimateWidth;
        if (this.fSummary.computeMaximumWidth() > maxSummaryWidth) {
            this.fSummary.layout(tx, y, maxSummaryWidth, -1);
        } else {
            this.fSummary.layout(tx, y, -1, -1);
        }
        this.fSummary.setMaximumWidth(maxSummaryWidth);
        tWidth -= this.getImageWhiteSpace();
        x += this.getImageWhiteSpace();
        int summaryIndent = this.fTypeImage.getWidth() + resources.getTypePrioSpacing() + this.fImportanceGadget.getWidth() + resources.getIconSummarySpacing();
        y += this.max(this.fTypeImage.getHeight(), this.fSummary.getHeight());
        this.fPlanningControls.setExclude(!showPlanningDetails);
        if (showPlanningDetails) {
            this.fPlanningControls.layout(tx, y += resources.getDescriptionSpacing(), tWidth - summaryIndent, -1);
            y += this.fPlanningControls.getHeight();
            planningControlsWidth = this.fPlanningControls.getWidth();
            y += resources.getStatusSpacing();
        }
        int width = this.max(wHint, summaryIndent + this.fSummary.getWidth() + estimateWidth, summaryIndent + planningControlsWidth);
        return new Point(width, y - startY);
    }

    @Override
    protected Point relayout(int x, int y, int deltaWidth, int deltaHeight, Gadget changedChild) {
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        if (changedChild == this.fSummary) {
            height += deltaHeight;
            if (!this.fPlanningControls.isExcluded()) {
                this.fPlanningControls.move(0, deltaHeight);
            }
        }
        return new Point(width, height);
    }

    private MyWorkResources getTimelineResources() {
        return (MyWorkResources)this.getOutlineResources();
    }

    private IMyWorkSettings getMyWorkSettings() {
        return ((MyWorkCanvas)this.getOutline()).getSettings();
    }

    private int getImageWhiteSpace() {
        return 2;
    }

    @Override
    protected int getAlphaValue() {
        return this.fPlanItem.isResolved() ? 120 : 255;
    }

    @Override
    protected Color getBackgroundColor() {
        return this.getOutline().getBackground();
    }

    @Override
    public boolean isLabelProperty(String property) {
        return Arrays.binarySearch(LABEL_PROPERTIES, property) >= 0;
    }

    protected void contributeToPlanningControls(GColumnBox planningBox) {
        if (this.getMyWorkSettings().isTempoEnabled()) {
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_MINIMAL, 0);
            new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, PlanItem.MINIMAL_ESTIMATE);
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_NOMINAL, 0);
            new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, PlanItem.ORIGINAL_ESTIMATE);
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_MAXIMAL, 0);
            new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, PlanItem.MAXIMAL_ESTIMATE);
        } else if (this.fPlanItem.isEstimateCorrected()) {
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_LABEL_ESTIMATE_ORIGINAL, 0);
            GMyWorkDuration originalEstimate = new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, PlanItem.ORIGINAL_ESTIMATE);
            originalEstimate.setAction(null);
        } else {
            new GLabel(this.fPlanningControls, Messages.MyWorkItemNodeContent_LABEL_ESTIMATE_CORRECTED, 0);
            new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, PlanItem.CORRECTED_ESTIMATE);
        }
        ResolvedPersonalPlan plan = (ResolvedPersonalPlan)this.fPlanItem.getPlan();
        EstimateMode mode = plan.getDurationSupport().getEstimateMode();
        new GLabel(this.fPlanningControls, mode.getDisplayName(), 0);
        new GMyWorkDuration((CompositeGadget)this.fPlanningControls, this.fPlanItem, PlanItem.EFFORT);
    }

    protected boolean isExpanded() {
        return ((GExpandableTreeNode)this.getParent()).isShowDetails();
    }

    protected boolean showPlanningDetails() {
        return this.isExpanded();
    }

    protected boolean isEditable() {
        return ((GExpandableTreeNode)this.getParent()).isSelected();
    }
}

