/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.common.PlanCanvas;
import com.ibm.team.apt.internal.ide.ui.mywork.IMyWorkSettings;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Insets;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Outline;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineDropTargetEffect;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineResources;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.RootItem;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MyWorkCanvas
extends PlanCanvas {
    private boolean fIsDndActive;
    private CurrentItemProvider fCurrentItemProvider;
    private int fCachedMaxHeight;
    private final ListenerList fInterceptionKeyListeners = new ListenerList();

    public MyWorkCanvas(Composite parent, int style, IMyWorkSettings settings) {
        super(parent, style | 0x200, settings);
        this.setBackground(this.getTimelineResources().getBackgroundColor());
        OutlineDropTargetEffect dropEffect = new OutlineDropTargetEffect(this){

            @Override
            public void dragEnter(DropTargetEvent event) {
                MyWorkCanvas.this.fIsDndActive = true;
                super.dragEnter(event);
            }

            @Override
            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                MyWorkCanvas.this.fIsDndActive = false;
            }
        };
        dropEffect.setScrollZone(10, 5);
        this.setData("DEFAULT_DROP_TARGET_EFFECT", (Object)dropEffect);
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                event.doit = true;
                if (MyWorkCanvas.this.fLastSelectedItem == null && MyWorkCanvas.this.getItemCount() > 0) {
                    MyWorkCanvas.this.setSelectionByUserInteraction(MyWorkCanvas.this.getItem(0), Outline.SelectionMode.SINGLE, null);
                }
            }
        });
    }

    public MyWorkResources getTimelineResources() {
        return (MyWorkResources)this.getOutlineResources();
    }

    public boolean isDndActive() {
        return this.fIsDndActive;
    }

    @Override
    public IMyWorkSettings getSettings() {
        return (IMyWorkSettings)super.getSettings();
    }

    public void addInterceptingKeyListener(InterceptingKeyListener listener) {
        this.fInterceptionKeyListeners.add((Object)listener);
    }

    public void removeInterceptingKeyListener(InterceptingKeyListener listener) {
        this.fInterceptionKeyListeners.remove((Object)listener);
    }

    public void setCurrentItemProvider(CurrentItemProvider topItemProvider) {
        this.fCurrentItemProvider = topItemProvider;
    }

    @Override
    protected void handleDisposed(DisposeEvent e) {
        super.handleDisposed(e);
    }

    @Override
    protected OutlineItem createRootItem() {
        return new RootItem(this, 0){
            private Insets fInsets;

            @Override
            protected Insets getInsets() {
                if (this.fInsets == null) {
                    this.fInsets = new Insets(0, 0, 0, 0);
                }
                return this.fInsets;
            }
        };
    }

    @Override
    protected OutlineResources createOutlineResource() {
        return new MyWorkResources((Control)this);
    }

    @Override
    protected int getMaximalHeight() {
        int height = this.getRootItem().getHeight();
        if (this.fCurrentItemProvider != null) {
            int currentHeight = this.fCachedMaxHeight;
            OutlineItem currentItem = this.fCurrentItemProvider.getCurrentItem();
            if (currentItem != null && !currentItem.isDisposed() && currentItem.isLayouted()) {
                currentHeight = this.getClientArea().height + currentItem.getBounds().y;
            }
            height = Math.max(height, currentHeight);
        }
        this.fCachedMaxHeight = height;
        return this.fCachedMaxHeight;
    }

    @Override
    protected void doKeyPressed(KeyEvent e) {
        boolean isHandled = false;
        Object[] listeners = this.fInterceptionKeyListeners.getListeners();
        int i = 0;
        while (!isHandled && i < listeners.length) {
            isHandled |= ((InterceptingKeyListener)listeners[i]).keyPressed(e);
            ++i;
        }
        if (!isHandled) {
            super.doKeyPressed(e);
        }
    }

    public static interface CurrentItemProvider {
        public OutlineItem getCurrentItem();
    }

    public static interface InterceptingKeyListener {
        public boolean keyPressed(KeyEvent var1);
    }
}

