/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.actions.RetargetAction;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.QuickQueryBar;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractPlanSection;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class MyWorkActionContributor {
    private final IViewSite fViewSite;
    private final QuickQueryBar fQuickQueryBar;
    private final List<RetargetAction> fActions = new ArrayList<RetargetAction>();
    private AbstractPlanSection fActiveSection;
    private List<IHandlerActivation> fHandlerActivations = new ArrayList<IHandlerActivation>();
    private IContextActivation fContextActivation;
    private RetargetAction fAddBelow;
    private RetargetAction fMoveUpAction;
    private RetargetAction fMoveDownAction;
    private RetargetAction fSelectAllAction;
    private RetargetAction fFindAction;
    private RetargetAction fFindNextAction;
    private RetargetAction fFindPreviousAction;
    private RetargetAction fQuickFilter;
    private RetargetAction fQuickColorize;
    private RetargetAction fQuickColorizeColor;
    private RetargetAction fExpandPlanningTools;
    private RetargetAction fShowDetails;
    private RetargetAction fShowNews;
    private RetargetAction fAddToMyPlan;

    public MyWorkActionContributor(IViewSite viewSite, QuickQueryBar quickQueryBar) {
        this.fViewSite = viewSite;
        this.fQuickQueryBar = quickQueryBar;
        this.fAddBelow = new RetargetAction(Messages.MyWorkActionContributor_ADD_TASK_BELOW, ImagePool.ITEM_ADD_BELOW_DISABLED, "com.ibm.team.apt.actions.iterationPlan.add.below");
        this.fActions.add(this.fAddBelow);
        this.fMoveUpAction = new RetargetAction(Messages.MyWorkActionContributor_MOVE_ITEM_UP, ImagePool.ITEM_MOVE_UP_DISABLED, "com.ibm.team.apt.actions.iterationPlan.move.up");
        this.fActions.add(this.fMoveUpAction);
        this.fMoveDownAction = new RetargetAction(Messages.MyWorkActionContributor_MOVE_ITEM_DOWN, ImagePool.ITEM_MOVE_DOWN_DISABLED, "com.ibm.team.apt.actions.iterationPlan.move.down");
        this.fActions.add(this.fMoveDownAction);
        this.fSelectAllAction = new RetargetAction(Messages.MyWorkActionContributor_SELECT_ALL, null, ActionFactory.SELECT_ALL.getId());
        this.fActions.add(this.fSelectAllAction);
        this.fExpandPlanningTools = new RetargetAction(Messages.MyWorkActionContributor_EXPAND_PLANNING_TOOLS, ImagePool.ITEM_ADD_ABOVE_DISABLED, "com.ibm.team.apt.actions.myWork.expandPlanningTools");
        this.fActions.add(this.fExpandPlanningTools);
        this.fShowDetails = new RetargetAction(Messages.MyWorkActionContributor_SHOW_DETAILS, ImagePool.QUICKFILTER_FILTER, "com.ibm.team.apt.actions.myWork.showDetails");
        this.fActions.add(this.fShowDetails);
        this.fShowNews = new RetargetAction(Messages.MyWorkActionContributor_SHOW_NEWS, ImagePool.QUICKFILTER_FILTER, "com.ibm.team.apt.actions.myWork.showNews");
        this.fActions.add(this.fShowNews);
        this.fAddToMyPlan = new RetargetAction(Messages.MyWorkActionContributor_ACCEPT_WORK, ImagePool.QUICKFILTER_FILTER, "com.ibm.team.apt.actions.myWork.acceptWork");
        this.fActions.add(this.fAddToMyPlan);
        this.fFindAction = new RetargetAction(Messages.MyWorkActionContributor_FIND, ImagePool.QUICKFILTER_FIND, ActionFactory.FIND.getId());
        this.fActions.add(this.fFindAction);
        this.fFindNextAction = new RetargetAction(Messages.MyWorkActionContributor_FIND_NEXT, ImagePool.QUICKFILTER_FIND_NEXT, ActionFactory.NEXT.getId());
        this.fActions.add(this.fFindNextAction);
        this.fFindPreviousAction = new RetargetAction(Messages.MyWorkActionContributor_FIND_PREVIOUS, ImagePool.QUICKFILTER_FIND_PREVIOUS, ActionFactory.PREVIOUS.getId());
        this.fActions.add(this.fFindPreviousAction);
        this.fQuickFilter = new RetargetAction(Messages.MyWorkActionContributor_QUICK_FILTER, ImagePool.QUICKFILTER_FILTER, "com.ibm.team.apt.actions.quickquery.filter");
        this.fActions.add(this.fQuickFilter);
        this.fQuickColorize = new RetargetAction(Messages.MyWorkActionContributor_QUICK_COLORIZE, ImagePool.QUICKFILTER_COLORIZE, "com.ibm.team.apt.actions.quickquery.colorize");
        this.fActions.add(this.fQuickColorize);
        this.fQuickColorizeColor = new RetargetAction(Messages.MyWorkActionContributor_QUICK_COLORIZE_COLOR, null, "com.ibm.team.apt.actions.quickquery.colorize.color");
        this.fActions.add(this.fQuickColorizeColor);
    }

    public void contributeToActionBar() {
        IActionBars actionBars = this.fViewSite.getActionBars();
        for (RetargetAction action : this.fActions) {
            actionBars.setGlobalActionHandler(action.getId(), (IAction)action);
        }
        actionBars.updateActionBars();
    }

    public synchronized void setActiveSection(AbstractPlanSection section) {
        this.fActiveSection = section;
    }

    public synchronized void refresh(AbstractPlanSection section) {
        if (this.fActiveSection != section) {
            return;
        }
        this.bindActions();
    }

    public void dispose() {
        this.deactivateHandlers();
        this.deactivateContext();
    }

    private void deactivateHandlers() {
        this.getService(IHandlerService.class).deactivateHandlers(this.fHandlerActivations);
        this.fHandlerActivations.clear();
    }

    private void deactivateContext() {
        if (this.fContextActivation == null) {
            return;
        }
        this.getService(IContextService.class).deactivateContext(this.fContextActivation);
        this.fContextActivation = null;
    }

    private void bindActions() {
        this.deactivateHandlers();
        String contextId = this.fActiveSection.getContextId();
        if (this.fContextActivation != null && !this.fContextActivation.getContextId().equals(contextId)) {
            this.deactivateContext();
        }
        if (this.fContextActivation == null && contextId != null) {
            this.fContextActivation = this.getService(IContextService.class).activateContext(contextId);
        }
        this.bindActions(this.fActions);
    }

    private void bindActions(Collection<RetargetAction> actions) {
        IHandlerService handlerService = this.getService(IHandlerService.class);
        for (RetargetAction action : actions) {
            Action handler = this.getAction(action.getId());
            if (handler != null) {
                action.setHandler((IAction)handler);
                IHandlerActivation activation = handlerService.activateHandler(action.getId(), (IHandler)new ActionHandler((IAction)handler));
                this.fHandlerActivations.add(activation);
                continue;
            }
            action.setHandler(null);
        }
    }

    private Action getAction(String id) {
        Action action = this.fActiveSection.getAction(id);
        if (action == null) {
            action = this.fQuickQueryBar.getAction(id);
        }
        return action;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)this.fViewSite.getActionBars().getServiceLocator().getService(clazz);
    }
}

