/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.common.MessageElement;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.structure.AbstractJavaPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModel;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdateFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelUpdater;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;

public class GroupByMyWorkChangesDescription
extends GroupByDescription {
    private static final List<SortMode> DEFAULT_SORT_MODES = Collections.unmodifiableList(Arrays.asList(SortMode.PRIORITY, SortMode.MODIFIED_DATE));
    public static final String ID = "MYWORK_NEWLYASSIGNED";

    public GroupByMyWorkChangesDescription() {
        super(ID, Messages.GroupByMyWorkChangesDescription_LABEL);
    }

    @Override
    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        return new NewlyAssignedTransformer();
    }

    @Override
    protected ItemMovePolicy createItemMovePolicy() {
        return new ItemMovePolicy(){};
    }

    @Override
    public PartialViewerSorter createSorter() {
        return new PartialViewerSorter(true);
    }

    @Override
    public List<SortMode> getSortModes() {
        return DEFAULT_SORT_MODES;
    }

    @Override
    public SortMode getDefaultSortMode() {
        return SortMode.PRIORITY;
    }

    private static class NewlyAssignedTransformer
    extends AbstractJavaPlanModelTransformer {
        private final MessageElement fNoNewWorkMessage = new MessageElement(Messages.GroupByMyWorkChangesDescription_MSG_NO_WORK);
        private final NoNewWorkMessageManager fNoNewWorkMessageManager = new NoNewWorkMessageManager();
        private IViewModel.IPostUpdateRunnerHandle fNoNewWorkMessageManagerToken;

        public NewlyAssignedTransformer() {
            super(Collections.EMPTY_LIST);
        }

        @Override
        public void inputChanged(IViewModel newModel, Object newInput) {
            PlanViewModel oldModel = this.getViewModel();
            if (oldModel != null) {
                Assert.isNotNull((Object)this.fNoNewWorkMessageManagerToken);
                oldModel.removePostUpdateRunnable(this.fNoNewWorkMessageManagerToken);
                this.fNoNewWorkMessageManagerToken = null;
            }
            if (newModel != null) {
                Assert.isTrue((this.fNoNewWorkMessageManagerToken == null ? 1 : 0) != 0);
                this.fNoNewWorkMessageManagerToken = newModel.addPostUpdateRunnable((IViewModelUpdateFunction)this.fNoNewWorkMessageManager, true);
            }
            super.inputChanged(newModel, newInput);
        }

        @Override
        protected boolean isElementIncluded(PlanElement element) {
            return super.isElementIncluded(element) && element instanceof PlanItem && ((PlanItem)element).isNewItem() && !((PlanItem)element).isAuxiliaryPlanItem();
        }

        private class NoNewWorkMessageManager
        implements IViewModelUpdateFunction<Void, RuntimeException> {
            private NoNewWorkMessageManager() {
            }

            public Void run(IViewModelUpdater updateAccessor) {
                IViewEntry rootEntry = updateAccessor.getRootEntry(IViewModel.Domain.Content);
                if (rootEntry != null) {
                    IViewEntry messageEntry = this.getFirstEntry(updateAccessor.getElementEntries((Object)NewlyAssignedTransformer.this.fNoNewWorkMessage));
                    List entries = updateAccessor.getChildren(rootEntry);
                    if (entries.size() > 1 && messageEntry != null) {
                        updateAccessor.removeEntry(messageEntry);
                    } else if (entries.size() == 0) {
                        updateAccessor.addEntry(IViewModel.Domain.Content, EMPTY_PATH, (Object)NewlyAssignedTransformer.this.fNoNewWorkMessage);
                    }
                }
                return null;
            }

            private <T> IViewEntry<T> getFirstEntry(Collection<IViewEntry<T>> entries) {
                Iterator<IViewEntry<T>> iterator = entries.iterator();
                return iterator.hasNext() ? iterator.next() : null;
            }
        }
    }
}

