/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.IPlanItemAttributeSetter;
import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPlan;
import com.ibm.team.apt.internal.common.util.ItemList;
import com.ibm.team.apt.internal.common.util.ItemSet;
import com.ibm.team.apt.internal.common.util.IterationHierarchy;
import com.ibm.team.apt.internal.ide.ui.common.DropTarget;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.common.structure.AbstractJavaPlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupByDescription;
import com.ibm.team.apt.internal.ide.ui.common.structure.GroupElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.ItemMovePolicy;
import com.ibm.team.apt.internal.ide.ui.common.structure.IterationElement;
import com.ibm.team.apt.internal.ide.ui.common.structure.PartialViewerSorter;
import com.ibm.team.apt.internal.ide.ui.common.structure.PlanModelTransformer;
import com.ibm.team.apt.internal.ide.ui.common.structure.SortMode;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReadFunction;
import com.ibm.team.rtc.foundation.api.ui.model.IViewModelReader;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class GroupByMyFuturePastWorkDescription
extends GroupByDescription {
    private static final List<SortMode> DEFAULT_SORT_MODES = Collections.unmodifiableList(Arrays.asList(SortMode.PRIORITY, SortMode.MODIFIED_DATE));
    public static final String ID = "TARGET";

    public GroupByMyFuturePastWorkDescription() {
        super(ID, Messages.GroupByMyFuturePastWorkDescription_LABEL);
    }

    @Override
    public PlanModelTransformer createModelTransformer(IAdaptable options) {
        return new IntervalGroupingTransformer();
    }

    @Override
    protected ItemMovePolicy createItemMovePolicy() {
        return new IterationGroupingItemMovePolicy();
    }

    @Override
    public PartialViewerSorter createSorter() {
        return new OpenClosedViewerSorter();
    }

    @Override
    public List<SortMode> getSortModes() {
        return DEFAULT_SORT_MODES;
    }

    @Override
    public SortMode getDefaultSortMode() {
        return SortMode.PRIORITY;
    }

    private static class IntervalGroupingTransformer
    extends AbstractJavaPlanModelTransformer {
        private ItemSet<IIteration> fPlannedIntervals;

        public IntervalGroupingTransformer() {
            super(Collections.singleton(PlanItem.TARGET));
        }

        @Override
        protected void onBeginRefresh() {
            ResolvedPlan plan = this.getPlan();
            this.fPlannedIntervals = plan != null ? plan.getPlannedIterations() : null;
            super.onBeginRefresh();
        }

        @Override
        protected Collection<GroupElement[]> getGroups(List<AbstractJavaPlanModelTransformer.ElementInfo> elementInfoPath) {
            Assert.isTrue((elementInfoPath.size() == 1 ? 1 : 0) != 0);
            Object[] structureValues = elementInfoPath.get(0).getStructureValues();
            Assert.isLegal((structureValues.length == 1 ? 1 : 0) != 0);
            Assert.isLegal((structureValues[0] == null || structureValues[0] instanceof IIteration ? 1 : 0) != 0);
            IterationElement group = new IterationElement((IIteration)structureValues[0]);
            return Collections.singleton(new GroupElement[]{group});
        }

        @Override
        protected boolean isElementIncluded(PlanElement element) {
            if (!super.isElementIncluded(element) || !(element instanceof PlanItem)) {
                return false;
            }
            IIteration target = ((PlanItem)element).getTarget();
            return (target == null || this.fPlannedIntervals != null && !this.fPlannedIntervals.contains((Object)target)) && !((PlanItem)element).isNewItem() && !((PlanItem)element).isAuxiliaryPlanItem();
        }
    }

    private static class IterationGroupingItemMovePolicy
    extends ItemMovePolicy {
        private IterationGroupingItemMovePolicy() {
        }

        @Override
        public ItemMovePolicy.DropLocation validateDrop(IStructuredSelection sourceSelection, DropTarget dropTarget) {
            ItemMovePolicy.DropLocation result = ItemMovePolicy.DropLocation.None;
            boolean hasValidAdoptions = false;
            Object target = dropTarget.getTargetEntry().getElement();
            IIteration targetIteration = null;
            if (target instanceof IterationElement) {
                result = ItemMovePolicy.DropLocation.OntoUnderlayChildern;
                targetIteration = ((IterationElement)target).getIteration();
            } else if (target instanceof PlanItem) {
                result = ItemMovePolicy.DropLocation.OntoParent;
                targetIteration = ((PlanItem)target).getTarget();
            }
            if (result != ItemMovePolicy.DropLocation.None) {
                Object[] objectArray = sourceSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object source = objectArray[n2];
                    if (this.isIncompatibleProjectArea(source, dropTarget.getTargetEntry())) {
                        result = ItemMovePolicy.DropLocation.None;
                    } else if (source instanceof IWorkItemHandle) {
                        ResolvedPlan plan;
                        IWorkItem resolvedWorkItem;
                        if (!(source instanceof IWorkItem) && (resolvedWorkItem = (plan = this.getPlan(dropTarget.getTargetEntry())).getResolvedWorkItem((IWorkItemHandle)source)) != null) {
                            source = resolvedWorkItem;
                        }
                        if (source instanceof IWorkItem) {
                            IWorkItem workItem = (IWorkItem)source;
                            plan = this.getPlan(dropTarget.getTargetEntry());
                            if (this.isClosed(workItem, plan)) {
                                result = ItemMovePolicy.DropLocation.None;
                            } else if (!workItem.isPropertySet(IWorkItem.TARGET_PROPERTY)) {
                                hasValidAdoptions = true;
                            } else if (targetIteration != null && !targetIteration.sameItemId((IItemHandle)workItem.getTarget())) {
                                hasValidAdoptions = true;
                            } else if (targetIteration == null && workItem.getTarget() != null) {
                                hasValidAdoptions = true;
                            } else {
                                PlanItem planItem = plan.getPlanItem((IWorkItemHandle)workItem);
                                if (planItem != null && planItem.isNewItem()) {
                                    hasValidAdoptions = true;
                                }
                            }
                        } else {
                            hasValidAdoptions = true;
                        }
                    }
                    if (result == ItemMovePolicy.DropLocation.None) break;
                    ++n2;
                }
            }
            return hasValidAdoptions ? result : ItemMovePolicy.DropLocation.None;
        }

        private boolean isClosed(IWorkItem workItem, ResolvedPlan plan) {
            if (workItem.isPropertySet(IWorkItem.PROJECT_AREA_PROPERTY) && plan.getProjectAreaHandle().sameItemId((IItemHandle)workItem.getProjectArea())) {
                return plan.getCombinedWorkflowInfos().getStateGroup(workItem.getState2()) == 2;
            }
            return false;
        }

        @Override
        public boolean drop(IStructuredSelection sourceSelection, DropTarget dropTarget, IProgressService progressService) {
            final IViewEntry<?> targetEntry = dropTarget.getTargetEntry();
            final IViewEntry groupEntry = (IViewEntry)targetEntry.getModel().readModel((IViewModelReadFunction)new IViewModelReadFunction<IViewEntry<GroupElement>, RuntimeException>(){

                public IViewEntry<GroupElement> run(IViewModelReader readAccessor) throws RuntimeException {
                    return readAccessor.getEntryNavigator(true).parentEntryOfType(targetEntry, GroupElement.class);
                }
            });
            boolean result = this.doResolveAndDrop(sourceSelection, new IPlanItemAttributeSetter(){

                public String getWorkItemTypeIdentifier() {
                    return null;
                }

                public void setAttributes(PlanItem planItem, IProgressMonitor monitor) throws TeamRepositoryException {
                    monitor.beginTask("", 1);
                    try {
                        if (!planItem.isResolved() && groupEntry != null) {
                            ((GroupElement)groupEntry.getElement()).adopt((PlanElement)planItem, (IViewEntry<? extends GroupElement>)groupEntry, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }, (PlanViewModel)targetEntry.getModel(), dropTarget.getEvent(), progressService);
            if (result && groupEntry != null) {
                this.doSelect(sourceSelection, (IViewEntry<GroupElement>)groupEntry);
            }
            return result;
        }

        @Override
        protected void itemAdded(PlanItem newPlanItem, OutlineItem newOutlineItem) {
            if (newOutlineItem instanceof MyWorkOutlineItem) {
                ((MyWorkOutlineItem)newOutlineItem).setShowDetails(true);
            }
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            WorkItemUI.open((IWorkbenchPage)activePage, (Object)newPlanItem.getWorkItemHandle());
        }
    }

    private static class OpenClosedViewerSorter
    extends PartialViewerSorter {
        private static final PartialViewerSorter.ElementComparer<PlanItem> fOpenClosedComparator = new PartialViewerSorter.ElementComparer<PlanItem>(PlanItem.class){

            @Override
            public int compare(PlanItem o1, PlanItem o2) {
                return (o1.isResolved() ? 1 : 0) - (o2.isResolved() ? 1 : 0);
            }
        };

        public OpenClosedViewerSorter() {
            super(true);
            super.setItemComparator(null);
        }

        @Override
        public void setItemComparator(PartialViewerSorter.ElementComparer<?> comparator) {
            super.setItemComparator(comparator == null ? fOpenClosedComparator : new PartialViewerSorter.CompositeElementComparer(Arrays.asList(fOpenClosedComparator, comparator)));
        }

        @Override
        public <T> int compare(int category, IViewEntry<T> e1, IViewEntry<T> e2, IViewModelReader readAccessor) {
            if (EntryUtils.isType(e1, IterationElement.class) && EntryUtils.isType(e2, IterationElement.class)) {
                ResolvedPlan plan = ((PlanViewModel)e1.getModel()).getInput();
                IIteration i1 = ((IterationElement)e1.getElement()).getIteration();
                IIteration i2 = ((IterationElement)e2.getElement()).getIteration();
                if (i1 == null || i2 == null) {
                    return (i1 == null ? 1 : 0) - (i2 == null ? 1 : 0);
                }
                if (i1.getDevelopmentLine().sameItemId((IItemHandle)i2.getDevelopmentLine())) {
                    IterationHierarchy iterationHierarchy = plan.getDevelopmentLineIterationHierarchy(i1.getDevelopmentLine());
                    ArrayList<ItemList> iterations = new ArrayList<ItemList>();
                    iterations.add(iterationHierarchy.getAllPastIterations());
                    iterations.add(iterationHierarchy.getAllCurrentIterations());
                    iterations.add(iterationHierarchy.getAllFutureIterations());
                    for (ItemList sortedIterations : iterations) {
                        int index1 = sortedIterations.indexOf((Object)i1);
                        int index2 = sortedIterations.indexOf((Object)i2);
                        if (index1 == -1 && index2 == -1) continue;
                        if (index1 != -1 && index2 != -1) {
                            return index1 - index2;
                        }
                        return (index1 != -1 ? 0 : 1) - (index2 != -1 ? 0 : 1);
                    }
                } else {
                    IDevelopmentLine dl1 = plan.getResolvedDevelopmentLine(i1.getDevelopmentLine());
                    IDevelopmentLine dl2 = plan.getResolvedDevelopmentLine(i2.getDevelopmentLine());
                    if (dl1 != null && dl2 != null) {
                        return CollatorCache.getInstance().compare(dl1.getLabel(), dl2.getLabel());
                    }
                }
                return ((GroupElement)e1.getElement()).compareTo((GroupElement)e2.getElement());
            }
            return super.compare(category, e1, e2, readAccessor);
        }
    }
}

