/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.ItemSequenceManager;
import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.mywork.GAbstractLabelButton;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.CompositeGadget;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public class GMyWorkStartDate
extends GAbstractLabelButton {
    private final PlanItem fPlanItem;

    public GMyWorkStartDate(CompositeGadget parent, PlanItem planItem) {
        super(parent);
        this.fPlanItem = planItem;
        this.setLabel(this.getStartDateLabel());
        this.setAction((IAction)new StartDateAction());
    }

    private String getStartDateLabel() {
        final String[] startDateLabel = new String[]{Messages.GMyWorkStartDate_DATE_NOT_SPECIFIED};
        final ItemSequenceManager sequenceManager = this.fPlanItem.getSequenceManager();
        sequenceManager.executeLocked(new Runnable(){

            @Override
            public void run() {
                try {
                    int itemIndex = sequenceManager.getIndexOf(GMyWorkStartDate.this.fPlanItem);
                    if (itemIndex == 0) {
                        startDateLabel[0] = Messages.GMyWorkStartDate_DATE_NOW;
                    } else if (itemIndex > 0) {
                        PlanItem successor = sequenceManager.getAt(itemIndex - 1);
                        startDateLabel[0] = MessageFormat.format(Messages.GMyWorkStartDate_DATE_AFTER_ITEM, successor.getId());
                    } else {
                        startDateLabel[0] = Messages.GMyWorkStartDate_DATE_NAT_AVAILABLE;
                        GMyWorkStartDate.this.setEnabled(false);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        });
        return startDateLabel[0];
    }

    private class StartDateAction
    extends Action {
        public void run() {
            throw new UnsupportedOperationException("Setting a fixed start date is not supported");
        }
    }
}

