/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanElement;
import com.ibm.team.apt.internal.ide.ui.common.quickquery.ColorizeTag;
import com.ibm.team.apt.internal.ide.ui.editor.outliner.PlanElementGadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.ContentOutlineItem;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GShell;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.GTreeNodeContent;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.Gadget;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.OutlineItem;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;

public abstract class GExpandableTreeNode<T extends PlanElement, C extends GTreeNodeContent>
extends PlanElementGadget<T, C> {
    public static final int SHOW_DETAILS = 256;

    public GExpandableTreeNode(ContentOutlineItem item, T element, List<ColorizeTag> colorTags) {
        super(item, element, colorTags, 0);
    }

    @Override
    protected void selectionGained() {
        this.selectionChanged(true);
    }

    @Override
    protected void selectionLost() {
        this.selectionChanged(false);
    }

    public void setShowDetails(boolean showDetails) {
        if (this.isSelected()) {
            this.doSetShowDetails(showDetails);
        }
    }

    public boolean isShowDetails() {
        return (this.getCustomSelectionMode() & 0x100) == 256;
    }

    boolean isSelected() {
        return (this.getSelectionMode() & 1) == 1;
    }

    private void selectionChanged(boolean selected) {
        this.stateChanged();
    }

    private void doSetShowDetails(boolean showDetails) {
        int customSelectionMode = this.getCustomSelectionMode() & 0xFFFFFEFF;
        if (showDetails) {
            this.removeShowDetails(this.getOutline().getItems());
            customSelectionMode |= 0x100;
        }
        this.setCustomSelectionMode(customSelectionMode);
        this.stateChanged();
        if (showDetails) {
            this.getOutline().showItem(this.getOutlineItem());
        }
    }

    private void removeShowDetails(OutlineItem[] items) {
        OutlineItem[] outlineItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            OutlineItem outlineItem = outlineItemArray[n2];
            GShell shell = outlineItem.getContent();
            if (shell instanceof GExpandableTreeNode) {
                ((GExpandableTreeNode)shell).doSetShowDetails(false);
            }
            this.removeShowDetails(outlineItem.getItems());
            ++n2;
        }
    }

    private void stateChanged() {
        Object content = this.getContent();
        if (((Gadget)content).isLayouted()) {
            Rectangle oldBounds = ((Gadget)content).getBounds();
            ((Gadget)content).layout(oldBounds.x, oldBounds.y, oldBounds.width, -1);
            Rectangle newBounds = ((Gadget)content).getBounds();
            this.resized((Gadget)content, newBounds.width - oldBounds.width, newBounds.height - oldBounds.height, (Gadget)content);
        }
    }
}

