/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.client.ResolvedPersonalPlan;
import com.ibm.team.apt.internal.common.Severity;
import com.ibm.team.apt.internal.common.util.PlanRunnable;
import com.ibm.team.apt.internal.ide.ui.mywork.AbstractSaveStrategy;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.apt.internal.ide.ui.mywork.MyWorkView;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class AutoSaveStrategy
extends AbstractSaveStrategy {
    public static final String ID = "com.ibm.team.apt.mywork.autosave";
    private static final long AUTOSAVE_DELAY = 15000L;
    private static final long AUTOSAVE_DELAY_INCLUDE = 10000L;
    private final Object fAutoSaveJobLock = new Object();
    private AutoSaveJob fAutoSaveJob;
    private Map<PlanItem, Date> fTouchTimes = new HashMap<PlanItem, Date>();
    private Set<PlanItem> fManualSaveItems = new HashSet<PlanItem>();
    ISchedulingRule fSequentialSaveRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == AutoSaveStrategy.this.fSequentialSaveRule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == AutoSaveStrategy.this.fSequentialSaveRule;
        }
    };

    public AutoSaveStrategy(MyWorkView myWorkView) {
        super(myWorkView);
    }

    @Override
    protected void successfullySaved(List<PlanItem> savedPlanItem) {
        super.successfullySaved(savedPlanItem);
        this.fManualSaveItems.removeAll(savedPlanItem);
    }

    @Override
    public void inputChanged(ResolvedPersonalPlan oldInput, ResolvedPersonalPlan newInput) {
        this.cancelAutoSave();
        super.inputChanged(oldInput, newInput);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void setLoggedIn(boolean loggedIn) {
        super.setLoggedIn(loggedIn);
        this.removeMessageKind(LoginMessage.class);
        if (loggedIn) {
            this.startAutoSave();
        } else {
            this.cancelAutoSave();
            this.addMessage(new LoginMessage());
        }
        this.updateMessages();
    }

    @Override
    protected void handleDisconnect() {
        this.cancelAutoSave();
    }

    @Override
    protected void handleDirtyStateChange(PlanItem planItem, boolean newDirtyState) {
        this.setSaveRequired(planItem, newDirtyState && this.fPlanSaveAccessor.isWriteable(planItem));
    }

    @Override
    protected void handleWriteableStateChange(PlanItem planItem, boolean newWriteableState) {
        if (newWriteableState && planItem.isDirty()) {
            this.setSaveRequired(planItem, true);
        } else if (!newWriteableState) {
            this.setSaveRequired(planItem, false);
        }
    }

    @Override
    protected void handleWorkItemChange(PlanItem planItem, WorkItemChangeEvent event) {
        if (this.fPlanSaveAccessor.isWriteable(planItem)) {
            this.setSaveRequired(planItem, planItem.isDirty());
        }
    }

    @Override
    protected void onConnectNewInput(ResolvedPersonalPlan plan) {
        this.startAutoSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSaveRequired(PlanItem planItem, boolean saveRequired) {
        Object object = this.fAutoSaveJobLock;
        synchronized (object) {
            if (!saveRequired) {
                this.fTouchTimes.remove(planItem);
            } else {
                this.fTouchTimes.put(planItem, new Date());
                if (this.fAutoSaveJob == null && this.fIsLoggedIn) {
                    this.fAutoSaveJob = new AutoSaveJob();
                    this.fAutoSaveJob.schedule(15000L);
                }
            }
        }
        this.markAsDirty(saveRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAutoSave() {
        Object object = this.fAutoSaveJobLock;
        synchronized (object) {
            this.fTouchTimes.clear();
            this.fManualSaveItems.clear();
            if (this.fPlanSaveAccessor != null) {
                for (PlanItem planItem : this.fPlanSaveAccessor.getDirtyPlanItems()) {
                    this.setSaveRequired(planItem, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAutoSave() {
        Object object = this.fAutoSaveJobLock;
        synchronized (object) {
            if (this.fAutoSaveJob != null) {
                this.fAutoSaveJob.cancel();
                this.fAutoSaveJob = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAutoSave(final IProgressMonitor monitor) {
        final ArrayList toAutoSave = new ArrayList();
        boolean wasConnected = this.fPlan.runConnected((PlanRunnable)new PlanRunnable<RuntimeException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws RuntimeException {
                Object object = AutoSaveStrategy.this.fAutoSaveJobLock;
                synchronized (object) {
                    AutoSaveStrategy.this.fAutoSaveJob = null;
                    if (!monitor.isCanceled() && AutoSaveStrategy.this.fIsLoggedIn) {
                        long autosaveCutoff = System.currentTimeMillis() - 10000L;
                        long nextAutoSaveDelay = -1L;
                        Iterator iterator = AutoSaveStrategy.this.fTouchTimes.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry touchedEntry = iterator.next();
                            PlanItem planItem = (PlanItem)touchedEntry.getKey();
                            Date lastTouched = (Date)touchedEntry.getValue();
                            if (lastTouched.getTime() < autosaveCutoff) {
                                if (!planItem.isDirty() || AutoSaveStrategy.this.fSaveConflicts.containsKey(planItem)) {
                                    iterator.remove();
                                    continue;
                                }
                                if (!AutoSaveStrategy.this.fPlanSaveAccessor.isOnlyEditor(planItem)) continue;
                                if (!AutoSaveStrategy.this.fManualSaveItems.contains(planItem)) {
                                    toAutoSave.add(planItem);
                                }
                                iterator.remove();
                                continue;
                            }
                            long difference = Math.max(lastTouched.getTime() - autosaveCutoff, 0L);
                            if (nextAutoSaveDelay >= 0L && difference >= nextAutoSaveDelay) continue;
                            nextAutoSaveDelay = difference;
                        }
                        if (!AutoSaveStrategy.this.fTouchTimes.isEmpty()) {
                            if (nextAutoSaveDelay < 0L) {
                                nextAutoSaveDelay = 15000L;
                            }
                            AutoSaveStrategy.this.fAutoSaveJob = new AutoSaveJob();
                            AutoSaveStrategy.this.fAutoSaveJob.schedule(nextAutoSaveDelay);
                        }
                    }
                }
            }
        });
        if (!wasConnected) {
            Object object = this.fAutoSaveJobLock;
            synchronized (object) {
                this.fAutoSaveJob = null;
                return;
            }
        }
        this.fPlan.runConnected((PlanRunnable)new PlanRunnable<RuntimeException>(){

            public void run() throws RuntimeException {
                if (!toAutoSave.isEmpty() && !monitor.isCanceled()) {
                    block8: {
                        List<PlanItem> toSave = AutoSaveStrategy.this.beginSave(toAutoSave);
                        try {
                            AutoSaveStrategy.this.fPlanSaveAccessor.save(toSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        catch (MultiStaleDataException e) {
                            AutoSaveStrategy.this.handleStaleDataException(e);
                            AutoSaveStrategy.this.endSave(toSave);
                            break block8;
                        }
                        catch (TeamRepositoryException e) {
                            try {
                                AutoSaveStrategy.this.fManualSaveItems.addAll(toSave);
                                AutoSaveStrategy.this.handleSaveException(e);
                                break block8;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                AutoSaveStrategy.this.endSave(toSave);
                            }
                        }
                        AutoSaveStrategy.this.endSave(toSave);
                    }
                    AutoSaveStrategy.this.updateDirtyState();
                }
            }
        });
    }

    private class AutoSaveJob
    extends Job {
        public AutoSaveJob() {
            super(Messages.AutoSaveStrategy_JOB_AUTO_SAVE);
            this.setRule(AutoSaveStrategy.this.fSequentialSaveRule);
        }

        public IStatus run(IProgressMonitor monitor) {
            AutoSaveStrategy.this.doAutoSave(monitor);
            return Status.OK_STATUS;
        }
    }

    private class LoginMessage
    extends AbstractSaveStrategy.ActionMessage {
        public LoginMessage() {
            super(NLS.bind((String)Messages.AutoSaveStrategy_LOGIN_MESSAGE, (Object)"login", (Object[])new Object[0]), Severity.INFO);
        }

        @Override
        public void clicked(String ref) {
            AutoSaveStrategy.this.fMyWorkView.ensureLoggedIn();
        }
    }
}

