/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.mywork;

import com.ibm.team.apt.internal.client.PlanItem;
import com.ibm.team.apt.internal.ide.ui.actions.PlanViewModelAction;
import com.ibm.team.apt.internal.ide.ui.common.PlanViewModel;
import com.ibm.team.apt.internal.ide.ui.common.model.EntryUtils;
import com.ibm.team.apt.internal.ide.ui.mywork.Messages;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.rtc.foundation.api.ui.model.IViewEntry;
import java.util.Collection;
import org.eclipse.ui.IWorkbenchSite;

public class AcceptWorkAction
extends PlanViewModelAction<PlanItem> {
    protected AcceptWorkAction(IWorkbenchSite site, PlanViewModel planViewModel) {
        super(site, planViewModel, PlanItem.class, ONE_OR_MORE);
        this.setText(Messages.AcceptWorkAction_LABEL);
    }

    @Override
    protected boolean checkElement(IViewEntry<PlanItem> selectedEntry) {
        return ((PlanItem)selectedEntry.getElement()).isNewItem();
    }

    @Override
    protected void updateAction(Collection<IViewEntry<PlanItem>> selectedEntries) {
        IIterationHandle referenceTargetHandle = ((PlanItem)EntryUtils.firstElement(selectedEntries)).getTargetHandle();
        boolean singleTarget = true;
        for (IViewEntry entry : selectedEntries) {
            IIterationHandle itemTarget = ((PlanItem)entry.getElement()).getTargetHandle();
            if ((referenceTargetHandle != null || itemTarget == null) && (referenceTargetHandle == null || referenceTargetHandle.sameItemId((IItemHandle)itemTarget))) continue;
            singleTarget = false;
            break;
        }
        String label = null;
        if (singleTarget) {
            if (referenceTargetHandle == null) {
                label = Messages.AcceptWorkAction_LABEL_UNPLANNED;
            } else {
                IIteration referenceTarget = this.getPlanViewModel().getInput().getResolvedIteration(referenceTargetHandle);
                if (referenceTarget != null) {
                    label = NLS.bind((String)Messages.AcceptWorkAction_LABEL_SPECIFIC, (Object)referenceTarget.getLabel(), (Object[])new Object[0]);
                }
            }
        }
        if (label == null) {
            label = Messages.AcceptWorkAction_LABEL;
        }
        this.setText(label);
    }

    @Override
    public void run(Collection<IViewEntry<PlanItem>> selectedEntries) {
        for (IViewEntry iViewEntry : selectedEntries) {
            PlanItem item = (PlanItem)iViewEntry.getElement();
            item.markAsNewItem(false);
            item.markRead();
        }
        this.getPlanViewModel().setSelectedElements(EntryUtils.elements(selectedEntries));
    }
}

