/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.jface;

import com.ibm.team.apt.internal.ide.ui.jface.CommandLinkEvent;
import com.ibm.team.apt.internal.ide.ui.jface.ICommandLinkListener;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class CommandListViewer
extends ContentViewer {
    private final Composite fContainer;
    private final List<Hyperlink> fControls = new ArrayList<Hyperlink>();
    private final ListenerList fLinkListeners = new ListenerList();
    private ViewerComparator fSorter;
    private ViewerFilter fFilter;
    private final HyperlinkGroup fHyperlinkGroup;
    private Object[] fElements;

    public CommandListViewer(Composite parent, HyperlinkGroup hyperlinkGroup, int style) {
        this.fHyperlinkGroup = hyperlinkGroup;
        this.fContainer = new Composite(parent, style){

            public void setEnabled(boolean enabled) {
                Control[] controls;
                super.setEnabled(enabled);
                Control[] controlArray = controls = this.getChildren();
                int n = controls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setEnabled(enabled);
                    ++n2;
                }
            }
        };
        this.fContainer.setLayout((Layout)new RowLayout(256));
    }

    public void addCommandLinkListener(ICommandLinkListener listener) {
        this.fLinkListeners.add((Object)listener);
    }

    public void removeCommandLinkListener(ICommandLinkListener listener) {
        this.fLinkListeners.remove((Object)listener);
    }

    public Control getControl() {
        return this.fContainer;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isLegal((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isLegal((boolean)(contentProvider instanceof IStructuredContentProvider));
        super.setContentProvider(contentProvider);
    }

    public void setComparator(ViewerComparator comparator) {
        if (this.fSorter != comparator) {
            this.fSorter = comparator;
            this.refresh();
        }
    }

    public void setFilter(ViewerFilter filter) {
        if (this.fFilter != filter) {
            this.fFilter = filter;
            this.refresh();
        }
    }

    public void setEnabled(Object element, boolean enabled) {
        this.findElement(element).setEnabled(enabled);
    }

    public boolean getEnabled(Object element) {
        return this.findElement(element).getEnabled();
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.refresh();
    }

    public void refresh() {
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        this.removeAll();
        if (contentProvider != null && labelProvider != null) {
            this.fElements = contentProvider.getElements(this.getInput());
            if (this.fSorter != null) {
                this.fSorter.sort((Viewer)this, this.fElements);
            }
            int filtered = this.fElements.length;
            if (this.fFilter != null) {
                this.fElements = this.fFilter.filter((Viewer)this, null, this.fElements);
                filtered -= this.fElements.length;
            }
            Object[] objectArray = this.fElements;
            int n = this.fElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.createElementControl(element, labelProvider);
                ++n2;
            }
        }
        this.fContainer.layout(true, true);
    }

    public void update(Object toUpadate) {
        boolean found = false;
        Object[] objectArray = this.fElements;
        int n = this.fElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element.equals(toUpadate)) {
                found = true;
            }
            ++n2;
        }
        if (found) {
            this.refresh();
        }
    }

    public ISelection getSelection() {
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    private Control findElement(Object element) {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        for (Hyperlink link : this.fControls) {
            if (!element.equals(link.getData())) continue;
            return link;
        }
        return null;
    }

    private void removeAll() {
        for (Hyperlink link : this.fControls) {
            link.dispose();
        }
        this.fControls.clear();
    }

    private void fireEvent(Object element) {
        CommandLinkEvent event = new CommandLinkEvent(this, element);
        Object[] listeners = this.fLinkListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICommandLinkListener listener = (ICommandLinkListener)listeners[i];
            listener.selected(event);
            ++i;
        }
    }

    private void createElementControl(final Object element, ILabelProvider labelProvider) {
        Font font;
        String text = labelProvider.getText(element);
        Hyperlink link = new Hyperlink(this.fContainer, 0);
        link.setText(UI.safeString(text));
        link.setToolTipText(UI.safeString(text));
        link.setData(element);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                CommandListViewer.this.fireEvent(element);
            }
        });
        if (labelProvider instanceof IFontProvider && (font = ((IFontProvider)labelProvider).getFont(element)) != null) {
            link.setFont(font);
        }
        this.fHyperlinkGroup.add(link);
        this.fControls.add(link);
    }
}

