/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.jface;

import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.jface.ConfigurationUIProvider;
import com.ibm.team.apt.internal.ide.ui.jface.Messages;
import com.ibm.team.apt.internal.ide.ui.util.UI;
import com.ibm.team.apt.internal.ide.ui.widgets.outliner.BarPainters;
import com.ibm.team.jface.DoubleBufferPainter;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;

public class CheckboxListViewer
extends ContentViewer
implements ICheckable {
    private final Composite fContainer;
    private final List<Control> fControls = new ArrayList<Control>();
    private ListenerList fCheckStateListeners = new ListenerList();
    private ListenerList fSecondaryListeners = new ListenerList();
    private ListenerList fExpansionListener = new ListenerList();
    private int fButtonStyle;
    private ViewerComparator fSorter;
    private ViewerFilter fFilter;
    private boolean fIgnoreFilter = false;
    private boolean fAllowToIgnoreFilter = true;
    private ConfigurationUIProvider fConfigurationUiProvider;
    private LocalResourceManager fResources;
    private boolean fEnableConfigurationUI;
    private IStructuredSelection fTemporarySelection;

    public CheckboxListViewer(Composite parent, int style) {
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        style = this.extractButtonStyle(style);
        this.fContainer = new Composite(parent, style){

            public void setEnabled(boolean enabled) {
                Control[] controls;
                super.setEnabled(enabled);
                Control[] controlArray = controls = this.getChildren();
                int n = controls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setEnabled(enabled);
                    ++n2;
                }
            }
        };
        this.fContainer.setLayout((Layout)new ListLayout());
    }

    private int extractButtonStyle(int style) {
        this.fButtonStyle = (style & 0x10) != 0 ? 16 : ((style & 8) != 0 ? 8 : 32);
        style &= 0xFFFFFFEF;
        style &= 0xFFFFFFDF;
        return style &= 0xFFFFFFF7;
    }

    public Control getControl() {
        return this.fContainer;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isLegal((boolean)(labelProvider instanceof ILabelProvider));
        super.setLabelProvider(labelProvider);
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isLegal((boolean)(contentProvider instanceof IStructuredContentProvider));
        super.setContentProvider(contentProvider);
    }

    public void setConfigurationUIProvider(ConfigurationUIProvider configurationUIProvider) {
        this.fConfigurationUiProvider = configurationUIProvider;
    }

    public void setComparator(ViewerComparator comparator) {
        if (this.fSorter != comparator) {
            this.fSorter = comparator;
            this.refresh();
        }
    }

    public void setFilter(ViewerFilter filter) {
        if (this.fFilter != filter) {
            this.fFilter = filter;
            this.refresh();
        }
    }

    public void setFilter(ViewerFilter filter, boolean allowToIgnore) {
        this.fAllowToIgnoreFilter = allowToIgnore;
        this.setFilter(filter);
    }

    public boolean isExpanded() {
        return this.fIgnoreFilter;
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fCheckStateListeners.add((Object)listener);
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.fCheckStateListeners.remove((Object)listener);
    }

    public void removeSecondarySelectionListener(ISelectionChangedListener listener) {
        this.fSecondaryListeners.remove((Object)listener);
    }

    public void addExpansionListener(IExpansionListener listener) {
        this.fExpansionListener.add((Object)listener);
    }

    public void removeExpansionListener(IExpansionListener listener) {
        this.fExpansionListener.remove((Object)listener);
    }

    public void setEnabled(Object element, boolean enabled) {
        Control control = this.findElement(element, false);
        control.setEnabled(enabled);
    }

    public boolean getEnabled(Object element) {
        return this.findElement(element, false).getEnabled();
    }

    public boolean getChecked(Object element) {
        Button button = (Button)this.findElement(element, false);
        return button != null ? button.getSelection() : false;
    }

    public boolean setChecked(Object element, boolean state) {
        Button button = (Button)this.findElement(element, false);
        if (button == null) {
            return false;
        }
        if (this.fButtonStyle == 16) {
            this.setAllChecked(false);
        }
        button.setSelection(state);
        return true;
    }

    public void setAllChecked(boolean state) {
        for (Control control : this.fControls) {
            if (!(control instanceof Button)) continue;
            ((Button)control).setSelection(state);
        }
    }

    public void setEnableConfigurationUI(boolean enabled) {
        this.fEnableConfigurationUI = enabled;
        this.updateConfigurationUI(enabled);
    }

    private void updateConfigurationUI(boolean enabled) {
        int i = 0;
        while (i < this.fControls.size()) {
            Control control = this.fControls.get(i);
            if (control instanceof SecondaryControl && ((SecondaryControl)control).fPaintStrategy != null) {
                control.setVisible(enabled);
                Button button = (Button)this.fControls.get(i - 1);
                String text = (String)button.getData(enabled ? "__short_text" : "__medium_text");
                button.setText(text);
                Rectangle bounds = button.getBounds();
                bounds.width = bounds.width + control.getBounds().width * (enabled ? -1 : 1);
                button.setBounds(bounds);
            }
            ++i;
        }
        this.fContainer.redraw();
        this.fContainer.update();
    }

    public void setInput(Object input) {
        super.setInput(input);
        this.refresh();
    }

    public void refresh() {
        this.fTemporarySelection = (IStructuredSelection)this.getSelection();
        List selectedElements = this.fTemporarySelection.toList();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
        this.removeAll();
        if (contentProvider != null && labelProvider != null) {
            Object[] elements = contentProvider.getElements(this.getInput());
            if (this.fSorter != null) {
                this.fSorter.sort((Viewer)this, elements);
            }
            int filtered = elements.length;
            if (this.fFilter != null && !this.fIgnoreFilter) {
                elements = this.fFilter.filter((Viewer)this, null, elements);
                filtered -= elements.length;
            }
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.createElementControl(element, labelProvider.getText(element), selectedElements.contains(element));
                ++n2;
            }
            this.fTemporarySelection = null;
            if (this.fFilter != null && (this.fIgnoreFilter || filtered > 0) && this.fAllowToIgnoreFilter) {
                CLabel label = new CLabel(this.fContainer, 0);
                label.setImage(this.fIgnoreFilter ? this.fResources.createImage(ImagePool.CHEVRON_UP) : this.fResources.createImage(ImagePool.CHEVRON_DOWN));
                label.setText(this.fIgnoreFilter ? Messages.CheckboxListViewer_LABEL_LESS : Messages.CheckboxListViewer_LABEL_MORE);
                label.setToolTipText(this.fIgnoreFilter ? Messages.CheckboxListViewer_DESC_LESS : NLS.bind((String)Messages.CheckboxListViewer_DESC_MORE, (Object)filtered, (Object[])new Object[0]));
                label.setCursor(this.fContainer.getDisplay().getSystemCursor(21));
                label.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        CheckboxListViewer.this.fIgnoreFilter = !CheckboxListViewer.this.fIgnoreFilter;
                        ISelection selection = CheckboxListViewer.this.getSelection();
                        CheckboxListViewer.this.refresh();
                        CheckboxListViewer.this.setSelection(selection, true);
                        Object[] objectArray = CheckboxListViewer.this.fExpansionListener.getListeners();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object listener = objectArray[n2];
                            ExpansionEvent event = new ExpansionEvent((Object)CheckboxListViewer.this, CheckboxListViewer.this.fIgnoreFilter);
                            ((IExpansionListener)listener).expansionStateChanged(event);
                            ++n2;
                        }
                    }
                });
                this.fControls.add((Control)label);
            }
        }
        this.fContainer.layout(true, true);
    }

    public ISelection getSelection() {
        if (this.fTemporarySelection != null) {
            return this.fTemporarySelection;
        }
        ArrayList<Object> result = new ArrayList<Object>(this.fControls.size());
        for (Control next : this.fControls) {
            if (!(next instanceof Button) || !((Button)next).getSelection()) continue;
            result.add(next.getData());
        }
        return new StructuredSelection(result);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        boolean radio;
        this.setAllChecked(false);
        boolean bl = radio = this.fButtonStyle == 16;
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).toList().iterator();
            while (iter.hasNext()) {
                this.setChecked(iter.next(), true);
                if (!radio) continue;
                return;
            }
        }
    }

    private Control findElement(Object element, boolean secondary) {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        int i = 0;
        while (i < this.fControls.size()) {
            Control control = this.fControls.get(i);
            if (element.equals(control.getData())) {
                if (!secondary) {
                    return control;
                }
                return this.fControls.get(i + 1);
            }
            i += 2;
        }
        return null;
    }

    private void removeAll() {
        for (Control control : this.fControls) {
            control.dispose();
        }
        this.fControls.clear();
    }

    private void fireEvent(Object element, boolean newState) {
        Object[] listeners = this.fCheckStateListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICheckStateListener listener = (ICheckStateListener)listeners[i];
            CheckStateChangedEvent event = new CheckStateChangedEvent((ICheckable)this, element, newState);
            listener.checkStateChanged(event);
            ++i;
        }
    }

    private Button createElementControl(final Object element, String text, boolean selected) {
        final Button button = new Button(this.fContainer, this.fButtonStyle);
        button.setText(UI.safeString(text));
        button.setToolTipText(UI.safeString(text));
        button.setSelection(selected);
        button.setData(element);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckboxListViewer.this.fireEvent(element, button.getSelection());
            }
        });
        this.fControls.add((Control)button);
        SecondaryControl canvas = new SecondaryControl(this.fContainer, 0);
        canvas.setFont(button.getFont());
        this.fControls.add((Control)canvas);
        canvas.setVisible(false);
        if (this.fConfigurationUiProvider != null && this.fConfigurationUiProvider.canConfigure(element)) {
            final ConfigurationUIProvider.IConfigurationUI ui = this.fConfigurationUiProvider.getConfigureUI(element);
            canvas.setVisible(this.fEnableConfigurationUI);
            canvas.setDrawingStrategy(ui.getDrawingStrategy(element));
            canvas.setToolTipText(UI.safeString(ui.getText(element)));
            canvas.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    ui.configure(element, CheckboxListViewer.this.fContainer.getShell());
                }
            });
        }
        return button;
    }

    public static class AnimatedImageDrawingStrategy
    implements IAnimatedDrawingStrategy {
        private ImageDescriptor[] fAnimation;

        public AnimatedImageDrawingStrategy(ImageDescriptor[] animation) {
            this.fAnimation = animation;
        }

        @Override
        public void paint(ResourceManager resources, GC gc, Rectangle bounds, boolean hover) {
            Image img = resources.createImage(this.fAnimation[(int)(System.currentTimeMillis() / 180L % (long)this.fAnimation.length)]);
            Point point = BarPainters.align(bounds, img.getBounds().width, img.getBounds().height, BarPainters.Alignment.Top, BarPainters.Alignment.Right);
            gc.drawImage(img, point.x, point.y);
        }

        @Override
        public int getInterval() {
            return 180;
        }
    }

    public static class DeletationMarkDrawingStrategy
    implements IDrawingStrategy {
        @Override
        public void paint(ResourceManager resources, GC gc, Rectangle bounds, boolean hover) {
            gc.setAlpha(hover ? 255 : 200);
            int side = gc.getFontMetrics().getHeight() - gc.getFontMetrics().getLeading();
            int x = bounds.x + bounds.width - side - 1;
            int y = bounds.y + 2;
            gc.setBackground(gc.getDevice().getSystemColor(18));
            gc.fillOval(x, y, side, side);
            int len = SWT.getPlatform().equals("carbon") ? 4 : 3;
            gc.setForeground(gc.getDevice().getSystemColor(1));
            gc.setLineWidth(2);
            gc.setLineCap(2);
            gc.setLineJoin(2);
            gc.drawLine(x + len, y + len, x + side - len, y + side - len);
            gc.drawLine(x + side - len, y + len, x + len, y + side - len);
        }
    }

    public static interface IAnimatedDrawingStrategy
    extends IDrawingStrategy {
        public int getInterval();
    }

    public static interface IDrawingStrategy {
        public void paint(ResourceManager var1, GC var2, Rectangle var3, boolean var4);
    }

    public static class ImageDrawingStrategy
    implements IDrawingStrategy {
        private ImageDescriptor fEnabled;
        private ImageDescriptor fDisabled;

        public ImageDrawingStrategy(ImageDescriptor disabled, ImageDescriptor enabled) {
            this.fDisabled = disabled;
            this.fEnabled = enabled;
        }

        @Override
        public void paint(ResourceManager resources, GC gc, Rectangle bounds, boolean hover) {
            Image img = resources.createImage(hover ? this.fEnabled : this.fDisabled);
            Point point = BarPainters.align(bounds, img.getBounds().width, img.getBounds().height, BarPainters.Alignment.Top, BarPainters.Alignment.Right);
            gc.drawImage(img, point.x, point.y);
        }
    }

    private class ListLayout
    extends Layout {
        private static final String LONG_TEXT = "__long_text";
        private static final String MEDIUM_TEXT = "__medium_text";
        private static final String SHORT_TEXT = "__short_text";
        final int HORIZONTAL_INDENT = 5;
        final int VERTICAL_SPACING = 5;
        private final int MARGIN = 4;
        private int fCheckWidth = -1;

        private ListLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Assert.isLegal((composite == CheckboxListViewer.this.fContainer ? 1 : 0) != 0);
            int preferredWidth = 0;
            int preferredHeight = 0;
            ListIterator iter = CheckboxListViewer.this.fControls.listIterator();
            while (iter.hasNext()) {
                Control control = (Control)iter.next();
                if (!(control instanceof Button) && !(control instanceof CLabel)) continue;
                Point preferredSize = control.computeSize(wHint, hHint);
                preferredWidth = Math.max(preferredSize.x, preferredWidth);
                preferredHeight += preferredSize.y + (control instanceof Button ? 5 : 0);
            }
            return new Point(preferredWidth, preferredHeight);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Assert.isLegal((composite == CheckboxListViewer.this.fContainer ? 1 : 0) != 0);
            Rectangle clientArea = CheckboxListViewer.this.fContainer.getClientArea();
            int left = clientArea.x + 5;
            int top = clientArea.y;
            int i = 0;
            while (i < CheckboxListViewer.this.fControls.size()) {
                int width = clientArea.width - 5;
                if (CheckboxListViewer.this.fControls.get(i) instanceof CLabel) {
                    CLabel label = (CLabel)CheckboxListViewer.this.fControls.get(i);
                    int height = label.computeSize((int)width, (int)-1).y;
                    label.setBounds(left, top - 5, width, height);
                    break;
                }
                Button button = (Button)CheckboxListViewer.this.fControls.get(i);
                Control control = (Control)CheckboxListViewer.this.fControls.get(i + 1);
                String longText = button.getText();
                Point btnPreferredSize = button.computeSize(width, -1);
                Point cvsPreferredSize = control.computeSize(btnPreferredSize.y, btnPreferredSize.y);
                control.setBounds(clientArea.x + clientArea.width - cvsPreferredSize.x, top, cvsPreferredSize.x, cvsPreferredSize.y);
                int width2 = width - cvsPreferredSize.x;
                button.setBounds(left, top, control.getVisible() ? width2 : width, btnPreferredSize.y);
                if (button.getData(LONG_TEXT) != null) {
                    longText = (String)button.getData(LONG_TEXT);
                } else {
                    longText = button.getText();
                    button.setData(LONG_TEXT, (Object)longText);
                }
                button.setData(MEDIUM_TEXT, (Object)this.shortenText(longText, (Drawable)button, width - this.getCheckWidth(button) - 5));
                button.setData(SHORT_TEXT, (Object)this.shortenText(longText, (Drawable)button, width2 - this.getCheckWidth(button) - 5));
                if (control.getVisible()) {
                    button.setText((String)button.getData(SHORT_TEXT));
                } else {
                    button.setText((String)button.getData(MEDIUM_TEXT));
                }
                top += btnPreferredSize.y + 5;
                i += 2;
            }
        }

        private int getCheckWidth(Button button) {
            if (this.fCheckWidth == -1) {
                Composite composite = button.getParent();
                Button b1 = new Button(composite, 8);
                Button b2 = new Button(composite, CheckboxListViewer.this.fButtonStyle);
                try {
                    b1.setFont(button.getFont());
                    b1.setText(button.getText());
                    b1.setImage(button.getImage());
                    b2.setFont(button.getFont());
                    b2.setText(button.getText());
                    b2.setImage(button.getImage());
                    this.fCheckWidth = 4 + Math.abs(b1.computeSize((int)-1, (int)-1).x - b2.computeSize((int)-1, (int)-1).x);
                }
                finally {
                    if (b1 != null) {
                        b1.dispose();
                    }
                    if (b2 != null) {
                        b2.dispose();
                    }
                }
            }
            return this.fCheckWidth == -1 ? 0 : this.fCheckWidth;
        }

        private String shortenText(String textValue, Drawable drawable, int maxWidth) {
            int length;
            if (textValue == null) {
                return null;
            }
            GC gc = new GC(drawable);
            int maxExtent = gc.textExtent((String)textValue).x;
            if (maxExtent < maxWidth) {
                gc.dispose();
                return textValue;
            }
            int start = length = textValue.length();
            while (start >= 0) {
                if (!Character.isWhitespace(textValue.charAt(Math.max(0, start - 1)))) {
                    String s1 = textValue.substring(0, start);
                    String s = String.valueOf(s1) + "...";
                    int l = gc.textExtent((String)s).x;
                    if (l < maxWidth) {
                        gc.dispose();
                        return s;
                    }
                }
                --start;
            }
            gc.dispose();
            return textValue;
        }
    }

    private class SecondaryControl
    extends Canvas {
        private IDrawingStrategy fPaintStrategy;
        private boolean fMouseHover;

        public SecondaryControl(final Composite parent, int style) {
            super(parent, style | 0x40000);
            new DoubleBufferPainter(this){
                long fTokenPool;
                {
                    super($anonymous0);
                    this.fTokenPool = 0L;
                }

                public void doPaint(PaintEvent event) {
                    if (SecondaryControl.this.fPaintStrategy != null) {
                        GC gc = event.gc;
                        gc.setAdvanced(true);
                        gc.setAntialias(1);
                        SecondaryControl.this.fPaintStrategy.paint((ResourceManager)CheckboxListViewer.this.fResources, gc, SecondaryControl.this.getClientArea(), SecondaryControl.this.fMouseHover);
                        if (SecondaryControl.this.fPaintStrategy instanceof IAnimatedDrawingStrategy) {
                            final long token = ++this.fTokenPool;
                            int interval = ((IAnimatedDrawingStrategy)SecondaryControl.this.fPaintStrategy).getInterval();
                            if (interval > 0) {
                                parent.getDisplay().timerExec(interval, new Runnable(){

                                    @Override
                                    public void run() {
                                        if (SecondaryControl.this.isDisposed()) {
                                            return;
                                        }
                                        if (token != fTokenPool) {
                                            return;
                                        }
                                        SecondaryControl.this.redraw();
                                    }
                                });
                            }
                        }
                    }
                }
            };
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    int type = event.type;
                    switch (type) {
                        case 6: {
                            SecondaryControl.this.fMouseHover = true;
                            SecondaryControl.this.setCursor(event.display.getSystemCursor(21));
                            SecondaryControl.this.redraw();
                            break;
                        }
                        case 7: {
                            SecondaryControl.this.fMouseHover = false;
                            SecondaryControl.this.setCursor(event.display.getSystemCursor(0));
                            SecondaryControl.this.redraw();
                        }
                    }
                }
            };
            this.addListener(6, listener);
            this.addListener(7, listener);
        }

        public Rectangle computeTrim(int x, int y, int width, int height) {
            return new Rectangle(x, y, width, height);
        }

        public void setDrawingStrategy(IDrawingStrategy paintStrategy) {
            this.fPaintStrategy = paintStrategy;
        }
    }
}

