/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.xxx;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.xxx.DeleteLineTarget;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class DeleteLineAction
extends TextEditorAction {
    public static final int WHOLE = 0;
    public static final int TO_BEGINNING = 1;
    public static final int TO_END = 2;
    private final int fType;
    private final boolean fCopyToClipboard;
    private DeleteLineTarget fTarget;
    private final ISourceViewer fSourceViewer;

    public DeleteLineAction(ResourceBundle bundle, String prefix, WikiViewer viewer, int type) {
        this(bundle, prefix, viewer, type, true);
    }

    public DeleteLineAction(ResourceBundle bundle, String prefix, WikiViewer viewer, int type, boolean copyToClipboard) {
        super(bundle, prefix, viewer.getTextEditor());
        this.fSourceViewer = viewer;
        this.fType = type;
        this.fCopyToClipboard = copyToClipboard;
        this.update();
    }

    private IDocument getDocument(ITextEditor editor) {
        return this.fSourceViewer.getDocument();
    }

    private static ITextSelection getSelection(ITextEditor editor) {
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            return null;
        }
        return (ITextSelection)selection;
    }

    public void run() {
        if (this.fTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        IDocument document = this.getDocument(editor);
        if (document == null) {
            return;
        }
        ITextSelection selection = DeleteLineAction.getSelection(editor);
        if (selection == null) {
            return;
        }
        try {
            this.fTarget.deleteLine(document, selection.getOffset(), selection.getLength(), this.fType, this.fCopyToClipboard);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        this.fTarget = editor != null ? (DeleteLineTarget)editor.getAdapter(DeleteLineTarget.class) : null;
        this.setEnabled(this.fTarget != null);
    }
}

