/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiPartitionScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.TextNavigationAction;

public class LineStartAction
extends TextNavigationAction {
    private final ISourceViewer fViewer;

    public LineStartAction(ISourceViewer viewer) {
        super(viewer.getTextWidget(), 0x1000007);
        this.fViewer = viewer;
    }

    protected int getLineStartPosition(String line, int length, char ch) {
        int index = 0;
        while (index < length && line.charAt(index) == ch) {
            ++index;
        }
        return index;
    }

    public void run() {
        int index;
        StyledText st;
        boolean isMatchingPartition = false;
        boolean isSmartHomeEndEnabled = false;
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store != null) {
            isSmartHomeEndEnabled = store.getBoolean("AbstractTextEditor.Navigation.SmartHomeEnd");
        }
        if ((st = this.fViewer.getTextWidget()) == null || st.isDisposed()) {
            return;
        }
        IDocument document = this.fViewer.getDocument();
        int caretOffset = st.getCaretOffset();
        int lineNumber = st.getLineAtOffset(caretOffset);
        int lineOffset = st.getOffsetAtLine(lineNumber);
        int offsetInLine = caretOffset - lineOffset;
        int lineLength = -1;
        char ch = '\u0000';
        try {
            String type = ((IDocumentExtension3)document).getPartition(WikiPartitionScanner.Partitions.WIKI_PARTITING, caretOffset, true).getType();
            if (WikiPartitionScanner.Partitions.HEADING.id.equals(type)) {
                isMatchingPartition = true;
                ch = '=';
            } else if (WikiPartitionScanner.Partitions.BULLET_LIST.id.equals(type)) {
                isMatchingPartition = true;
                ch = '*';
            } else if (WikiPartitionScanner.Partitions.NUMBERED_LIST.id.equals(type)) {
                isMatchingPartition = true;
                ch = '#';
            }
            IRegion line = document.getLineInformation(lineNumber);
            lineLength = line.getLength();
        }
        catch (BadLocationException e1) {
            return;
        }
        catch (BadPartitioningException e) {
            return;
        }
        String line = "";
        if (lineLength > 0) {
            int end = lineOffset + lineLength - 1;
            end = Math.min(end, st.getCharCount() - 1);
            line = st.getText(lineOffset, end);
        }
        int newCaretOffset = -1;
        newCaretOffset = isSmartHomeEndEnabled && isMatchingPartition ? ((index = this.getLineStartPosition(line, lineLength, ch)) < offsetInLine ? lineOffset + index : lineOffset) : lineOffset;
        st.setCaretOffset(newCaretOffset);
    }
}

