/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.WikiLinks;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.PlanningUIPlugin;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.WikiViewer;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.Messages;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.progress.IProgressService;

public class InsertWorkItemLinkAction
extends Action {
    public static final String WIKI_USES_VARIABLES = "com.ibm.team.apt.ide.ui.wiki.useVariables";
    private IProjectAreaHandle fProjectAreaHandle;
    private WikiViewer fViewer;
    private IProgressService fProgessService;

    public InsertWorkItemLinkAction(WikiViewer viewer, IProjectAreaHandle projectArea) {
        super(Messages.InsertWorkItemLinkAction_LABEL, ImagePool.INSERT_LINK);
        this.fViewer = viewer;
        this.fProjectAreaHandle = projectArea;
        this.fProgessService = viewer.getTextEditor().getSite().getWorkbenchWindow().getWorkbench().getProgressService();
    }

    public void run() {
        final int offset = this.fViewer.getTextWidget().getCaretOffset();
        final boolean[] staticLink = new boolean[1];
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(this.fViewer.getControl().getShell(), this.fProjectAreaHandle, false){

            protected Control createDialogArea(Composite parent) {
                Composite area = (Composite)super.createDialogArea(parent);
                final IDialogSettings settings = this.getDialogSettings();
                staticLink[0] = settings != null && settings.getBoolean(InsertWorkItemLinkAction.WIKI_USES_VARIABLES);
                Button button = new Button(area, 32);
                button.setText(Messages.InsertWorkItemLinkAction_INSERT_WIKI_VARIABLE);
                button.setSelection(!staticLink[0]);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean bl = staticLink[0] = !staticLink[0];
                        if (settings != null) {
                            settings.put(InsertWorkItemLinkAction.WIKI_USES_VARIABLES, staticLink[0]);
                        }
                    }
                });
                GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)button);
                return area;
            }
        };
        dialog.setTitle(Messages.InsertWorkItemLinkAction_SINGLE_WORKITEM_TITLE);
        int open = dialog.open();
        if (open != 0) {
            return;
        }
        Object object = dialog.getFirstResult();
        if (!(object instanceof IWorkItemHandle)) {
            return;
        }
        final IWorkItemHandle workItemHandle = (IWorkItemHandle)object;
        try {
            this.fProgessService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        String link = InsertWorkItemLinkAction.this.createLink(workItemHandle, staticLink[0], monitor);
                        if (monitor.isCanceled()) {
                            return;
                        }
                        InsertEdit edit = new InsertEdit(offset, link);
                        InsertWorkItemLinkAction.this.apply((TextEdit)edit);
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            PlanningUIPlugin.log(e1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void apply(final TextEdit edit) {
        Display display = this.fViewer.getControl().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    edit.apply(InsertWorkItemLinkAction.this.fViewer.getDocument(), 0);
                    InsertWorkItemLinkAction.this.fViewer.getTextWidget().setCaretOffset(edit.getOffset() + edit.getLength());
                }
                catch (MalformedTreeException e) {
                    PlanningUIPlugin.log(e);
                }
                catch (BadLocationException e) {
                    PlanningUIPlugin.log(e);
                }
            }
        });
    }

    protected String createLink(IWorkItemHandle workItemHandle, boolean staticLink, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repository = PlanningClientPlugin.getTeamRepository((IItemHandle)workItemHandle);
        IItemManager itemManager = repository.itemManager();
        if (staticLink) {
            List<String> properties = Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IAuditable.ITEM_ID_PROPERTY, IWorkItem.TYPE_PROPERTY, IWorkItem.SUMMARY_PROPERTY);
            IWorkItem item = (IWorkItem)itemManager.fetchPartialItem((IItemHandle)workItemHandle, 0, properties, monitor);
            IWorkItemType workItemType = this.getWorkItemType(item, monitor);
            return WikiLinks.staticLink((IWorkItem)item, (IWorkItemType)workItemType);
        }
        List<String> properties = Arrays.asList(IWorkItem.PROJECT_AREA_PROPERTY, IAuditable.ITEM_ID_PROPERTY, IWorkItem.TYPE_PROPERTY);
        IWorkItem item = (IWorkItem)itemManager.fetchPartialItem((IItemHandle)workItemHandle, 0, properties, monitor);
        IWorkItemType workItemType = this.getWorkItemType(item, monitor);
        return WikiLinks.link((IWorkItem)item, (IWorkItemType)workItemType);
    }

    private IWorkItemType getWorkItemType(IWorkItem item, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient client = PlanningClientPlugin.getWorkItemClient((IItemHandle)item);
        IWorkItemType workItemType = client.findCachedWorkItemType(item.getProjectArea(), item.getWorkItemType());
        if (workItemType == null) {
            workItemType = client.findWorkItemType(item.getProjectArea(), item.getWorkItemType(), monitor);
        }
        return workItemType;
    }
}

