/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.apt.internal.ide.ui.editor.wiki.actions;

import com.ibm.team.apt.internal.client.PlanningClientPlugin;
import com.ibm.team.apt.internal.client.wiki.Attachments;
import com.ibm.team.apt.internal.client.wiki.ResolvedWikiPageAttachment;
import com.ibm.team.apt.internal.common.wiki.IWikiPageAttachment;
import com.ibm.team.apt.internal.ide.ui.ImagePool;
import com.ibm.team.apt.internal.ide.ui.editor.WikiFormPage2;
import com.ibm.team.apt.internal.ide.ui.editor.wiki.actions.Messages;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;

public class InsertAttachmentAction
extends Action {
    private WikiFormPage2 fPage;
    private MenuManager fMenuMgr;

    public InsertAttachmentAction(WikiFormPage2 page) {
        super(Messages.InsertAttachmentAction_LABEL, ImagePool.ADD_ATTACHMENT);
        this.fPage = page;
        this.fMenuMgr = new MenuManager(this.getText());
        this.fMenuMgr.setRemoveAllWhenShown(true);
        this.fMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                InsertAttachmentAction.this.fillMenu(manager);
            }
        });
    }

    public boolean isEnabled() {
        return this.fPage.getWikiPage() != null && !this.fPage.getWikiPage().getAttachments().isEmpty();
    }

    public MenuManager getMenuManager() {
        this.fMenuMgr.removeAll();
        this.fillMenu((IMenuManager)this.fMenuMgr);
        return this.fMenuMgr;
    }

    public void run() {
    }

    private void fillMenu(IMenuManager manager) {
        List attachments = this.fPage.getWikiPage().getAttachments();
        for (ResolvedWikiPageAttachment attachment : attachments) {
            manager.add((IAction)new InsertAction(attachment.getAttachment(), (ITextViewer)this.fPage.getViewer()));
        }
    }

    private static class InsertAction
    extends Action {
        private IWikiPageAttachment fAttachment;
        private final ITextViewer fViewer;

        public InsertAction(IWikiPageAttachment attachment, ITextViewer viewer) {
            super(attachment.getName());
            this.fAttachment = attachment;
            this.fViewer = viewer;
        }

        public void run() {
            int offset = this.fViewer.getTextWidget().getCaretOffset();
            String text = Attachments.asWiki((IWikiPageAttachment)this.fAttachment);
            InsertEdit edit = new InsertEdit(offset, text);
            try {
                edit.apply(this.fViewer.getDocument());
                this.fViewer.getTextWidget().setCaretOffset(edit.getOffset() + edit.getLength());
            }
            catch (MalformedTreeException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
            catch (BadLocationException e) {
                PlanningClientPlugin.log((Throwable)e);
            }
        }
    }
}

